/*
Copyright ⓒ Dark All Rights Reserved.
*/

var a = Renderer.createHumanoidRenderer();


function render(renderer) {
    var head = renderer.getModel().getPart("head");
    head.clear();

    var leftArm = renderer.getModel().getPart("leftArm");
    leftArm.clear();

    var rightArm = renderer.getModel().getPart("rightArm");
    rightArm.clear();

    var leftLeg = renderer.getModel().getPart("leftLeg");
    leftLeg.clear();

    var rightLeg = renderer.getModel().getPart("rightLeg");
    rightLeg.clear();

    var body = renderer.getModel().getPart("body");
    body.clear();

    for(var n = 0;n < 32;n++) {
        for(var i = 0;i < 16;i++) {
            var tan = Math.sin(i / 16 * Math.PI) * 4;
            var pcos = Math.cos(i / 16 * Math.PI) * 4;
            var sin = Math.sin(n / 16 * Math.PI);
            var cos = Math.cos(n / 16 * Math.PI);
            var x = 1 + ((23 + n) % 28);

            if (i < 4) {
                head.setTextureOffset (9 - sin * i / 2, 3 - cos * i / 2);
            }
            else if (i < 12) {
                head.setTextureOffset (x, i + 3);
            }
            else head.setTextureOffset (17 - sin * (i - 12) / 2, 3 + cos * (i - 12) / 2);
            head.addBox(sin * tan, -pcos - 2, cos * tan, 1, 1, 1);
        }
    }
    for(var i = 0;i < 16;i++) {
        for(var n = 0;n < 16;n++) {
            var tan = -Math.sin(i / 16 * Math.PI) * 2;
            var pcos = Math.cos(i / 32 * Math.PI) * 2;
            var sin = Math.sin(n / 8 * Math.PI);
            var cos = Math.cos(n / 8 * Math.PI);
            body.setTextureOffset (16 + ((20 + n) % 22), 20 + (16 - i) / 16 * 12);
            body.addBox(sin * tan, pcos * 6, cos * tan, 1, 1, 1);
        }
    }
    for(var n = 0;n < 12;n++) {
        leftArm.setTextureOffset (42, 18 + n * 10 / 12);
        leftArm.addBox(-3.5 + n / 3, n - 1, 0, 2, 2, 2);

        rightArm.setTextureOffset (42, 18 + n * 10 / 12);
        rightArm.addBox(2.5 - n / 3, n - 1, 0, 2, 2, 2);

        leftLeg.setTextureOffset (2, 18 + n * 10 / 12);
        leftLeg.addBox(-1.5 + n / 6, n, 0, 2, 2, 2);

        rightLeg.setTextureOffset (2, 18 + n * 10 / 12);
        rightLeg.addBox(0.5 - n / 6, n, 0, 2, 2, 2);
    }
}

render(a);

function modTick() {
    Entity.setRenderType(getPlayerEnt (), a.renderType);
}
