/*
var metNames[0]="normal"
var metNames[1]="snow"
var metNames[2]="fire"
var metNames[3]="monster"
var metNames[4]="glow"
var metNames[5]="nether"
var metNames[6]="end"
var metNames[7]="manMade"
var metNames[8]="king"
var metNames[9]="popper"
var metNames[10]="firePop"
*/

MET_NORM_ID=640;
MET_SNOW_ID=641;
MET_FIRE_ID=642;
MET_MONSTER_ID=643;
MET_GLOW_ID=644;
MET_NETHER_ID=645;
MET_END_ID=646;
MET_MANMADE_ID=647;
MET_KING_ID=648;
POPPER_ID=649;
FIREPOP_ID=650;

ModPE.setItem(MET_NORM_ID, "meteor", 0, "Meteor Spawner");
ModPE.setItem(MET_SNOW_ID, "meteor", 1, "Snow Meteor Spawner");
ModPE.setItem(MET_FIRE_ID, "meteor", 3, "Fire Meteor Spawner");
ModPE.setItem(MET_MONSTER_ID, "meteor", 4, "Monster Meteor Spawner");
ModPE.setItem(MET_GLOW_ID, "meteor", 5, "Glowstone Meteor Spawner");
ModPE.setItem(MET_NETHER_ID, "meteor", 6, "Nether Meteor Spawner");
ModPE.setItem(MET_END_ID, "meteor", 7, "End Meteor Spawner");
ModPE.setItem(MET_MANMADE_ID, "meteor", 8, "Man Made Meteor Spawner");
ModPE.setItem(MET_KING_ID, "meteor", 9, "King Meteor Spawner");
ModPE.setItem(POPPER_ID, "popper", 0, "Popper");
ModPE.setItem(FIREPOP_ID, "popper", 1, "Fire Popper");

var meteors=[];
var kingMets=[];			//[x, y, z, r, xup, zup]

var metBroadcast=0;
var metRandomSpawn=0;
var metTick=3000+Math.floor(Math.random()*21000);

var popTick=2000+Math.floor(Math.random()*10500);
var popNumb=0;
var popType=0;
var popTimer=0;

function newLevel(){
	clientMessage("Meteors Mod V2 by "+ChatColor.BLUE+"Dr Lazuli");
	Player.addItemCreativeInv(MET_NORM_ID, 1, 0);
	Player.addItemCreativeInv(MET_SNOW_ID, 1, 0);
	Player.addItemCreativeInv(MET_FIRE_ID, 1, 0);
	Player.addItemCreativeInv(MET_MONSTER_ID, 1, 0);
	Player.addItemCreativeInv(MET_GLOW_ID, 1, 0);
	Player.addItemCreativeInv(MET_NETHER_ID, 1, 0);
	Player.addItemCreativeInv(MET_END_ID, 1, 0);
	Player.addItemCreativeInv(MET_MANMADE_ID, 1, 0);
	Player.addItemCreativeInv(MET_KING_ID, 1, 0);
	Player.addItemCreativeInv(POPPER_ID, 1, 0);
	Player.addItemCreativeInv(FIREPOP_ID, 1, 0);
	
	meteors=[];
	kingMets=[];
	var metRandomSpawn=0;
	popNumb=0;
	popTimer=0;
	
	if (java.io.File(android.os.Environment.getExternalStorageDirectory().getPath()+"/games/com.mojang/minecraftWorlds/"+Level.getWorldDir()+"/kingMets.txt").exists()){
		var loadKM=loadFile(android.os.Environment.getExternalStorageDirectory().getPath()+"/games/com.mojang/minecraftWorlds/"+Level.getWorldDir()+"/", "kingMets.txt");
		if (loadKM!=""){
			var loadKMs=loadKM.split("\n");
			for (i in loadKMs){
				kingMets.push(eval(loadKMs[i]));
			}
		}
	}
}

function leaveGame(){
	var saveKM="";
	for (i in kingMets){
		saveKM=saveKM+"["+kingMets[i]+"]";
		if (i<kingMets.length-1){
			saveKM=saveKM+"\n";
		}
	}
	saveFile(android.os.Environment.getExternalStorageDirectory().getPath()+"/games/com.mojang/minecraftWorlds/"+Level.getWorldDir()+"/", "kingMets.txt", saveKM);
}

function useItem(x, y, z, i, b, s){
	switch (i){
		case MET_NORM_ID:
			spawnMet(x, y+80, z, i);
		break;
		
		case MET_SNOW_ID:
			spawnMet(x, y+80, z, i);
		break;
		
		case MET_FIRE_ID:
			spawnMet(x, y+80, z, i);
		
		case MET_MONSTER_ID:
			spawnMet(x, y+80, z, i);
		break;
		
		case MET_GLOW_ID:
			spawnMet(x, y+80, z, i);
		break;
		
		case MET_NETHER_ID:
			spawnMet(x, y+80, z, i);
		break;
		
		case MET_END_ID:
			spawnMet(x, y+80, z, i);
		break;
		
		case MET_MANMADE_ID:
			spawnMet(x, y+80, z, i);
		break;
		
		case MET_KING_ID:
			if (kingMets.length==0 && findMet(MET_KING_ID)<0){
				spawnMet(x, y+80, z, i);
			}
			else{
				clientMessage(ChatColor.RED+"Please do not spawn multiple King Meteors!");
			}
		break;
		
		case POPPER_ID:
			spawnMet(x, y+80, z, i);
		break;
		
		case FIREPOP_ID:
			spawnMet(x, y+80, z, i);
		break;
		
		default: break;
	}
}

function spawnMet(x, y, z, type){
	if (Player.getDimension()==DimensionId.NORMAL){
		var theMet = Level.spawnMob(x, y, z, 81);
		Entity.setVelX(theMet, 0);
		Entity.setVelY(theMet, 0);
		Entity.setVelZ(theMet, 0);
		meteors.push([theMet, type, x, y, z]);
	}
}

function entityRemovedHook(e){
	var metType = getMetType(e);
	var metID = getMetID(e);
	switch(metType){
		case MET_NORM_ID:
			buildMet(meteors[metID][2], meteors[metID][3], meteors[metID][4], metType);
		break;
		
		case MET_SNOW_ID:
			buildMet(meteors[metID][2], meteors[metID][3], meteors[metID][4], metType);
		break;
		
		case MET_FIRE_ID:
			buildMet(meteors[metID][2], meteors[metID][3], meteors[metID][4], metType);
		break;
		
		case MET_MONSTER_ID:
			buildMet(meteors[metID][2], meteors[metID][3], meteors[metID][4], metType);
		break;
		
		case MET_GLOW_ID:
			buildMet(meteors[metID][2], meteors[metID][3], meteors[metID][4], metType);
		break;
		
		case MET_NETHER_ID:
			buildMet(meteors[metID][2], meteors[metID][3], meteors[metID][4], metType);
		break;
		
		case MET_END_ID:
			buildMet(meteors[metID][2], meteors[metID][3], meteors[metID][4], metType);
		break;
		
		case MET_MANMADE_ID:
			buildMet(meteors[metID][2], meteors[metID][3], meteors[metID][4], metType);
		break;
		
		case MET_KING_ID:
			buildMet(meteors[metID][2], meteors[metID][3], meteors[metID][4], metType);
		break;
		
		case POPPER_ID:
			var xx=Math.floor(meteors[metID][2]);
			var yy=Math.floor(meteors[metID][3]);
			var zz=Math.floor(meteors[metID][4]);
			Level.explode(xx, yy, zz, 1);
		break;
		
		case FIREPOP_ID:
			var xx=Math.floor(meteors[metID][2]);
			var yy=Math.floor(meteors[metID][3]);
			var zz=Math.floor(meteors[metID][4]);
			var foundGround=0;
			var i=-2;
			while (i<=2 && !foundGround){
				if (Level.getTile(xx, yy+i, zz)==0){
					Level.setTile(xx, yy+i, zz, 51);
					foundGround=1;
				}
				i++;
			}
		break;
		
		default: break;
	}
}

function buildMet(x, y, z, type){
	switch(type){
		case MET_NORM_ID:
			var radius=2+Math.floor(Math.random()*4);
			Level.explode(x, y, z, radius*2);
			for (xx=-radius; xx<=radius; xx+=1){
			for (yy=-radius; yy<=radius; yy+=1){
			for (zz=-radius; zz<=radius; zz+=1){
				if (Math.sqrt(Math.pow(xx,2) + Math.pow(yy,2) + Math.pow(zz,2)) < radius){
				if (Level.getTile(Math.round(x+xx), Math.round(y+yy), Math.round(z+zz))!=95 && Level.getTile(Math.round(x+xx), Math.round(y+yy), Math.round(z+zz))!=7){
					var rockTypes=[0, 1, 1, 4, 4];
					var rockType=rockTypes[Math.floor(Math.random()*rockTypes.length)];
					if (rockType==0){
						var rockTypes=[16, 15, 16, 15, 16, 11];
						var rockType=rockTypes[Math.floor(Math.random()*rockTypes.length)];
					}
					Level.setTile(Math.round(x)+xx, Math.round(y)+yy, Math.round(z)+zz, rockType);
				}
				}
			}
			}
			}
		break;
		
		case MET_SNOW_ID:
			var radius=2+Math.floor(Math.random()*4);
			Level.explode(x, y, z, radius*2);
			for (xx=-radius; xx<=radius; xx+=1){
			for (yy=-radius; yy<=radius; yy+=1){
			for (zz=-radius; zz<=radius; zz+=1){
				if (Math.sqrt(Math.pow(xx,2) + Math.pow(yy,2) + Math.pow(zz,2)) < radius){
				if (Level.getTile(Math.round(x+xx), Math.round(y+yy), Math.round(z+zz))!=95 && Level.getTile(Math.round(x+xx), Math.round(y+yy), Math.round(z+zz))!=7){
					var rockTypes=[0, 79, 80, 79, 80];
					var rockType=rockTypes[Math.floor(Math.random()*rockTypes.length)];
					if (rockType==0){
						var rockType=174;
					}
					Level.setTile(Math.round(x)+xx, Math.round(y)+yy, Math.round(z)+zz, rockType);
				}
				}
			}
			}
			}
		break;
		
		case MET_FIRE_ID:
			var radius=2+Math.floor(Math.random()*4);
			Level.explode(x, y, z, radius*2);
			for (xx=-radius; xx<=radius; xx+=1){
			for (yy=-radius; yy<=radius; yy+=1){
			for (zz=-radius; zz<=radius; zz+=1){
				if (Math.sqrt(Math.pow(xx,2) + Math.pow(yy,2) + Math.pow(zz,2)) < radius){
				if (Level.getTile(Math.round(x+xx), Math.round(y+yy), Math.round(z+zz))!=95 && Level.getTile(Math.round(x+xx), Math.round(y+yy), Math.round(z+zz))!=7){
					var rockTypes=[0, 1, 4, 11, 11, 11];
					var rockType=rockTypes[Math.floor(Math.random()*rockTypes.length)];
					if (rockType==0){
						var rockTypes=[16, 15, 16, 14];
						var rockType=rockTypes[Math.floor(Math.random()*rockTypes.length)];
					}
					Level.setTile(Math.round(x)+xx, Math.round(y)+yy, Math.round(z)+zz, rockType);
				}
				}
			}
			}
			}
		break;
		
		case MET_MONSTER_ID:
			var radius=8+Math.floor(Math.random()*4);
			Level.explode(x, y, z, radius*2);
			for (xx=-radius; xx<=radius; xx+=1){
			for (yy=-radius; yy<=radius; yy+=1){
			for (zz=-radius; zz<=radius; zz+=1){
				if (Math.sqrt(Math.pow(xx,2) + Math.pow(yy,2) + Math.pow(zz,2)) < radius){
				if (Level.getTile(Math.round(x+xx), Math.round(y+yy), Math.round(z+zz))!=95 && Level.getTile(Math.round(x+xx), Math.round(y+yy), Math.round(z+zz))!=7){
				var rockTypes=[0, 1, 1, 4, 4, 11, 49, 49, 246, 246];
				var rockType=rockTypes[Math.floor(Math.random()*rockTypes.length)];
				if (rockType==0){
					var rockTypes=[14, 15, 16, 16, 16, 21, 56, 73, 129];
					var rockType=rockTypes[Math.floor(Math.random()*rockTypes.length)];
				}
				Level.setTile(Math.round(x)+xx, Math.round(y)+yy, Math.round(z)+zz, rockType);
				}
				}
			}
			}
			}
		break;
		
		case MET_GLOW_ID:
			var radius=2+Math.floor(Math.random()*4);
			for (xx=-radius; xx<=radius; xx+=1){
			for (yy=-radius; yy<=radius; yy+=1){
			for (zz=-radius; zz<=radius; zz+=1){
				if (Math.sqrt(Math.pow(xx,2) + Math.pow(yy,2) + Math.pow(zz,2)) < radius){
				if (Level.getTile(Math.round(x+xx), Math.round(y+yy), Math.round(z+zz))!=95 && Level.getTile(Math.round(x+xx), Math.round(y+yy), Math.round(z+zz))!=7){
				var rockType=89;
				Level.setTile(Math.round(x)+xx, Math.round(y)+yy, Math.round(z)+zz, rockType);
				}
				}
			}
			}
			}
		break;
		
		case MET_NETHER_ID:
			var radius=6+Math.floor(Math.random()*2);
			Level.explode(x, y, z, radius*2);
			for (xx=-radius; xx<=radius; xx+=1){
			for (yy=-radius; yy<=radius; yy+=1){
			for (zz=-radius; zz<=radius; zz+=1){
				if (Math.sqrt(Math.pow(xx,2) + Math.pow(yy,2) + Math.pow(zz,2)) < radius){
				if (Level.getTile(Math.round(x+xx), Math.round(y+yy), Math.round(z+zz))!=95 && Level.getTile(Math.round(x+xx), Math.round(y+yy), Math.round(z+zz))!=7){
					var rockTypes=[0, 87, 87, 87, 87, 87, 87, 88, 88, 51, 51, 11];
					var rockType=rockTypes[Math.floor(Math.random()*rockTypes.length)];
					if (rockType==0){
						var rockType=153;
					}
					Level.setTile(Math.round(x)+xx, Math.round(y)+yy, Math.round(z)+zz, rockType);
				}
				}
			}
			}
			}
		break;
		
		case MET_END_ID:
			var radius=6+Math.floor(Math.random()*2);
			Level.explode(x, y, z, radius*2);
			for (xx=-radius; xx<=radius; xx+=1){
			for (yy=-radius; yy<=radius; yy+=1){
			for (zz=-radius; zz<=radius; zz+=1){
				if (Math.sqrt(Math.pow(xx,2) + Math.pow(yy,2) + Math.pow(zz,2)) < radius){
				if (Level.getTile(Math.round(x+xx), Math.round(y+yy), Math.round(z+zz))!=95 && Level.getTile(Math.round(x+xx), Math.round(y+yy), Math.round(z+zz))!=7){
					var rockTypes=[121, 49];
					var rockType=rockTypes[Math.floor(Math.random()*rockTypes.length)];
					Level.setTile(Math.round(x)+xx, Math.round(y)+yy, Math.round(z)+zz, rockType);
				}
				}
			}
			}
			}
		break;
		
		case MET_MANMADE_ID:
			var radius=2+Math.floor(Math.random()*2);
			Level.explode(x, y, z, radius*2);
			for (xx=-radius; xx<=radius; xx+=1){
			for (yy=-radius; yy<=radius; yy+=1){
			for (zz=-radius; zz<=radius; zz+=1){
				if (Math.sqrt(Math.pow(xx,2) + Math.pow(yy,2) + Math.pow(zz,2)) < radius){
				if (Level.getTile(Math.round(x+xx), Math.round(y+yy), Math.round(z+zz))!=95 && Level.getTile(Math.round(x+xx), Math.round(y+yy), Math.round(z+zz))!=7){
					var rockTypes=[0, 20, 58, 170, 61, 47, 46, 5, 5, 5];
					var rockType=rockTypes[Math.floor(Math.random()*rockTypes.length)];
					if (rockType==0){
						var rockTypes=[54, 54, 145];
						var rockType=rockTypes[Math.floor(Math.random()*rockTypes.length)];
					}
					Level.setTile(Math.round(x)+xx, Math.round(y)+yy, Math.round(z)+zz, rockType);
				}
				}
			}
			}
			}
		break;
		
		case MET_KING_ID:
			var radius=20+Math.floor(Math.random()*8);
			kingMets.push([Math.round(x), Math.round(y), Math.round(z), radius, -radius, -radius]);
		break;
		
		default: break;
	}
}

function procCmd(c){
	var cmd = c.split(" ");
	
	if (cmd[0]="met")
		if (cmd[1]=="spawn"){
			if (cmd[2]=="on" || cmd[2]=="1" || cmd[2]=="true"){
				metRandomSpawn=1;
				clientMessage(ChatColor.RED+"Meteors will now spawn.");
			}
			if (cmd[2]=="off" || cmd[2]=="0" || cmd[2]=="false"){
				metRandomSpawn=0;
				clientMessage(ChatColor.RED+"Meteors will no longer spawn.");
			}
		}
		
		if (cmd[1]=="broadcast"){
			if (cmd[2]=="on" || cmd[2]=="1" || cmd[2]=="true"){
				metBroadcast=1;
				clientMessage(ChatColor.RED+"Listening for meteors...");
			}
			if (cmd[2]=="off" || cmd[2]=="0" || cmd[2]=="false"){
				metBroadcast=0;
				clientMessage(ChatColor.RED+"Standing by.");
			}
		}
		
		if (cmd[1]=="start"){
			metTick=metTick=300+Math.floor(Math.random()*2100);
			metRandomSpawn=1;
			metBroadcast=1;
			clientMessage(ChatColor.RED+"Meteor spawn on.");
			clientMessage(ChatColor.RED+"Meteor broadcast on.");
		}
		
		if (cmd[1]=="end"){
			metTick=metTick=300+Math.floor(Math.random()*2100);
			metRandomSpawn=0;
			metBroadcast=0;
			clientMessage(ChatColor.RED+"Meteor spawn off.");
			clientMessage(ChatColor.RED+"Meteor broadcast off.");
		}
		
		if (cmd[1]=="create"){
			makeMet();
		}
		
		if (cmd[1]=="storm"){
			makeStorm();
		}
}

function makeMet(){
	var x=Math.floor(Player.getX());
	var z=Math.floor(Player.getZ());
	var y=Math.floor(Player.getY());
	
	var xx=x-48+Math.floor(Math.random()*96);
	var zz=z-48+Math.floor(Math.random()*96);
	
	var metTypes=[MET_NORM_ID, MET_NORM_ID, MET_NORM_ID, MET_NORM_ID, MET_FIRE_ID, MET_FIRE_ID, MET_FIRE_ID, MET_SNOW_ID, MET_SNOW_ID, MET_MONSTER_ID, MET_NETHER_ID, MET_END_ID, -1];
	var metType=metTypes[Math.floor(Math.random()*metTypes.length)];
	
	if (metType==-1){
		var metTypes=[MET_GLOW_ID, MET_GLOW_ID, MET_GLOW_ID, MET_GLOW_ID, MET_GLOW_ID, MET_MANMADE_ID, MET_KING_ID];
		var metType=metTypes[Math.floor(Math.random()*metTypes.length)];
	}
	
	spawnMet(xx, y+80, zz, metType);
	
	if (metBroadcast){
		switch(metType){
			case MET_NORM_ID:
				clientMessage(ChatColor.RED+"[WARNING] A meteor has been sighted nearby!");
			break;
			
			case MET_SNOW_ID:
				clientMessage(ChatColor.RED+"[WARNING] A frosty meteor has been spotted!");
			break;
			
			case MET_FIRE_ID:
				clientMessage(ChatColor.RED+"[WARNING] A fiery meteor has entered the atmosphere!");
			break;
			
			case MET_MONSTER_ID:
				clientMessage(ChatColor.RED+"[WARNING] A massive meteor has been spotted!");
			break;
			
			case MET_GLOW_ID:
				clientMessage(ChatColor.RED+"[Attention] A rare glowing meteor has been located!");
			break;
			
			case MET_NETHER_ID:
				clientMessage(ChatColor.RED+"[WARNING] A red hot nether meteor has been sighted!");
			break;
			
			case MET_END_ID:
				clientMessage(ChatColor.RED+"[WARNING] An end stone meteor has been spotted!");
			break;
			
			case MET_MANMADE_ID:
				clientMessage(ChatColor.RED+"[Attention] A strange man-made meteor has been located!");
			break;
			
			case MET_KING_ID:
				clientMessage(ChatColor.RED+"[WARNING] A world ending meteor has been spotted!!!");
				clientMessage(ChatColor.RED+"DO NOT PANIC!!!");
			break;
			
			default: break;
		}
	}
}

function makePop(type){
	var x=Math.floor(Player.getX());
	var z=Math.floor(Player.getZ());
	var y=Math.floor(Player.getY());
	
	var xx=x-10+Math.floor(Math.random()*20);
	var zz=z-10+Math.floor(Math.random()*20);
	
	if (type){
		spawnMet(xx, y+80, zz, POPPER_ID);
	}
	else{
		spawnMet(xx, y+80, zz, FIREPOP_ID);
	}
}

function makeStorm(){
	popType=Math.floor(Math.random()*2);
	if (popType){
		popNumb=3+Math.floor(Math.random()*12);
		if (metBroadcast){
			clientMessage(ChatColor.RED+"[WARNING] A popper storm has begun!");
		}
	}
	else{
		popNumb=3+Math.floor(Math.random()*25);
		if (metBroadcast){
			clientMessage(ChatColor.RED+"[WARNING] The fiery remains of a meteor are falling!");
		}
	}
	popTimer=5+Math.floor(Math.random()*35);
}

function modTick(){
	if (meteors.length>0){
	for (i=0; i<meteors.length; i++){
		xx=Entity.getX(meteors[i][0]);
		yy=Entity.getY(meteors[i][0]);
		zz=Entity.getZ(meteors[i][0]);
		if (!(xx==0 && yy==0 && zz==0)){
			meteors[i]=[meteors[i][0], meteors[i][1], xx, yy, zz];
		}
	}
	}
	
	if (metTick>0){
		metTick--;
	}
	else{
		if (metRandomSpawn){
			makeMet();
		}
		metTick=3000+Math.floor(Math.random()*21000);
	}
	
	if (popTick>0){
		if (popNumb<=0){
			popTick--;
		}
	}
	else{
		if (metRandomSpawn){
			makeStorm();
		}
		popTick=2000+Math.floor(Math.random()*10500);
	}
	
	if (popTimer>0){
		popTimer--;
	}
	else{
		if (popNumb>0){
			makePop(popType);
			popNumb--;
			popTimer=5+Math.floor(Math.random()*35);
		}
	}
	
	if (kingMets.length>0){
	for (i=0; i<kingMets.length; i++){
		for (yy=Math.max(-kingMets[i][3], -kingMets[i][1]); yy<=kingMets[i][3]; yy++){
			if (Math.sqrt(Math.pow(kingMets[i][4],2) + Math.pow(yy,2) + Math.pow(kingMets[i][5],2)) < kingMets[i][3]){
			if (Level.getTile(Math.round(kingMets[i][0]+kingMets[i][4]), Math.round(kingMets[i][1]+yy), Math.round(kingMets[i][2]+kingMets[i][5]))!=95 && Level.getTile(Math.round(kingMets[i][0]+kingMets[i][4]), Math.round(kingMets[i][1]+yy), Math.round(kingMets[i][2]+kingMets[i][5]))!=7){
				var rockTypes=[0, 1, 1, 3, 4, 87, 87, 121, 121, 49, 49, 49, 49, 246, 246, 246, 246, 246, 88];
				var rockType=rockTypes[Math.floor(Math.random()*rockTypes.length)];
				if (rockType==0){
					var rockTypes=[14, 15, 16, 16, 16, 21, 56, 73, 129, 153, 89, 11, 11, 11, 11];
					var rockType=rockTypes[Math.floor(Math.random()*rockTypes.length)];
				}
				Level.setTile(Math.round(kingMets[i][0])+kingMets[i][4], Math.round(kingMets[i][1])+yy, Math.round(kingMets[i][2])+kingMets[i][5], rockType);
			}
			}
		}
		kingMets[i][4]++;
		if (kingMets[i][4]>kingMets[i][3]){
			kingMets[i][4]=-kingMets[i][3];
			kingMets[i][5]++;
		}
		if (kingMets[i][5]>kingMets[i][3]){
			kingMets.splice(i, 1);
			i--;
		}
	}
	}
}

function getMetType(e){
	rtrn=-1;
	for (i=0; i<meteors.length; i++){
		if (e==meteors[i][0]){
			rtrn=meteors[i][1];
		}
	}
	return rtrn;
}

function getMetID(e){
	rtrn=-1;
	for (i=0; i<meteors.length; i++){
		if (e==meteors[i][0]){
			rtrn=i;
		}
	}
	return rtrn;
}

function findMet(type){
	rtrn=-1;
	for (i=0; i<meteors.length; i++){
		if (type==meteors[i][1]){
			rtrn=i;
		}
	}
	return rtrn;
}

function saveFile(path, filename, content){
	try{
		java.io.File(path).mkdirs();
		var newFile = new java.io.File(path, filename);
		newFile.createNewFile();
		var outWrite = new java.io.OutputStreamWriter(new java.io.FileOutputStream(newFile));
		outWrite.append(content);
		outWrite.close();
	}catch(err){
		clientMessage(err);
	}
}

function loadFile(path, filename){
	var content = "";
	if (java.io.File(path+filename).exists()){
		var file = new java.io.File(path + filename);
		var fin = new java.io.FileInputStream(file);
		var str = new java.lang.StringBuilder();
		var ch;
		while ((ch = fin.read()) != -1){
			str.append(java.lang.Character(ch));
		}
		content = String(str.toString());
		fin.close();
	}
	return content;
}