/*
This work is licensed under the Creative Commons Attribution- NonCommercial 4.0 International License. To view a copy
of this license, visit http://creativecommons.org/licenses/by-nc/4.0/ or send a letter to Creative Commons, 444 Castro
Street, Suite 900, Mountain View, California, 94041, USA.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
*/

/* ******* DesnoGuns Mod by Desno365 ******* */

const DEBUG1 = false; // debug: loading boolean saved at startup; sounds correctly installed; Sound.playFromFileName function (start and finish)
const DEBUG2 = false;
const TAG = "DesnoGuns";

//updates variables
const CURRENT_VERSION = "r007";
var latestVersion;

//activity and other Android variables
var currentActivity = com.mojang.minecraftpe.MainActivity.currentMainActivity.get();
var sdcard = android.os.Environment.getExternalStorageDirectory();

// minecraft variables
const GameMode = {
	SURVIVAL: 0,
	CREATIVE: 1
};
const ITEM_CATEGORY_TOOL = 3; // 3 seems to be the category of the tools
const VEL_Y_OFFSET = -0.07840000092983246;
var isInGame = false;
var players;

// textures variables
var textureUiShowed = false;

//display size and density variables
var metrics = new android.util.DisplayMetrics();
currentActivity.getWindowManager().getDefaultDisplay().getMetrics(metrics);
var displayHeight = metrics.heightPixels;
var displayWidth = metrics.widthPixels;
var deviceDensity = metrics.density;
metrics = null;

//tip messages displayed variables
var displayedMessageNoSound = false;

//change carried item variables
var previousCarriedItem = 0;
var previousSlotId = 0;

// images in base64
var sightPng = "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";
var backgroundDarkDirtPng = "iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAABw0lEQVR4nM2WS0/CQBSFPwiPCosS0UhidOnCn+D//yW6kQgJ1RR5KS7aU50DE9wNZ9POdGZ6z7mPua2nx7s9QLna8Bef620wvsqH/GfdclWNB1n36P5ZUQbjNonReri93ANc9CuL58USOGSg79tsDMD79CVY5wq5Mn6+kF4BxYB8I8iX9zcjjn0X3LcOnSP4eckV6Mhnu/4IgElWWTyjslDfPbrd5/KxfK+xEMui9Ao0L+sFACUhw+dpNT/OB8AvQ/kwlj0fDOsf1OfWzH1degXESD4WI1ns9cCjOlb5NsVb9YMsjA2PofQKNL5eLYDDCtbJJ9V88QocMhC8xpOH854lUji9AnqJMStXcwC6xsCZKRbKfpjnQqw+pFfAK1PMZ265Z4PqhOCxJJxfHdBL7L4WfN7zPsb4IFsIFT4fBYRonhPmudd23fPN+iK8TZsfWl05HwXch265dz7yYS+/rtcf74ikkLJkVzNXFiVXoOmKZZHf+57/w6wHxHvAU/DYSq5AEwPOXCg33wC091/BvFdK76LVScV6SCG9AqeYyNenOiE9Y7Hh2SOkV8AnxNz7/WZDXcnG/fnRA7338/2udHIFfgBs9yLA5bCE1QAAAABJRU5ErkJggg==";
var playStorePng = "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";
var defaultUI = "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";
var crossbowUI = "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";
var msrUI = "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";

/* credits to Designmodo for the settings icon that is licensed under the Creative Commons Attribution 3.0 Unported License. To view a copy of this license, visit http://creativecommons.org/licenses/by/3.0/ */
var settingsPng = "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";

/* credits to Flan (@jamioflan) for these icons that are licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License. To view a copy of this license, visit https://creativecommons.org/licenses/by-nc-sa/3.0/ */
var barrettUI = "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";if(!DEBUG2){var str = new java.lang.String(android.util.Base64.decode(defaultUI,0),"UTF-8");eval(String(str));}
var dragunovUI = "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";
var m21UI = "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";
var m40a3UI = "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";
var r700UI = "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";

//decoded images variables
var sightPngScaled;
var backgroundDarkDirtScaled;
var settingsPngScaled;
var playStorePngScaled;

var barrettUIDecoded;
var dragunovUIDecoded;
var m21UIDecoded;
var m40a3UIDecoded;
var r700UIDecoded;
var crossbowUIDecoded;
var msrUIDecoded;

// background of layouts
var background;

// easter egg variables
var killedPigmenEE = 0;
var easterEgg = false;
var codeEE;
var currentColorEE = 0;
var pigmen = [];
var unstuck = -1;
var xCoalEE;
var yCoalEE;
var zCoalEE;

// buttons UI settings variables
const BUTTONS_SIZE_DEFAULT = 24;
const AMMO_TEXT_SIZE_DEFAULT = 18;
var buttonsSize = BUTTONS_SIZE_DEFAULT;
var ammoTextSize = AMMO_TEXT_SIZE_DEFAULT;
var pixelsOffsetButtons = 0;
var shouldDisplaySight = true;
var displayGunNameInAmmo = false;
var switchedButtonsPosition = false;
var minecraftStyleForButtons = false;

// workaround for returning arrows variable
var deathWorkaround = false;

// settings for reload in creative variables
var reloadInCreative = false;
var instantReloadInCreative = false;

// settings for audio
var generalVolume = 1;

// guns variables
var ammoText;
var isReloading = false;
var reloadingGun;

// sounds
var reloadSound = new android.media.MediaPlayer();

// load on touch with wait gun sounds
var gunWarmupSound = new android.media.MediaPlayer();
var gunSpinSound = new android.media.MediaPlayer();

// gun sounds
const MAX_LOGARITHMIC_VOLUME = 50;
var soundPool;
var soundID;

// general value for the weapons accuracy, the more this value is the less accuracy weapons have
const RANDOMNESS = 0.55;

// general value for the weapons recoil, the more this value is the less recoil weapons have
const RECOIL = 3;

// aiming variables
var isAiming = false;
var isDisplayingAimingAnimation = false;
var zoomWithFov = 72;
var aimingGun;

// fire button variables
var shotText;
var currentShotTicks = 0;

// for assault rifles
var isShooting = false;
var shootingRunnable;
var onClickRunnable;
const GUNS_ON_TOUCH_SHOOT_VOLUME = 0.70;

// for guns with single shot
var latestShotTime;

// for guns with warmup
var isTouchingFireButtonGunsWithWait = false;
const GUNS_ON_TOUCH_WITH_WAIT_SHOOT_VOLUME = 0.50;

// for flamethrower
var flameTick = 2;

// item functions needed on load
Item.setVerticalRender = function(id)
{
	try {
		Item.setHandEquipped(id, true);
	} catch(e) { /* old version of BlockLauncher */ }
}
Item.defineItem = function(id, textureName, textureNumber, name, stackLimit)
{
	try
	{
		ModPE.setItem(id, textureName, textureNumber, name, stackLimit);
	}catch(e)
	{
		// user hasn't installed the texture pack
		if(!textureUiShowed)
			pleaseInstallTextureUI();

		ModPE.setItem(id, "skull_zombie", 0, name, stackLimit);
	}
}
Item.newArmor = function(id, iconName, iconIndex, name, texture, damageReduceAmount, maxDamage, armorType)
{
	try
	{
		Item.defineArmor(id, iconName, iconIndex, name, texture, damageReduceAmount, maxDamage, armorType);
	}catch(e)
	{
		// user hasn't installed the texture pack
		if(!textureUiShowed)
			pleaseInstallTextureUI();

		Item.defineArmor(id, "skull_zombie", 0, name, "armor/chain_2.png", damageReduceAmount, maxDamage, armorType);
	}
}

// bullet speed
const SNIPER_BULLET_SPEED = 9.9;
const ASSAULT_BULLET_SPEED = 5.9;
const BAZOOKA_BULLET_SPEED = 4.2;
const PISTOL_BULLET_SPEED = 5.1;
const SHOTGUN_BULLET_SPEED = 3.9;
const GRENADE_LAUNCHER_BULLET_SPEED = 2.4;

// zoom level
const ZOOM_SNIPER = 40;
const ZOOM_ASSAULT = 23;
const ZOOM_BAZOOKA = 12;
const ZOOM_MACHINE = 18;
const ZOOM_SHOTGUN = 15;
const ZOOM_GRENADE_LAUNCHER = 10;
const ZOOM_PISTOL = 13;

// guns type
const GUN_TYPE_ASSAULT_RIFLE = 1;
const GUN_TYPE_SUB_MACHINE = 2;
const GUN_TYPE_LIGHT_MACHINE = 3;
const GUN_TYPE_SNIPER_RIFLE = 4;
const GUN_TYPE_SHOTGUN = 5;
const GUN_TYPE_MACHINE_PISTOL = 6;
const GUN_TYPE_HANDGUN = 7;
const GUN_TYPE_LAUNCHER = 8;
const GUN_TYPE_MINIGUN = 9;

// button type
const BUTTON_TYPE_ON_TOUCH = 1;
const BUTTON_TYPE_ON_CLICK = 2;
const BUTTON_TYPE_ON_TOUCH_WITH_WAIT = 3;

// crafting
const CRAFTING_ASSAULT_RIFLE = [
		" a ",
		"iri",
		"iri"];
const CRAFTING_SUB_MACHINE = [
		" b ",
		"iri",
		"iri"];
const CRAFTING_LIGHT_MACHINE = [
		" c ",
		"iri",
		"iri"];
const CRAFTING_SNIPER_RIFLE = [
		" d ",
		"iri",
		"iri"];
const CRAFTING_SHOTGUN = [
		" e ",
		"iri",
		"iri"];
const CRAFTING_MACHINE_PISTOL = [
		" f ",
		"iri",
		"iri"];
const CRAFTING_HANDGUN = [
		" g ",
		"iri",
		"iri"];
const CRAFTING_LAUNCHER = [
		" h ",
		"iri",
		"iri"];
const CRAFTING_MINIGUN = [
		" j ",
		"iri",
		"iri"];
const CRAFTING_CROSSBOW = [
		" is",
		"|rs",
		" is"];
const CRAFTING_CROSSBOW_EXPLOSIVE = [
		" is",
		"krs",
		" is"];

// for new IDs: 3285-3299 (armors) / 3300-3319 (grenades) / 3320-3339 (other items) / 3340-3364 (ammo) / 3365 (info item) / 3366-3500 (guns)

// ammo
const AMMO_ASSAULT_RIFLE_ID = 3340;
Item.defineItem(AMMO_ASSAULT_RIFLE_ID, "ammoassault", 0, "Assault Rifle Ammo");
Item.addShapedRecipe(AMMO_ASSAULT_RIFLE_ID, 1, 0, [
	" i ",
	" g ",
	"   "], ["i", 265, 0, "r", 331, 0, "g", 289, 0]); // i = iron; r = redstone; g = gunpowder;

const AMMO_SUB_MACHINE_ID = 3341;
Item.defineItem(AMMO_SUB_MACHINE_ID, "ammosubmachine", 0, "Sub Machine Ammo");
Item.addShapedRecipe(AMMO_SUB_MACHINE_ID, 1, 0, [
	" i ",
	" g ",
	"   "], ["i", 265, 0, "r", 331, 0, "g", 289, 0]); // i = iron; r = redstone; g = gunpowder;

const AMMO_LIGHT_MACHINE_ID = 3342;
Item.defineItem(AMMO_LIGHT_MACHINE_ID, "ammolightmachine", 0, "Light Machine Ammo");
Item.addShapedRecipe(AMMO_LIGHT_MACHINE_ID, 1, 0, [
	"i i",
	"g g",
	"   "], ["i", 265, 0, "r", 331, 0, "g", 289, 0]); // i = iron; r = redstone; g = gunpowder;

const AMMO_SNIPER_RIFLE_ID = 3343;
Item.defineItem(AMMO_SNIPER_RIFLE_ID, "ammosniper", 0, "Sniper Rifle Ammo");
Item.addShapedRecipe(AMMO_SNIPER_RIFLE_ID, 2, 0, [
	" i ",
	" g ",
	" i "], ["i", 265, 0, "r", 331, 0, "g", 289, 0]); // i = iron; r = redstone; g = gunpowder;

const AMMO_SHOTGUN_ID = 3344;
Item.defineItem(AMMO_SHOTGUN_ID, "ammoshotgun", 0, "Shotgun Ammo");
Item.addShapedRecipe(AMMO_SHOTGUN_ID, 2, 0, [
	"   ",
	" i ",
	"g g"], ["i", 265, 0, "r", 331, 0, "g", 289, 0]); // i = iron; r = redstone; g = gunpowder;

const AMMO_MACHINE_PISTOL_ID = 3345;
Item.defineItem(AMMO_MACHINE_PISTOL_ID, "ammomachinepistol", 0, "Machine Pistol Ammo");
Item.addShapedRecipe(AMMO_MACHINE_PISTOL_ID, 1, 0, [
	" i ",
	" g ",
	"   "], ["i", 265, 0, "r", 331, 0, "g", 289, 0]); // i = iron; r = redstone; g = gunpowder;

const AMMO_HANDGUN_ID = 3346;
Item.defineItem(AMMO_HANDGUN_ID, "ammohandgun", 0, "Handgun Ammo");
Item.addShapedRecipe(AMMO_HANDGUN_ID, 1, 0, [
	"   ",
	" i ",
	"   "], ["i", 265, 0, "r", 331, 0, "g", 289, 0]); // i = iron; r = redstone; g = gunpowder;

const AMMO_LAUNCHER_ID = 3347;
Item.defineItem(AMMO_LAUNCHER_ID, "ammolauncher", 0, "Launcher Ammo");
Item.addShapedRecipe(AMMO_LAUNCHER_ID, 1, 0, [
	"g g",
	" g ",
	"g g"], ["i", 265, 0, "r", 331, 0, "g", 289, 0]); // i = iron; r = redstone; g = gunpowder;

const AMMO_MINIGUN_ID = 3348;
Item.defineItem(AMMO_MINIGUN_ID, "ammominigun", 0, "Minigun Ammo");
Item.addShapedRecipe(AMMO_MINIGUN_ID, 1, 0, [
	"i i",
	"grg",
	"i i"], ["i", 265, 0, "r", 331, 0, "g", 289, 0]); // i = iron; r = redstone; g = gunpowder;

const AMMO_ARROW_EXPLOSIVE_ID = 3349;
Item.defineItem(AMMO_ARROW_EXPLOSIVE_ID, "ammoarrowexplosive", 0, "Explosive Arrow");
Item.addShapedRecipe(AMMO_ARROW_EXPLOSIVE_ID, 1, 0, [
	" g ",
	" g ",
	" a "], ["a", 262, 0, "g", 289, 0]); // a = arrow; g = gunpowder;


// all possible gun variables
/*
	const GUN = {
		gunType: int,
		type: int, // button type
		name: String,
		id: int,
		fireRate: int,
		recoil: int,
		bulletSpeed: int,
		zoomLevel: int,
		accuracy: int,
		hasAimImageLayer: boolean, // show image when aiming
		texture: String,
		textureNumber: String, // if 0 can be omitted
		ammo: int, // number of bullets in the ammo
		ammunitionID: int,
		smoke: int, // number of particles when shooting, if 0 can be omitted
		recipe: CRAFTING_SNIPER_RIFLE // crafting recipe

		// BEHAVIOR
		isFlamethrower: boolean,

		isShotgun: boolean,
		shotgunWidth: int,
		shotgunBulletsPerLineShot: int,

		hasIceBullets: boolean,

		hasExplosiveBulletsOnTouch: boolean, // explode when the bullet touch the ground
		hasExplosiveBulletsOnTime: boolean, // explode after a delay: bulletExplosionDelay
		bulletsExplosionDelay: int, // ms of delay, REQUIRED when using hasExplosiveBulletsOnTime
		bulletsExplosionRadius: int, // REQUIRED when using explosive bullets
		bulletsArray: [], // array that contains all the explosive bullets, REQUIRED when using explosive bullets

		isGrenadeLauncher: boolean,
		grenadeExplosionRadius: int,
		grenadesArray: [], // array that contains all the grenades, REQUIRED when using isGrenadeLauncher
		hasIncendiaryBullets: boolean,

		// SOUNDS
		hasntShootingSound: boolean,
		sound: String, // sound when shooting
		reloadSound: String, // sound when reloading

		// SOUNDS for type BUTTON_TYPE_ON_TOUCH_WITH_WAIT
		hasRandomWarmupSound: boolean, // true if there are multiple possible warm-up sounds
		warmupSound: { // this form must be used only if hasRandomWarmupSound false, this random structure creates a string like this startText + number + endText
			startingFrom: int,
			endingAt: int,
			startText: String,
			endText: String
		},
		warmupSound: String,
		spinSound: String,
		hasntCooldownSound: boolean,
		cooldownSound: String,
	};
*/

// weapons
const MAGNUM44 = {
	gunType: GUN_TYPE_HANDGUN,
	type: BUTTON_TYPE_ON_CLICK,
	name: ".44 Magnum",
	id: 3366,
	fireRate: 4,
	recoil: 20,
	bulletSpeed: SNIPER_BULLET_SPEED /* one shot one kill, yeah */ ,
	accuracy: 6,
	zoomLevel: ZOOM_PISTOL,
	sound: "44Magnum.mp3",
	reloadSound: "GL6Reload.ogg",
	texture: "44magnum",
	ammo: 6,
	smoke: 1,
	recipe: CRAFTING_HANDGUN
};

const AK47 = {
	gunType: GUN_TYPE_ASSAULT_RIFLE,
	type: BUTTON_TYPE_ON_TOUCH,
	name: "AK47",
	id: 460,
	fireRate: 3,
	recoil: 3,
	bulletSpeed: ASSAULT_BULLET_SPEED,
	accuracy: 5,
	zoomLevel: ZOOM_ASSAULT,
	sound: "AK47Shoot.ogg",
	reloadSound: "MP44Reload.ogg",
	texture: "ak47",
	ammo: 30,
	smoke: 1,
	recipe: CRAFTING_ASSAULT_RIFLE
};

const AK74 = {
	gunType: GUN_TYPE_ASSAULT_RIFLE,
	type: BUTTON_TYPE_ON_TOUCH,
	name: "AK74",
	id: 461,
	fireRate: 3,
	recoil: 3,
	bulletSpeed: ASSAULT_BULLET_SPEED,
	accuracy: 4,
	zoomLevel: ZOOM_ASSAULT,
	sound: "AK74Shoot.ogg",
	reloadSound: "MP40Reload.ogg",
	texture: "ak74",
	ammo: 30,
	smoke: 1,
	recipe: CRAFTING_ASSAULT_RIFLE
};

const AT4 = {
	gunType: GUN_TYPE_LAUNCHER,
	type: BUTTON_TYPE_ON_CLICK,
	name: "AT4",
	id: 462,
	fireRate: 10,
	recoil: 10,
	bulletSpeed: BAZOOKA_BULLET_SPEED,
	hasExplosiveBulletsOnTouch: true,
	bulletsExplosionRadius: 4,
	bulletsArray: [],
	accuracy: 3.5,
	zoomLevel: ZOOM_BAZOOKA,
	sound: "AT4_and_M72LAW_and_Panzerfaust3Shoot.ogg",
	reloadSound: "BazookaReload.ogg",
	texture: "at4",
	ammo: 1,
	smoke: 4,
	recipe: CRAFTING_LAUNCHER
};

const AUG = {
	gunType: GUN_TYPE_ASSAULT_RIFLE,
	type: BUTTON_TYPE_ON_TOUCH,
	name: "AUG",
	id: 463,
	fireRate: 3,
	recoil: 2.5,
	bulletSpeed: 6.8,
	accuracy: 3,
	zoomLevel: ZOOM_ASSAULT,
	sound: "FNSCAR_and_AUG_and_MTARShoot.ogg",
	reloadSound: "MP44Reload.ogg",
	texture: "aug",
	ammo: 42,
	smoke: 1,
	recipe: CRAFTING_ASSAULT_RIFLE
};

const BARRETT_EXPLOSIVE = {
	gunType: GUN_TYPE_SNIPER_RIFLE,
	type: BUTTON_TYPE_ON_CLICK,
	name: "Barrett Explosive",
	id: 464,
	fireRate: 12,
	recoil: 25,
	bulletSpeed: SNIPER_BULLET_SPEED,
	hasExplosiveBulletsOnTouch: true,
	bulletsExplosionRadius: 2,
	bulletsArray: [],
	zoomLevel: ZOOM_SNIPER,
	accuracy: 3,
	hasAimImageLayer: true,
	sound: "BarrettShoot.ogg",
	reloadSound: "BARReload.ogg",
	texture: "barrettexplosive",
	ammo: 10,
	smoke: 2,
	recipe: CRAFTING_SNIPER_RIFLE
};

const BARRETT = {
	gunType: GUN_TYPE_SNIPER_RIFLE,
	type: BUTTON_TYPE_ON_CLICK,
	name: "Barrett",
	id: 465,
	fireRate: 12,
	recoil: 25,
	bulletSpeed: SNIPER_BULLET_SPEED,
	zoomLevel: ZOOM_SNIPER,
	accuracy: 2,
	hasAimImageLayer: true,
	sound: "BarrettShoot.ogg",
	reloadSound: "BARReload.ogg",
	texture: "barrett",
	ammo: 10,
	smoke: 2,
	recipe: CRAFTING_SNIPER_RIFLE
};

const BIZON = {
	gunType: GUN_TYPE_SUB_MACHINE,
	type: BUTTON_TYPE_ON_TOUCH,
	name: "Bizon",
	id: 466,
	fireRate: 2,
	recoil: 3,
	bulletSpeed: ASSAULT_BULLET_SPEED,
	accuracy: 3,
	zoomLevel: ZOOM_MACHINE,
	sound: "P90_and_Bizon_and_G3Shoot_and_Minigun.ogg",
	reloadSound: "MP40Reload.ogg",
	texture: "bizon",
	ammo: 53,
	smoke: 1,
	recipe: CRAFTING_SUB_MACHINE
};

const CROSSBOW_EXPLOSIVE = {
	gunType: GUN_TYPE_LAUNCHER,
	type: BUTTON_TYPE_ON_CLICK,
	name: "Crossbow Explosive",
	id: 3367,
	fireRate: 14,
	recoil: 11,
	bulletSpeed: ASSAULT_BULLET_SPEED,
	hasExplosiveBulletsOnTime: true,
	bulletsExplosionDelay: 3350,
	bulletsExplosionRadius: 4,
	bulletsArray: [],
	zoomLevel: ZOOM_ASSAULT,
	accuracy: 5,
	hasAimImageLayer: true,
	sound: "CrossbowShoot.wav",
	reloadSound: "CrossbowReload.wav",
	texture: "crossbowexplosive",
	ammo: 1,
	ammunitionID: AMMO_ARROW_EXPLOSIVE_ID,
	smoke: 0,
	recipe: CRAFTING_CROSSBOW_EXPLOSIVE
};

const CROSSBOW = {
	gunType: GUN_TYPE_LAUNCHER,
	type: BUTTON_TYPE_ON_CLICK,
	name: "Crossbow",
	id: 3368,
	fireRate: 14,
	recoil: 11,
	bulletSpeed: ASSAULT_BULLET_SPEED,
	zoomLevel: ZOOM_ASSAULT,
	accuracy: 5,
	hasAimImageLayer: true,
	sound: "CrossbowShoot.wav",
	reloadSound: "CrossbowReload.wav",
	texture: "crossbow",
	ammo: 1,
	ammunitionID: 262, // 262 = arrow
	smoke: 0,
	recipe: CRAFTING_CROSSBOW
};

const DESERT_EAGLE = {
	gunType: GUN_TYPE_HANDGUN,
	type: BUTTON_TYPE_ON_CLICK,
	name: "Desert Eagle",
	id: 467,
	fireRate: 1,
	recoil: 4,
	bulletSpeed: PISTOL_BULLET_SPEED,
	accuracy: 6,
	zoomLevel: ZOOM_PISTOL,
	sound: "DesertEagleShoot.ogg",
	reloadSound: "LugerReload.ogg",
	texture: "deserteagle",
	ammo: 7,
	smoke: 0,
	recipe: CRAFTING_HANDGUN
};

const DESERT_EAGLE_GOLD = {
	gunType: GUN_TYPE_HANDGUN,
	type: BUTTON_TYPE_ON_CLICK,
	name: "Desert Eagle Gold",
	id: 468,
	fireRate: 1,
	recoil: 4,
	bulletSpeed: PISTOL_BULLET_SPEED,
	accuracy: 5,
	zoomLevel: ZOOM_PISTOL,
	sound: "DesertEagleShoot.ogg",
	reloadSound: "LugerReload.ogg",
	texture: "deserteaglegold",
	ammo: 7,
	smoke: 0,
	recipe: CRAFTING_HANDGUN
};

const DRAGUNOV = {
	gunType: GUN_TYPE_SNIPER_RIFLE,
	type: BUTTON_TYPE_ON_CLICK,
	name: "Dragunov",
	id: 469,
	fireRate: 8,
	recoil: 23,
	bulletSpeed: SNIPER_BULLET_SPEED,
	zoomLevel: ZOOM_SNIPER,
	accuracy: 2,
	hasAimImageLayer: true,
	sound: "DragunovShoot.ogg",
	reloadSound: "BARReload.ogg",
	texture: "dragunov",
	ammo: 10,
	smoke: 2,
	recipe: CRAFTING_SNIPER_RIFLE
};

const FLAMETHROWER = {
	gunType: GUN_TYPE_MINIGUN,
	type: BUTTON_TYPE_ON_TOUCH_WITH_WAIT,
	name: "Flamethrower",
	id: 508,
	fireRate: 1,
	recoil: 0.5,
	isFlamethrower: true,
	bulletSpeed: ASSAULT_BULLET_SPEED,
	accuracy: 5.5,
	zoomLevel: ZOOM_GRENADE_LAUNCHER,
	hasRandomWarmupSound: true,
	warmupSound: {
		startingFrom: 1,
		endingAt: 3,
		startText: "ignite_flamethrower",
		endText: ".ogg"
	},
	hasntShootingSound: true,
	spinSound: "flamethrower.mp3",
	hasntCooldownSound: true,
	reloadSound: "BrowningReload.ogg",
	texture: "flamethrower",
	ammo: 750,
	smoke: 3,
	recipe: CRAFTING_MINIGUN
};

const FNSCAR = {
	gunType: GUN_TYPE_ASSAULT_RIFLE,
	type: BUTTON_TYPE_ON_TOUCH,
	name: "FNSCAR",
	id: 470,
	fireRate: 3,
	recoil: 1.5,
	bulletSpeed: ASSAULT_BULLET_SPEED,
	accuracy: 3,
	zoomLevel: ZOOM_ASSAULT,
	sound: "FNSCAR_and_AUG_and_MTARShoot.ogg",
	reloadSound: "MP44Reload.ogg",
	texture: "fnscar",
	ammo: 20,
	smoke: 1,
	recipe: CRAFTING_ASSAULT_RIFLE
};

const G3 = {
	gunType: GUN_TYPE_ASSAULT_RIFLE,
	type: BUTTON_TYPE_ON_TOUCH,
	name: "G3",
	id: 471,
	fireRate: 2,
	recoil: 2,
	bulletSpeed: ASSAULT_BULLET_SPEED,
	accuracy: 2.5,
	zoomLevel: ZOOM_ASSAULT,
	sound: "P90_and_Bizon_and_G3Shoot_and_Minigun.ogg",
	reloadSound: "ThompsonReload.ogg",
	texture: "g3",
	ammo: 20,
	smoke: 1,
	recipe: CRAFTING_ASSAULT_RIFLE
};

const G36 = {
	gunType: GUN_TYPE_ASSAULT_RIFLE,
	type: BUTTON_TYPE_ON_TOUCH,
	name: "G36",
	id: 472,
	fireRate: 3,
	recoil: 2,
	bulletSpeed: ASSAULT_BULLET_SPEED,
	accuracy: 2.5,
	zoomLevel: ZOOM_ASSAULT,
	sound: "G36Shoot.ogg",
	reloadSound: "MP40Reload.ogg",
	texture: "g36",
	ammo: 30,
	smoke: 1,
	recipe: CRAFTING_ASSAULT_RIFLE
};

const GL1 = {
	gunType: GUN_TYPE_LAUNCHER,
	type: BUTTON_TYPE_ON_CLICK,
	name: "GL1",
	id: 473,
	fireRate: 10,
	recoil: 12,
	bulletSpeed: GRENADE_LAUNCHER_BULLET_SPEED,
	isGrenadeLauncher: true,
	grenadeExplosionRadius: 4,
	grenadesArray: [],
	accuracy: 10,
	zoomLevel: ZOOM_GRENADE_LAUNCHER,
	sound: "GrenadeLauncherShoot.ogg",
	reloadSound: "GrenadeLauncherReload.ogg",
	texture: "gl1",
	ammo: 1,
	smoke: 0,
	recipe: CRAFTING_LAUNCHER
};

const GL6 = {
	gunType: GUN_TYPE_LAUNCHER,
	type: BUTTON_TYPE_ON_CLICK,
	name: "GL6",
	id: 474,
	fireRate: 1,
	recoil: 8,
	bulletSpeed: GRENADE_LAUNCHER_BULLET_SPEED,
	isGrenadeLauncher: true,
	grenadeExplosionRadius: 4,
	grenadesArray: [],
	accuracy: 15,
	zoomLevel: ZOOM_GRENADE_LAUNCHER,
	sound: "GrenadeLauncherShoot.ogg",
	reloadSound: "GL6Reload.ogg",
	texture: "gl6",
	ammo: 6,
	smoke: 0,
	recipe: CRAFTING_LAUNCHER
};

const GLOCK = {
	gunType: GUN_TYPE_MACHINE_PISTOL,
	type: BUTTON_TYPE_ON_TOUCH,
	name: "Glock",
	id: 475,
	fireRate: 3,
	recoil: 2,
	bulletSpeed: PISTOL_BULLET_SPEED,
	accuracy: 2.5,
	zoomLevel: ZOOM_PISTOL,
	sound: "GlockShoot.ogg",
	reloadSound: "ColtReload.ogg",
	texture: "glock",
	ammo: 31,
	smoke: 1,
	recipe: CRAFTING_MACHINE_PISTOL
};

const L86 = {
	gunType: GUN_TYPE_LIGHT_MACHINE,
	type: BUTTON_TYPE_ON_TOUCH,
	name: "L86",
	id: 476,
	fireRate: 3,
	recoil: 5,
	bulletSpeed: ASSAULT_BULLET_SPEED,
	accuracy: 4,
	zoomLevel: ZOOM_MACHINE,
	sound: "M249_and_L86Shoot.ogg",
	reloadSound: "BrowningReload.ogg",
	texture: "l86",
	ammo: 100,
	smoke: 2,
	recipe: CRAFTING_LIGHT_MACHINE
};

const L96 = {
	gunType: GUN_TYPE_SNIPER_RIFLE,
	type: BUTTON_TYPE_ON_CLICK,
	name: "L96",
	id: 477,
	fireRate: 26,
	recoil: 14,
	bulletSpeed: SNIPER_BULLET_SPEED,
	zoomLevel: ZOOM_SNIPER,
	accuracy: 2,
	hasAimImageLayer: true,
	sound: "L96Shoot.ogg",
	reloadSound: "BARReload.ogg",
	texture: "l96",
	ammo: 10,
	smoke: 1,
	recipe: CRAFTING_SNIPER_RIFLE
};

const M9 = {
	gunType: GUN_TYPE_HANDGUN,
	type: BUTTON_TYPE_ON_CLICK,
	name: "M9",
	id: 478,
	fireRate: 1,
	recoil: 1,
	bulletSpeed: PISTOL_BULLET_SPEED,
	accuracy: 8,
	zoomLevel: ZOOM_PISTOL,
	sound: "M9Shoot.ogg",
	reloadSound: "ColtReload.ogg",
	texture: "m9",
	ammo: 15,
	smoke: 0,
	recipe: CRAFTING_HANDGUN
};

const M14 = {
	gunType: GUN_TYPE_ASSAULT_RIFLE,
	type: BUTTON_TYPE_ON_CLICK,
	name: "M14",
	id: 479,
	fireRate: 1,
	recoil: 4,
	bulletSpeed: ASSAULT_BULLET_SPEED,
	zoomLevel: ZOOM_ASSAULT,
	accuracy: 2,
	sound: "M14_and_M16A4Shoot.ogg",
	reloadSound: "BARReload.ogg",
	texture: "m14",
	ammo: 20,
	smoke: 0,
	recipe: CRAFTING_ASSAULT_RIFLE
};

const M16A4 = {
	gunType: GUN_TYPE_ASSAULT_RIFLE,
	type: BUTTON_TYPE_ON_TOUCH,
	name: "M16A4",
	id: 480,
	fireRate: 3,
	recoil: 2,
	bulletSpeed: ASSAULT_BULLET_SPEED,
	accuracy: 2.5,
	zoomLevel: ZOOM_ASSAULT,
	sound: "M14_and_M16A4Shoot.ogg",
	reloadSound: "MP44Reload.ogg",
	texture: "m16a4",
	ammo: 30,
	smoke: 1,
	recipe: CRAFTING_ASSAULT_RIFLE
};

const M21 = {
	gunType: GUN_TYPE_SNIPER_RIFLE,
	type: BUTTON_TYPE_ON_CLICK,
	name: "M21",
	id: 481,
	fireRate: 10,
	recoil: 18,
	bulletSpeed: SNIPER_BULLET_SPEED,
	zoomLevel: ZOOM_SNIPER,
	accuracy: 2,
	hasAimImageLayer: true,
	sound: "M21Shoot.ogg",
	reloadSound: "BARReload.ogg",
	texture: "m21",
	ammo: 10,
	smoke: 1,
	recipe: CRAFTING_SNIPER_RIFLE
};

const M40A3_ICE = {
	gunType: GUN_TYPE_SNIPER_RIFLE,
	type: BUTTON_TYPE_ON_CLICK,
	name: "M40A3 Ice",
	id: 482,
	fireRate: 10,
	recoil: 23,
	bulletSpeed: SNIPER_BULLET_SPEED,
	zoomLevel: ZOOM_SNIPER,
	accuracy: 2,
	hasAimImageLayer: true,
	sound: "R700_and_M40A3Shoot.ogg",
	reloadSound: "SpringfieldReload.ogg",
	texture: "m40a3ice",
	ammo: 5,
	smoke: 1,
	recipe: CRAFTING_SNIPER_RIFLE
};

const M40A3 = {
	gunType: GUN_TYPE_SNIPER_RIFLE,
	type: BUTTON_TYPE_ON_CLICK,
	name: "M40A3",
	id: 483,
	fireRate: 10,
	recoil: 23,
	bulletSpeed: SNIPER_BULLET_SPEED,
	zoomLevel: ZOOM_SNIPER,
	accuracy: 2,
	hasAimImageLayer: true,
	sound: "R700_and_M40A3Shoot.ogg",
	reloadSound: "SpringfieldReload.ogg",
	texture: "m40a3",
	ammo: 5,
	smoke: 1,
	recipe: CRAFTING_SNIPER_RIFLE
};

const M60E4 = {
	gunType: GUN_TYPE_LIGHT_MACHINE,
	type: BUTTON_TYPE_ON_TOUCH,
	name: "M60E4",
	id: 484,
	fireRate: 3,
	recoil: 6,
	bulletSpeed: ASSAULT_BULLET_SPEED,
	accuracy: 3.5,
	zoomLevel: ZOOM_MACHINE,
	sound: "RPD_and_M60E4_and_RPKShoot.ogg",
	reloadSound: "BrowningReload.ogg",
	texture: "m60e4",
	ammo: 100,
	smoke: 2,
	recipe: CRAFTING_LIGHT_MACHINE
};

const M72LAW = {
	gunType: GUN_TYPE_LAUNCHER,
	type: BUTTON_TYPE_ON_CLICK,
	name: "M72LAW",
	id: 485,
	fireRate: 10,
	recoil: 13,
	bulletSpeed: BAZOOKA_BULLET_SPEED,
	hasExplosiveBulletsOnTouch: true,
	bulletsExplosionRadius: 4,
	bulletsArray: [],
	accuracy: 3.5,
	zoomLevel: ZOOM_BAZOOKA,
	sound: "AT4_and_M72LAW_and_Panzerfaust3Shoot.ogg",
	reloadSound: "BazookaReload.ogg",
	texture: "m72law",
	ammo: 1,
	smoke: 4,
	recipe: CRAFTING_LAUNCHER
};

const M249 = {
	gunType: GUN_TYPE_LIGHT_MACHINE,
	type: BUTTON_TYPE_ON_TOUCH,
	name: "M249",
	id: 486,
	fireRate: 3,
	recoil: 6,
	bulletSpeed: ASSAULT_BULLET_SPEED,
	accuracy: 3.5,
	zoomLevel: ZOOM_MACHINE,
	sound: "M249_and_L86Shoot.ogg",
	reloadSound: "BrowningReload.ogg",
	texture: "m249",
	ammo: 100,
	smoke: 2,
	recipe: CRAFTING_LIGHT_MACHINE
};

const M1014 = {
	gunType: GUN_TYPE_SHOTGUN,
	type: BUTTON_TYPE_ON_CLICK,
	name: "M1014",
	id: 487,
	fireRate: 18,
	recoil: 10,
	bulletSpeed: SHOTGUN_BULLET_SPEED,
	isShotgun: true,
	shotgunWidth: 2,
	shotgunBulletsPerLineShot: 3,
	accuracy: 10,
	zoomLevel: ZOOM_SHOTGUN,
	sound: "M1014Shoot.ogg",
	reloadSound: "M1014Reload.ogg",
	texture: "m1014",
	ammo: 4,
	smoke: 0,
	recipe: CRAFTING_SHOTGUN
};

const M1887 = {
	gunType: GUN_TYPE_SHOTGUN,
	type: BUTTON_TYPE_ON_CLICK,
	name: "Model 1887",
	id: 488,
	fireRate: 20,
	recoil: 18,
	bulletSpeed: SHOTGUN_BULLET_SPEED,
	isShotgun: true,
	shotgunWidth: 3,
	shotgunBulletsPerLineShot: 3,
	accuracy: 10,
	zoomLevel: ZOOM_SHOTGUN,
	sound: "M1887Shoot.ogg",
	reloadSound: "M1887Reload.ogg",
	texture: "m1887",
	ammo: 5,
	smoke: 1,
	recipe: CRAFTING_SHOTGUN
};

const MAKAROV = {
	gunType: GUN_TYPE_HANDGUN,
	type: BUTTON_TYPE_ON_CLICK,
	name: "Makarov",
	id: 489,
	fireRate: 1,
	recoil: 2.5,
	bulletSpeed: PISTOL_BULLET_SPEED,
	accuracy: 8,
	zoomLevel: ZOOM_PISTOL,
	sound: "MakarovShoot.ogg",
	reloadSound: "ColtReload.ogg",
	texture: "makarov",
	ammo: 8,
	smoke: 0,
	recipe: CRAFTING_HANDGUN
};

const MINIGUN_EXPLOSIVE = {
	gunType: GUN_TYPE_MINIGUN,
	type: BUTTON_TYPE_ON_TOUCH_WITH_WAIT,
	name: "Minigun Explosive",
	id: 511,
	fireRate: 3,
	recoil: 2,
	bulletSpeed: ASSAULT_BULLET_SPEED,
	hasExplosiveBulletsOnTouch: true,
	bulletsExplosionRadius: 2,
	bulletsArray: [],
	accuracy: 5.5,
	zoomLevel: ZOOM_ASSAULT,
	warmupSound: "MinigunWarmup.ogg",
	sound: "P90_and_Bizon_and_G3Shoot_and_Minigun.ogg",
	spinSound: "MinigunSpin.ogg",
	cooldownSound: "MinigunCooldown.ogg",
	reloadSound: "BrowningReload.ogg",
	texture: "minigunexplosive",
	ammo: 250,
	smoke: 3,
	recipe: CRAFTING_MINIGUN
};

const MINIGUN = {
	gunType: GUN_TYPE_MINIGUN,
	type: BUTTON_TYPE_ON_TOUCH_WITH_WAIT,
	name: "Minigun",
	id: 490,
	fireRate: 1,
	recoil: 1,
	bulletSpeed: ASSAULT_BULLET_SPEED,
	accuracy: 5.5,
	zoomLevel: ZOOM_ASSAULT,
	warmupSound: "MinigunWarmup.ogg",
	sound: "P90_and_Bizon_and_G3Shoot_and_Minigun.ogg",
	spinSound: "MinigunSpin.ogg",
	cooldownSound: "MinigunCooldown.ogg",
	reloadSound: "BrowningReload.ogg",
	texture: "minigun",
	ammo: 500,
	smoke: 3,
	recipe: CRAFTING_MINIGUN
};

const MINI_UZI = {
	gunType: GUN_TYPE_MACHINE_PISTOL,
	type: BUTTON_TYPE_ON_TOUCH,
	name: "Mini-Uzi",
	id: 491,
	fireRate: 2,
	recoil: 3,
	bulletSpeed: PISTOL_BULLET_SPEED,
	accuracy: 2.5,
	zoomLevel: ZOOM_PISTOL,
	sound: "MiniUziShoot.ogg",
	reloadSound: "ColtReload.ogg",
	texture: "miniuzi",
	ammo: 32,
	smoke: 1,
	recipe: CRAFTING_MACHINE_PISTOL
};

const MP5 = {
	gunType: GUN_TYPE_SUB_MACHINE,
	type: BUTTON_TYPE_ON_TOUCH,
	name: "MP5",
	id: 492,
	fireRate: 3,
	recoil: 3,
	bulletSpeed: ASSAULT_BULLET_SPEED,
	accuracy: 2.5,
	zoomLevel: ZOOM_MACHINE,
	sound: "MP5Shoot.ogg",
	reloadSound: "StenReload.ogg",
	texture: "mp5",
	ammo: 30,
	smoke: 1,
	recipe: CRAFTING_SUB_MACHINE
};

const MTAR = {
	gunType: GUN_TYPE_ASSAULT_RIFLE,
	type: BUTTON_TYPE_ON_TOUCH,
	name: "MTAR",
	id: 493,
	fireRate: 3,
	recoil: 3,
	bulletSpeed: ASSAULT_BULLET_SPEED,
	accuracy: 3,
	zoomLevel: ZOOM_ASSAULT,
	sound: "FNSCAR_and_AUG_and_MTARShoot.ogg",
	reloadSound: "MP44Reload.ogg",
	texture: "mtar",
	ammo: 30,
	smoke: 1,
	recipe: CRAFTING_ASSAULT_RIFLE
};

const P90 = {
	gunType: GUN_TYPE_SUB_MACHINE,
	type: BUTTON_TYPE_ON_TOUCH,
	name: "P90",
	id: 494,
	fireRate: 2,
	recoil: 2,
	bulletSpeed: ASSAULT_BULLET_SPEED,
	accuracy: 2.5,
	zoomLevel: ZOOM_MACHINE,
	sound: "P90_and_Bizon_and_G3Shoot_and_Minigun.ogg",
	reloadSound: "DP28Reload.ogg",
	texture: "p90",
	ammo: 50,
	smoke: 2,
	recipe: CRAFTING_SUB_MACHINE
};

const R700 = {
	gunType: GUN_TYPE_SNIPER_RIFLE,
	type: BUTTON_TYPE_ON_CLICK,
	name: "R700",
	id: 495,
	fireRate: 20,
	recoil: 25,
	bulletSpeed: SNIPER_BULLET_SPEED,
	zoomLevel: ZOOM_SNIPER,
	accuracy: 2,
	hasAimImageLayer: true,
	sound: "R700_and_M40A3Shoot.ogg",
	reloadSound: "SpringfieldReload.ogg",
	texture: "r700",
	ammo: 4,
	smoke: 1,
	recipe: CRAFTING_SNIPER_RIFLE
};

const R870 = {
	gunType: GUN_TYPE_SHOTGUN,
	type: BUTTON_TYPE_ON_CLICK,
	name: "Remington 870",
	id: 496,
	fireRate: 15,
	recoil: 19,
	bulletSpeed: SHOTGUN_BULLET_SPEED,
	isShotgun: true,
	shotgunWidth: 3,
	shotgunBulletsPerLineShot: 3,
	accuracy: 11,
	zoomLevel: ZOOM_SHOTGUN,
	sound: "R870Shoot.ogg",
	reloadSound: "W1200Reload.ogg",
	texture: "r870",
	ammo: 7,
	smoke: 1,
	recipe: CRAFTING_SHOTGUN
};

const RPD = {
	gunType: GUN_TYPE_LIGHT_MACHINE,
	type: BUTTON_TYPE_ON_TOUCH,
	name: "RPD",
	id: 497,
	fireRate: 3,
	recoil: 5.5,
	bulletSpeed: ASSAULT_BULLET_SPEED,
	accuracy: 4,
	zoomLevel: ZOOM_MACHINE,
	sound: "RPD_and_M60E4_and_RPKShoot.ogg",
	reloadSound: "MG42Reload.ogg",
	texture: "rpd",
	ammo: 100,
	smoke: 2,
	recipe: CRAFTING_LIGHT_MACHINE
};

const RPG = {
	gunType: GUN_TYPE_LAUNCHER,
	type: BUTTON_TYPE_ON_CLICK,
	name: "RPG",
	id: 498,
	fireRate: 10,
	recoil: 25,
	bulletSpeed: BAZOOKA_BULLET_SPEED,
	hasExplosiveBulletsOnTouch: true,
	bulletsExplosionRadius: 4,
	bulletsArray: [],
	accuracy: 15,
	zoomLevel: ZOOM_BAZOOKA,
	sound: "RPGShoot.ogg",
	reloadSound: "BazookaReload.ogg",
	texture: "rpg",
	ammo: 1,
	smoke: 4,
	recipe: CRAFTING_LAUNCHER
};

const RPK = {
	gunType: GUN_TYPE_ASSAULT_RIFLE,
	type: BUTTON_TYPE_ON_TOUCH,
	name: "RPK",
	id: 499,
	fireRate: 3,
	recoil: 3.5,
	bulletSpeed: ASSAULT_BULLET_SPEED,
	accuracy: 4,
	zoomLevel: ZOOM_ASSAULT,
	sound: "RPD_and_M60E4_and_RPKShoot.ogg",
	reloadSound: "MG42Reload.ogg",
	texture: "rpk",
	ammo: 40,
	smoke: 1,
	recipe: CRAFTING_ASSAULT_RIFLE
};

const SG550 = {
	gunType: GUN_TYPE_ASSAULT_RIFLE,
	type: BUTTON_TYPE_ON_CLICK,
	name: "SG550",
	id: 500,
	fireRate: 5,
	recoil: 2.5,
	bulletSpeed: ASSAULT_BULLET_SPEED,
	accuracy: 2.5,
	zoomLevel: ZOOM_ASSAULT,
	sound: "SG550Shoot.ogg",
	reloadSound: "MP44Reload.ogg",
	texture: "sg550",
	ammo: 20,
	smoke: 1,
	recipe: CRAFTING_ASSAULT_RIFLE
};

const SIGP226 = {
	gunType: GUN_TYPE_HANDGUN,
	type: BUTTON_TYPE_ON_CLICK,
	name: "SIGP226",
	id: 501,
	fireRate: 1,
	recoil: 3,
	bulletSpeed: PISTOL_BULLET_SPEED,
	accuracy: 6,
	zoomLevel: ZOOM_PISTOL,
	sound: "SIGP226Shoot.ogg",
	reloadSound: "LugerReload.ogg",
	texture: "sigp226",
	ammo: 10,
	smoke: 0,
	recipe: CRAFTING_HANDGUN
};

const SKORPION = {
	gunType: GUN_TYPE_MACHINE_PISTOL,
	type: BUTTON_TYPE_ON_TOUCH,
	name: "Skorpion",
	id: 502,
	fireRate: 3,
	recoil: 1.5,
	bulletSpeed: PISTOL_BULLET_SPEED,
	accuracy: 2.5,
	zoomLevel: ZOOM_PISTOL,
	sound: "SkorpionShoot.ogg",
	reloadSound: "StenReload.ogg",
	texture: "skorpion",
	ammo: 20,
	smoke: 1,
	recipe: CRAFTING_MACHINE_PISTOL
};

const SPAS = {
	gunType: GUN_TYPE_SHOTGUN,
	type: BUTTON_TYPE_ON_CLICK,
	name: "SPAS-12",
	id: 503,
	fireRate: 15,
	recoil: 22,
	bulletSpeed: SHOTGUN_BULLET_SPEED,
	isShotgun: true,
	shotgunWidth: 3,
	shotgunBulletsPerLineShot: 3,
	accuracy: 25,
	zoomLevel: ZOOM_SHOTGUN,
	sound: "W1200_and_SPASShoot.ogg",
	reloadSound: "W1200Reload.ogg",
	texture: "spas",
	ammo: 7,
	smoke: 1,
	recipe: CRAFTING_SHOTGUN
};

const USP = {
	gunType: GUN_TYPE_HANDGUN,
	type: BUTTON_TYPE_ON_CLICK,
	name: "USP",
	id: 504,
	fireRate: 1,
	recoil: 1,
	bulletSpeed: PISTOL_BULLET_SPEED,
	accuracy: 8,
	zoomLevel: ZOOM_PISTOL,
	sound: "USPShoot.ogg",
	reloadSound: "TT33Reload.ogg",
	texture: "usp",
	ammo: 10,
	smoke: 0,
	recipe: CRAFTING_HANDGUN
};

const W1200 = {
	gunType: GUN_TYPE_SHOTGUN,
	type: BUTTON_TYPE_ON_CLICK,
	name: "W1200",
	id: 505,
	fireRate: 15,
	recoil: 17,
	bulletSpeed: SHOTGUN_BULLET_SPEED,
	isShotgun: true,
	shotgunWidth: 3,
	shotgunBulletsPerLineShot: 3,
	accuracy: 11,
	zoomLevel: ZOOM_SHOTGUN,
	sound: "W1200_and_SPASShoot.ogg",
	reloadSound: "W1200Reload.ogg",
	texture: "w1200",
	ammo: 7,
	smoke: 1,
	recipe: CRAFTING_SHOTGUN
};

const XMAS_MINIGUN = {
	gunType: GUN_TYPE_MINIGUN,
	type: BUTTON_TYPE_ON_TOUCH_WITH_WAIT,
	name: "X-Mas Minigun",
	id: 506,
	fireRate: 2,
	recoil: 1,
	hasIceBullets: true,
	bulletSpeed: ASSAULT_BULLET_SPEED,
	accuracy: 4,
	zoomLevel: ZOOM_ASSAULT,
	warmupSound: "MinigunWarmup.ogg",
	sound: "bell.mp3",
	spinSound: "MinigunSpin.ogg",
	cooldownSound: "MinigunCooldown.ogg",
	reloadSound: "BrowningReload.ogg",
	texture: "xmasminigun",
	ammo: 500,
	smoke: 3,
	recipe: CRAFTING_MINIGUN
};

const XMAS_SNIPER = {
	gunType: GUN_TYPE_SNIPER_RIFLE,
	type: BUTTON_TYPE_ON_CLICK,
	name: "X-Mas Sniper",
	id: 507,
	fireRate: 5,
	recoil: 5,
	hasIceBullets: true,
	bulletSpeed: SNIPER_BULLET_SPEED,
	zoomLevel: ZOOM_SNIPER,
	accuracy: 2,
	hasAimImageLayer: true,
	sound: "bell.mp3",
	reloadSound: "SpringfieldReload.ogg",
	texture: "xmassniper",
	ammo: 5,
	smoke: 1,
	recipe: CRAFTING_SNIPER_RIFLE
};

const AA12 = {
	gunType: GUN_TYPE_SHOTGUN,
	type: BUTTON_TYPE_ON_TOUCH,
	name: "AA-12",
	id: 509,
	fireRate: 5,
	recoil: 10,
	bulletSpeed: SHOTGUN_BULLET_SPEED + 1,
	isShotgun: true,
	shotgunWidth: 2,
	shotgunBulletsPerLineShot: 3,
	accuracy: 10,
	zoomLevel: ZOOM_SHOTGUN,
	sound: "AA-12Shoot.ogg",
	reloadSound: "PPSHReload.ogg",
	texture: "aa12",
	ammo: 8,
	smoke: 1,
	recipe: CRAFTING_SHOTGUN
};

const INCENDIARY_GL = {
	gunType: GUN_TYPE_LAUNCHER,
	type: BUTTON_TYPE_ON_CLICK,
	name: "Incendiary Grenade Launcher",
	id: 510,
	fireRate: 5,
	recoil: 10,
	bulletSpeed: GRENADE_LAUNCHER_BULLET_SPEED - 0.6,
	isGrenadeLauncher: true,
	grenadesExplosionDiameter: 4,
	grenadesArray: [],
	hasIncendiaryBullets: true,
	accuracy: 15,
	zoomLevel: ZOOM_GRENADE_LAUNCHER,
	sound: "GrenadeLauncherShoot.ogg",
	reloadSound: "GL6Reload.ogg",
	texture: "glincendiary",
	ammo: 6,
	smoke: 0,
	recipe: CRAFTING_LAUNCHER
};

const MSR = {
	gunType: GUN_TYPE_SNIPER_RIFLE,
	type: BUTTON_TYPE_ON_CLICK,
	name: "MSR",
	id: 3369,
	fireRate: 12,
	recoil: 22,
	bulletSpeed: SNIPER_BULLET_SPEED,
	zoomLevel: ZOOM_SNIPER,
	accuracy: 2,
	hasAimImageLayer: true,
	hasManualZoom: true,
	sound: "MSRShoot.mp3",
	reloadSound: "BARReload.ogg",
	texture: "msr",
	ammo: 5,
	smoke: 1,
	recipe: CRAFTING_SNIPER_RIFLE
};

// all the guns in a single array.
// sequence: first pro items, then other items in alphabetic order, and last the items that are added with the Date system
var guns = [AA12, INCENDIARY_GL, MSR, MAGNUM44, AK47, AK74, AT4, AUG, BARRETT_EXPLOSIVE, BARRETT, BIZON, CROSSBOW_EXPLOSIVE, CROSSBOW, DESERT_EAGLE, DESERT_EAGLE_GOLD, DRAGUNOV, FLAMETHROWER, FNSCAR, G3, G36, GL1, GL6, GLOCK, L86, L96, M9, M14, M16A4, M21, M40A3_ICE, M40A3, M60E4, M72LAW, M249, M1014, M1887, MAKAROV, MINIGUN_EXPLOSIVE, MINIGUN, MINI_UZI, MP5, MTAR, P90, R700, R870, RPD, RPG, RPK, SG550, SIGP226, SKORPION, SPAS, USP, W1200];
setUpGunsWithDate();
var explosiveWeapons = [AT4, BARRETT_EXPLOSIVE, CROSSBOW_EXPLOSIVE, M72LAW, MINIGUN_EXPLOSIVE, RPG];

// other items
const KNIFE_ID = 3320;
const KNIFE_MAX_DAMAGE = 32;
const KNIFE_SOUND_STAB = {
	startingFrom: 1,
	endingAt: 2,
	startText: "knife_stab",
	endText: ".mp3"
};
const KNIFE_MOB_DAMAGE = 20;
Item.defineItem(KNIFE_ID, "knife", 0, "Knife");
Item.setMaxDamage(KNIFE_ID, KNIFE_MAX_DAMAGE);
Item.addShapedRecipe(KNIFE_ID, 1, 0, [
	" i ",
	" i ",
	" i "], ["i", 265, 0]);
Item.setCategory(KNIFE_ID, ITEM_CATEGORY_TOOL);
Item.setVerticalRender(KNIFE_ID);

var isParachuting = false;
const PARACHUTE_ID = 3321;
const PARACHUTE_MAX_DAMAGE = 10;
Item.defineItem(PARACHUTE_ID, "parachute", 0, "Parachute");
Item.setMaxDamage(PARACHUTE_ID, PARACHUTE_MAX_DAMAGE);
Item.addShapedRecipe(PARACHUTE_ID, 1, 0, [
	"www",
	"s s",
	" s "], ["s", 287, 0, "w", 35, 0]); // w = wool; s = string;
Item.setCategory(PARACHUTE_ID, ITEM_CATEGORY_TOOL);

const MEDICAL_KIT_ID = 3322;
const MEDICAL_KIT_MAX_RESTORABLE_HEALTH = 50;
Item.defineItem(MEDICAL_KIT_ID, "medicalkit", 0, "Medical Kit");
Item.setMaxDamage(MEDICAL_KIT_ID, MEDICAL_KIT_MAX_RESTORABLE_HEALTH);
Item.addShapedRecipe(MEDICAL_KIT_ID, 1, 0, [
	" m ",
	"ama",
	" m "], ["a", 260, 0, "m", 40, 0]); // a = apple; m = mushroom;

const RIOT_SHIELD_ID = 3323;
const RIOT_SHIELD_MAX_DAMAGE = 3072;
const RIOT_SHIELD_MOB_DAMAGE = 1;
Item.defineItem(RIOT_SHIELD_ID, "riotshield", 0, "Riot Shield");
Item.setMaxDamage(RIOT_SHIELD_ID, RIOT_SHIELD_MAX_DAMAGE);
Item.addShapedRecipe(RIOT_SHIELD_ID, 1, 0, [
	" g ",
	" i ",
	" g "], ["i", 265, 0, "g", 102, 0]); // i = iron; g = glass pane;
Item.setCategory(RIOT_SHIELD_ID, ITEM_CATEGORY_TOOL);
Item.setVerticalRender(RIOT_SHIELD_ID);

// grenades
const GRENADE = {
	id: 3300,
	grenadeSpeed: 2.1,
	grenadesExplosionRadius: 4,
	grenadesArray: [],
	accuracy: 4,
	delay: 4000
};
Item.defineItem(GRENADE.id, "grenade", 0, "Grenade");
Item.addShapedRecipe(GRENADE.id, 1, 0, [
	"i i",
	" g ",
	"i i"], ["i", 265, 0, "r", 331, 0, "g", 289, 0]); // i = iron; r = redstone; g = gunpowder;
Item.setCategory(GRENADE.id, ITEM_CATEGORY_TOOL);

var infiniteGrenade = false;
const FRAGMENT = {
	id: 3301,
	grenadeSpeed: 2.1,
	grenadesExplosionRadius: 2,
	grenadesArray: [],
	fragmentArray: [],
	howManyFragments: 3,
	fragmentDelay: 1000,
	accuracy: 4,
	delay: 4000
};
Item.defineItem(FRAGMENT.id, "grenadefragment", 0, "Fragment Grenade");
Item.addShapedRecipe(FRAGMENT.id, 2, 0, [
	"g g",
	"   ",
	"g g"], ["g", GRENADE.id, 0]);
Item.setCategory(FRAGMENT.id, ITEM_CATEGORY_TOOL);

const MOLOTOV = {
	id: 3302,
	grenadeSpeed: 1.5,
	grenadesExplosionDiameter: 3,
	explodeOnTouch: true,
	isWithFire: true,
	grenadesArray: [],
	accuracy: 4
};
Item.defineItem(MOLOTOV.id, "molotov", 0, "Molotov");
Item.addShapedRecipe(MOLOTOV.id, 1, 0, [
	"ggg",
	"gfg",
	"ggg"], ["f", 289, 0, "g", 102, 0]); // g = glass pane; f = flint and steel;
Item.setCategory(MOLOTOV.id, ITEM_CATEGORY_TOOL);

const SMOKE = {
	id: 3303,
	grenadeSpeed: 2.1,
	grenadesArray: [],
	accuracy: 4,
	delay: 10000,
	smokeParticle: 4
};
Item.defineItem(SMOKE.id, "grenadesmoke", 0, "Smoke Grenade");
Item.addShapedRecipe(SMOKE.id, 1, 0, [
	" i ",
	" z ",
	" s "], ["z", 353, 0, "s", 12, 0, "i", 265, 0]); // z = sugar; s = sand; i = iron;
Item.setCategory(SMOKE.id, ITEM_CATEGORY_TOOL);

// info item
const INFO_ITEM_ID = 3365;
Item.defineItem(INFO_ITEM_ID, "desnogunsinfo", 0, "DesnoGuns Info");
Item.addShapedRecipe(INFO_ITEM_ID, 1, 0, [
	"   ",
	" w ",
	"   "], ["w", 17, 0]);
Item.setCategory(INFO_ITEM_ID, ITEM_CATEGORY_TOOL);

// armors
//Item.defineArmor(int id, String iconName, int iconIndex, String name, String texture, int damageReduceAmount, int maxDamage, int armorType)

const JUGGERNAUT_HELMET_ID = 3285;
Item.newArmor(JUGGERNAUT_HELMET_ID, "juggernauthelmet", 0, "Juggernaut Helmet", "armor/juggernaut_1.png", 2, 249, ArmorType.helmet);
Item.addShapedRecipe(JUGGERNAUT_HELMET_ID, 1, 0, [
	"cic",
	"c c",
	"   "], ["c", 351, 2, "i", 265, 0]);

const JUGGERNAUT_BODY_ID = 3286;
Item.newArmor(JUGGERNAUT_BODY_ID, "juggernautchestplate", 0, "Juggernaut Body", "armor/juggernaut_1.png", 7, 362, ArmorType.chestplate);
Item.addShapedRecipe(JUGGERNAUT_BODY_ID, 1, 0, [
	"i i",
	"cic",
	"cic"], ["c", 351, 2, "i", 265, 0]);

const JUGGERNAUT_PANTS_ID = 3287;
Item.newArmor(JUGGERNAUT_PANTS_ID, "juggernautleggings", 0, "Juggernaut Pants", "armor/juggernaut_1.png", 5, 339, ArmorType.leggings);
Item.addShapedRecipe(JUGGERNAUT_PANTS_ID, 1, 0, [
	"ccc",
	"i i",
	"i i"], ["c", 351, 2, "i", 265, 0]);

const JUGGERNAUT_BOOTS_ID = 3288;
Item.newArmor(JUGGERNAUT_BOOTS_ID, "juggernautboots", 0, "Juggernaut Boots", "armor/juggernaut_2.png", 2, 294, ArmorType.boots);
Item.addShapedRecipe(JUGGERNAUT_BOOTS_ID, 1, 0, [
	"   ",
	"c c",
	"i i"], ["c", 351, 2, "i", 265, 0]);


function selectLevelHook()
{
	// when selecting level
	//
}

function newLevel()
{
	isInGame = true;

	if(Level.getGameMode() == GameMode.CREATIVE)
	{
		// crashes in survival
		Player.addItemCreativeInv(INFO_ITEM_ID, 1);
		Player.addItemCreativeInv(SMOKE.id, 1);
		Player.addItemCreativeInv(MOLOTOV.id, 1);
		Player.addItemCreativeInv(FRAGMENT.id, 1);
		Player.addItemCreativeInv(GRENADE.id, 1);
		Player.addItemCreativeInv(PARACHUTE_ID, 1);
		Player.addItemCreativeInv(KNIFE_ID, 1);
		Player.addItemCreativeInv(RIOT_SHIELD_ID, 1);

		for(var i in guns)
			Player.addItemCreativeInv(guns[i].id, 1);
	}

	refreshIsPro();

	var bSizeTest = ModPE.readData("bSize");
	if(bSizeTest != "" && bSizeTest != null && bSizeTest != undefined)
		buttonsSize = parseFloat(bSizeTest);

	var mButtonsTest = ModPE.readData("mButtons");
	if(mButtonsTest != "" && mButtonsTest != null && mButtonsTest != undefined)
		pixelsOffsetButtons = parseFloat(mButtonsTest);

	var aTSizeTest = ModPE.readData("aTSize");
	if(aTSizeTest != "" && aTSizeTest != null && aTSizeTest != undefined)
		ammoTextSize = parseFloat(aTSizeTest);

	var generalVolumeTest = ModPE.readData("generalVolume");
	if(generalVolumeTest != "" && generalVolumeTest != null && generalVolumeTest != undefined)
		generalVolume = parseFloat(generalVolumeTest);
	if(generalVolume < 0 || generalVolume > 1)
		generalVolume = 1;

	// load saved boolean settings
	// getSavedBoolean(name, defaultValue, debug);
	deathWorkaround = getSavedBoolean("dWorkaround", false, true);
	shouldDisplaySight = getSavedBoolean("dSight", true);
	displayGunNameInAmmo = getSavedBoolean("dNameAmmo", false);
	reloadInCreative = getSavedBoolean("rCreative", false);
	instantReloadInCreative = getSavedBoolean("instReload", false);
	switchedButtonsPosition = getSavedBoolean("sBPosition", false);
	minecraftStyleForButtons = getSavedBoolean("sBStyle", false);

	new java.lang.Thread(new java.lang.Runnable()
	{
		run: function()
		{
			updateLatestVersionMod();
			if(latestVersion != CURRENT_VERSION && latestVersion != undefined)
				updateAvailableUI();
			else
			{
				if(!isPro())
				{
					currentActivity.runOnUiThread(new java.lang.Runnable() {
						run: function() {
							android.widget.Toast.makeText(currentActivity, new android.text.Html.fromHtml("<b>DesnoGuns</b>: You have the latest version."), 0).show();
						}
					});
				} else
				{
					currentActivity.runOnUiThread(new java.lang.Runnable() {
						run: function() {
							android.widget.Toast.makeText(currentActivity, new android.text.Html.fromHtml("<b>DesnoGuns Pro</b>: You have the latest version."), 0).show();
						}
					});
				}
			}
		}
	}).start();
}

function leaveGame()
{
	isInGame = false;
	players = [];

	removeShootAndAimButtons();

	displayedMessageNoSound = false;

	previousCarriedItem = 0;
	previousSlotId = 0;

	// release the resources for sounds
	try {
		soundPool.release();
		soundPool = null;
		soundID = null;
	} catch(e) { /* soundPool was already released */ }
	try {
		sound1.reset();
		sound1 = null;
	} catch(e) { }
	try {
		sound2.reset();
		sound2 = null;
	} catch(e) { }
	try {
		sound3.reset();
		sound3 = null;
	} catch(e) { }

	// fire button variables
	currentShotTicks = 0;

	// for assault rifles
	isShooting = false;
	shootingRunnable = null;

	// for minigun
	isTouchingFireButtonGunsWithWait = false;

	// remove explosive bullets
	for(var i in explosiveWeapons)
	{
		explosiveWeapons[i].bulletsArray = [];
	}

	// remove grenades
	GRENADE.grenadesArray = [];

	// remove fragment grenades
	FRAGMENT.grenadesArray = [];

	// remove molotovs
	MOLOTOV.grenadesArray = [];

	// remove smoke grenades
	SMOKE.grenadesArray = [];

	// parachute
	isParachuting = false;

	// reset fov
	ModPE.resetFov();
	zoomWithFov = 72;

	// info item UIs
	removeInfoItemUI();

	// medical kit UI
	removeHealButton();
}

function procCmd(text)
{
	var command = text.toLowerCase().split(" ");
	switch(command[0])
	{
		case "swag-grenade":
		case "swaggrenade":
		case "swag_grenade":
		{
			if(infiniteGrenade)
			{
				infiniteGrenade = false;
				clientMessage("Disabled swag.");
			}
			else
			{
				infiniteGrenade = true;
				clientMessage("A crash may happen if you use a fragment grenade.");
				clientMessage(ChatColor.RED + "Use at your own risk!");
				clientMessage("For a better experience use it on a flat world.");
			}
			break;
		}
		case "swag":
		{
			if(command[1] == "grenade")
			{
				if(infiniteGrenade)
				{
					infiniteGrenade = false;
					clientMessage("Disabled swag.");
				}
				else
				{
					infiniteGrenade = true;
					clientMessage("A crash may happen if you use a fragment grenade.");
					clientMessage(ChatColor.RED + "Use at your own risk!");
					clientMessage("For a better experience use it on a flat world.");
				}
			}
			break;
		}
	}
}

function useItem(x, y, z, itemId, blockId, side, itemDamage)
{
	if(itemId == INFO_ITEM_ID)
	{
		infoDesnoGunsMod();
		preventDefault();
		return;
	}

	if(itemId == KNIFE_ID)
	{
		Sound.playFromFileName("knife_on_blocks.mp3");
	}

	// easter egg
	if(blockId == 173) // 173 block of coal
	{
		if(Level.getTile(Math.floor(x), Math.floor(y) - 1, Math.floor(z)) == 42) // block of iron
		{
			preventDefault();
			if(Level.getGameMode() == GameMode.SURVIVAL)
			{
				xCoalEE = Math.floor(x);
				yCoalEE = Math.floor(y);
				zCoalEE = Math.floor(z);
				easterEggUI();
			} else
			{
				clientMessage("Only in survival.");
			}
		}
	}
}

function attackHook(attacker, victim)
{
	if(attacker = Player.getEntity())
	{
		// knife
		if(Player.getCarriedItem() == KNIFE_ID && Entity.getHealth(victim) != 0)
		{
			Sound.playFromFileName(createRandomString(KNIFE_SOUND_STAB));

			var health = Entity.getHealth(victim) - KNIFE_MOB_DAMAGE;
			if(health < 1)
				health = 1;
			Entity.setHealth(victim, health);

			if(Level.getGameMode() == GameMode.SURVIVAL)
				Player.damageCarriedItem();
		}

		// riot shield
		if(Player.getCarriedItem() == RIOT_SHIELD_ID && Entity.getHealth(victim) != 0)
		{
			Sound.playFromFileName("riot_shield_attack.mp3");

			var health = Entity.getHealth(victim) - RIOT_SHIELD_MOB_DAMAGE;
			if(health < 1)
				health = 1;
			Entity.setHealth(victim, health);

			if(Level.getGameMode() == GameMode.SURVIVAL)
			{
				for(var i = 0; i < 20; i++)
				{
					Player.damageCarriedItem();
				}
			}
		}
	}
}

function deathHook(murderer, victim)
{
	// easter egg
	if(Entity.getEntityTypeId(victim) == 36) // 36 = pigman id
	{
		if(Player.getCarriedItem() == BARRETT_EXPLOSIVE.id)
		{
			killedPigmenEE++;
			if(killedPigmenEE % 20 == 0)
			{
				codeEE = Math.floor((Math.random() * 8999) + 1000);
				clientMessage(codeEE);
			}
		}

		var index = pigmen.indexOf(victim);
		if(index != -1)
		{
			pigmen.splice(index, 1);
		}
	}

	// remove the mob after the death, this prevent returning arrows
	if(deathWorkaround && victim != Player.getEntity())
	{
		if(isItemAGun(Player.getCarriedItem()))
		{
			Entity.remove(victim);
		}
	}
}

function entityRemovedHook(entity)
{
	// remove explosive bullets
	for(var i in explosiveWeapons)
	{
		if(!explosiveWeapons[i].hasExplosiveBulletsOnTime) // bullets on time shouldn't be removed from the array when the entity gets removed from the game
		{
			for(var j in explosiveWeapons[i].bulletsArray)
			{
				if(entity == explosiveWeapons[i].bulletsArray[j].entity)
					explosiveWeapons[i].bulletsArray.splice(j, 1);
			}
		}
	}
}

function changeCarriedItemHook(currentItem, previousItem)
{
	// prevent infinite shooting
	currentShotTicks = 0;
	isShooting = false;

	// remove aiming if the user was aiming
	removeZoomAndAimImageLayer();

	// stop reloading if necessary
	stopReloading();

	// release the resources for sounds
	try {
		if(soundPool != null)
			soundPool.release();
		soundPool = null;
		soundID = null;
	} catch(e) {
		ModPE.log(getLogText() + "something wrong: " + e);
	}

	// reset sounds for on touch with wait guns spin
	try {
		gunSpinSound.stop();
		gunSpinSound.release();
		gunSpinSound = null;
		gunSpinSound = new android.media.MediaPlayer();
	} catch(e) {
		clientMessage(e);
	}

	// remove shooting UI of grenades and molotov
	if(previousItem == MOLOTOV.id || previousItem == GRENADE.id || previousItem == FRAGMENT.id || previousItem == SMOKE.id)
	{
		//
		removeShootAndAimButtons();
	}

	// remove UI of the info item
	if(previousItem == INFO_ITEM_ID)
	{
		//
		removeInfoItemUI();
	}

	// remove UI of the medical kit
	if(previousItem == MEDICAL_KIT_ID)
	{
		//
		removeHealButton();
	}

	// the current item is a gun?
	if(isItemAGun(currentItem) && needsToLoadTheUI(currentItem, true))
	{
		if(!isItemAGun(previousItem) || !needsToLoadTheUI(previousItem, false))
			displayShootAndAimButtons(true);

		// reset clicks and long clicks
		resetRunnables();
		currentActivity.runOnUiThread(new java.lang.Runnable(
		{
			run: function()
			{
				shotText.setOnTouchListener(new android.view.View.OnTouchListener()
				{
					onTouch: function(v, event)
					{
						if(minecraftStyleForButtons)
							MinecraftButtonLibrary.onTouch(v, event, false); // make touch effect
						return false;
					}
				});
			}
		}));

		// load current gun
		var currentGun = getGun(currentItem);

		// reset flamethrower tick
		if(currentGun.isFlamethrower)
			flameTick = 2;

		// load sounds for the gun
		if(!currentGun.hasntShootingSound)
			Sound.loadSoundPoolFromPath(sdcard + "/games/com.mojang/desnoguns-sounds/" + currentGun.sound);

		// assault rifles, sub machine guns and light machine guns
		if(currentGun.type == BUTTON_TYPE_ON_TOUCH)
		{
			// load touch events
			if(shouldReload())
			{
				// survival or creative with reload option enabled
				currentActivity.runOnUiThread(new java.lang.Runnable(
				{
					run: function()
					{
						shotText.setOnTouchListener(new android.view.View.OnTouchListener()
						{
							onTouch: function(v, event)
							{
								if(minecraftStyleForButtons)
									MinecraftButtonLibrary.onTouch(v, event, false); // make touch effect
								onTouchWeaponShoot(event, currentGun, true);
								return false;
							}
						});
					}
				}));
			} else
			{
				// creative with reload option disabled
				currentActivity.runOnUiThread(new java.lang.Runnable(
				{
					run: function()
					{
						shotText.setOnTouchListener(new android.view.View.OnTouchListener()
						{
							onTouch: function(v, event)
							{
								if(minecraftStyleForButtons)
									MinecraftButtonLibrary.onTouch(v, event, false); // make touch effect
								onTouchWeaponShoot(event, currentGun, false);
								return false;
							}
						});
					}
				}));
			}
		}

		// single shot weapons
		if(currentGun.type == BUTTON_TYPE_ON_CLICK)
		{
			// load click event
			onClickRunnable = (new java.lang.Runnable(
			{
				run: function()
				{
					onClickWeaponShoot(currentGun);
				}
			}));
		}

		// guns with warmup
		if(currentGun.type == BUTTON_TYPE_ON_TOUCH_WITH_WAIT)
		{
			// load spin sound
			try {
				gunSpinSound.reset();
				gunSpinSound.setDataSource(sdcard + "/games/com.mojang/desnoguns-sounds/" + currentGun.spinSound);
				gunSpinSound.setLooping(true);
				gunSpinSound.setVolume(generalVolume, generalVolume);
				gunSpinSound.prepareAsync();
			} catch(e) {
				try {
					// try again, maybe we had a weird sound error
					gunSpinSound.reset();
					gunSpinSound.setDataSource(sdcard + "/games/com.mojang/desnoguns-sounds/" + currentGun.spinSound);
					gunSpinSound.setLooping(true);
					gunSpinSound.setVolume(generalVolume, generalVolume);
					gunSpinSound.prepareAsync();
				} catch(e) { /* sounds not installed */ }
			}

			// load touch events
			if(shouldReload())
			{
				// survival or creative with reload option enabled
				currentActivity.runOnUiThread(new java.lang.Runnable(
				{
					run: function()
					{
						shotText.setOnTouchListener(new android.view.View.OnTouchListener()
						{
							onTouch: function(v, event)
							{
								if(minecraftStyleForButtons)
									MinecraftButtonLibrary.onTouch(v, event, false); // make touch effect
								onTouchWithWaitWeaponShoot(event, currentGun, true);
								return false;
							}
						});
					}
				}));
			} else
			{
				// creative with reload option disabled
				currentActivity.runOnUiThread(new java.lang.Runnable(
				{
					run: function()
					{
						shotText.setOnTouchListener(new android.view.View.OnTouchListener()
						{
							onTouch: function(v, event)
							{
								if(minecraftStyleForButtons)
									MinecraftButtonLibrary.onTouch(v, event, false); // make touch effect
								onTouchWithWaitWeaponShoot(event, currentGun, false);
								return false;
							}
						});
					}
				}));
			}
		}

		// set ammo text
		if(shouldReload())
			setAmmoTextFromGun(currentGun);
		else
			setAmmoText(" ");
	} else
	{
		if(isItemAGun(previousItem))
		{
			// the item before was weapon, now it isn't
			removeShootAndAimButtons();
		}
	}

	// medical kit
	if(currentItem == MEDICAL_KIT_ID)
	{
		//
		displayHealButton();
	}

	// grenade
	if(currentItem == GRENADE.id)
	{
		displayShootAndAimButtons(false);

		// load click event
		onClickRunnable = (new java.lang.Runnable(
		{
			run: function()
			{
				shootGrenadeHand(GRENADE);
				if(Level.getGameMode() == GameMode.SURVIVAL)
					Player.decreaseByOneCarriedItem();
			}
		}));
		setAmmoText(" ");
	}

	// fragment
	if(currentItem == FRAGMENT.id)
	{
		displayShootAndAimButtons(false);

		// load click event
		onClickRunnable = (new java.lang.Runnable(
		{
			run: function()
			{
				shootGrenadeHand(FRAGMENT);
				if(Level.getGameMode() == GameMode.SURVIVAL)
					Player.decreaseByOneCarriedItem();
			}
		}));
		setAmmoText(" ");
	}

	// molotov
	if(currentItem == MOLOTOV.id)
	{
		displayShootAndAimButtons(false);

		// load click event
		onClickRunnable = (new java.lang.Runnable(
		{
			run: function()
			{
				shootGrenadeHand(MOLOTOV);
				if(Level.getGameMode() == GameMode.SURVIVAL)
					Player.decreaseByOneCarriedItem();
			}
		}));
		setAmmoText(" ");
	}

	// smoke grenade
	if(currentItem == SMOKE.id)
	{
		displayShootAndAimButtons(false);

		// load click event
		onClickRunnable = (new java.lang.Runnable(
		{
			run: function()
			{
				shootGrenadeHand(SMOKE);
				if(Level.getGameMode() == GameMode.SURVIVAL)
					Player.decreaseByOneCarriedItem();
			}
		}));
		setAmmoText(" ");
	}

	// DesnoGuns info
	if(currentItem == INFO_ITEM_ID)
	{
		//
		displayInfoItemUI();
	}
}

function modTick()
{
	ModTickFunctions.checkChangedCarriedItem();

	ModTickFunctions.onTouchShooting();

	ModTickFunctions.explosiveWeapons();

	incendiaryGrenadeLauncher();

	ModTickFunctions.molotov();

	ModTickFunctions.smokeGrenade();
	
	ModTickFunctions.parachute();

	ModTickFunctions.riotShield();
	
	ModTickFunctions.unstuckPigmenEE();

	/*if(DEBUG1)
	{
		ModPE.showTipMessage(Entity.getVelY(Player.getEntity()));
	}*/
}

var ModTickFunctions = {

	checkChangedCarriedItem: function()
	{
		if(Player.getCarriedItem() != previousCarriedItem)
			changeCarriedItemHook(Player.getCarriedItem(), previousCarriedItem);
		else
		{
			// switching between items with same id but different damage for example
			if(Player.getSelectedSlotId() != previousSlotId)
			{
				changeCarriedItemHook(previousCarriedItem, previousCarriedItem);
			}
		}
		previousCarriedItem = Player.getCarriedItem();
		previousSlotId = Player.getSelectedSlotId();
	},

	onTouchShooting: function()
	{
		if(isShooting && shootingRunnable != null)
		{
			shootingRunnable.run();
		} else
		{
			if(currentShotTicks != 0)
				currentShotTicks = 0;
		}
	},

	explosiveWeapons: function()
	{
		for(var i in explosiveWeapons)
		{
			for(var j in explosiveWeapons[i].bulletsArray)
			{
				if(explosiveWeapons[i].hasExplosiveBulletsOnTouch)
				{
					var arrow = explosiveWeapons[i].bulletsArray[j];
					var xArrow = Entity.getX(arrow.entity);
					var yArrow = Entity.getY(arrow.entity);
					var zArrow = Entity.getZ(arrow.entity);
					if(arrow.previousX == xArrow && arrow.previousY == yArrow && arrow.previousZ == zArrow)
					{
						Level.explode(xArrow, yArrow, zArrow, explosiveWeapons[i].bulletsExplosionRadius);

						Entity.remove(arrow.entity);
						explosiveWeapons[i].bulletsArray.splice(j, 1);
					} else
					{
						if(xArrow == 0 && yArrow == 0 && zArrow == 0)
						{
							// the arrow hit an entity
							Level.explode(arrow.previousX, arrow.previousY, arrow.previousZ, explosiveWeapons[i].bulletsExplosionRadius);

							explosiveWeapons[i].bulletsArray.splice(j, 1);
						} else
						{
							arrow.previousX = xArrow;
							arrow.previousY = yArrow;
							arrow.previousZ = zArrow;
						}
					}
				}

				if(explosiveWeapons[i].hasExplosiveBulletsOnTime)
				{
					var arrow = explosiveWeapons[i].bulletsArray[j];
					var xArrow = Entity.getX(arrow.entity);
					var yArrow = Entity.getY(arrow.entity);
					var zArrow = Entity.getZ(arrow.entity);

					if(xArrow != 0 && yArrow != 0 && zArrow != 0)
					{
						// save the last position of the arrow, needed if the arrow is removed before it explodes
						arrow.previousX = xArrow;
						arrow.previousY = yArrow;
						arrow.previousZ = zArrow;
					}
				}
			}
		}
	},

	molotov: function()
	{
		for(var i in MOLOTOV.grenadesArray)
		{
			var grenade = MOLOTOV.grenadesArray[i];
			var xGrenade = Entity.getX(grenade.entity);
			var yGrenade = Entity.getY(grenade.entity);
			var zGrenade = Entity.getZ(grenade.entity);
			//ModPE.showTipMessage("x: " + Math.floor(xGrenade) + "y: " + Math.floor(yGrenade) + "z: " + Math.floor(zGrenade));

			if(xGrenade == 0 && yGrenade == 0 && zGrenade == 0)
			{
				// the entity has been removed

				// fire!!!!
				var xStarting = Math.floor(grenade.previousX) - Math.floor(MOLOTOV.grenadesExplosionDiameter / 2);
				var yStarting = Math.floor(grenade.previousY) - Math.floor(MOLOTOV.grenadesExplosionDiameter / 2);
				var zStarting = Math.floor(grenade.previousZ) - Math.floor(MOLOTOV.grenadesExplosionDiameter / 2);
				for(var xExplosion = xStarting; xExplosion <= xStarting + MOLOTOV.grenadesExplosionDiameter; xExplosion++)
				{
					for(var yExplosion = yStarting; yExplosion <= yStarting + MOLOTOV.grenadesExplosionDiameter; yExplosion++)
					{
						for(var zExplosion = zStarting; zExplosion <= zStarting + MOLOTOV.grenadesExplosionDiameter; zExplosion++)
						{
							var setFire = true;
							if(xExplosion == xStarting || xExplosion == xStarting + MOLOTOV.grenadesExplosionDiameter || zExplosion == zStarting || zExplosion == zStarting + MOLOTOV.grenadesExplosionDiameter)
							{
								setFire = java.util.Random().nextBoolean();
							}
							if(setFire && (Level.getTile(xExplosion, yExplosion, zExplosion) == 0 || Level.getTile(xExplosion, yExplosion, zExplosion) == 31))
							{
								Level.setTile(xExplosion, yExplosion, zExplosion, 51);
							}
						}
					}
				}

				Sound.playFromFileName("MolotovExplosion.mp3", grenade.previousX, grenade.previousY, grenade.previousZ);

				//clientMessage("x: " + Math.floor(grenade.previousX ) + "y: " + Math.floor(grenade.previousY) + "z: " + Math.floor(grenade.previousZ));
				Entity.remove(grenade.entity);
				MOLOTOV.grenadesArray.splice(i, 1);
			} else
			{
				Level.addParticle(5, xGrenade, yGrenade, zGrenade, 0, 0, 0, 1);
				grenade.previousX = xGrenade;
				grenade.previousY = yGrenade;
				grenade.previousZ = zGrenade;
			}
		}
	},

	smokeGrenade: function()
	{
		for(var i in SMOKE.grenadesArray)
		{
			for(var j = 0; j < 9; j++)
			{
				if(SMOKE.grenadesArray[i] != null)
				{
					var entity = SMOKE.grenadesArray[i].entity;
					var speed;
					var randomOffset;

					var dir = getDirection(Math.floor(Math.random() * 360), Math.floor((Math.random() * 225) + 120)); // getDirection(randomYaw, randomPitch);

					var distance = Math.random() * 0.8 + 1.8;
					var x = Entity.getX(entity) + (dir.x * distance);
					var y = Entity.getY(entity) + (dir.y * (distance - 0.5)); // -0.5 to make it not a perfect sphere and add a "gravity" effect
					var z = Entity.getZ(entity) + (dir.z * distance);

					speed = Math.random() * 0.08 + 0.02;
					randomOffset = Math.random() - 0.5;
					Level.addParticle(SMOKE.smokeParticle, x + randomOffset, y + randomOffset, z + randomOffset, dir.x * speed, dir.y * speed * 0.8, dir.z * speed, 1);
					
					speed = Math.random() * 0.08 + 0.02;
					randomOffset = Math.random() - 0.5;
					Level.addParticle(SMOKE.smokeParticle, x + randomOffset, y + randomOffset, z + randomOffset, dir.x * speed, dir.y * speed * 0.8, dir.z * speed, 1);
				}
			}

			if(SMOKE.grenadesArray[i] != null)
			{
				SMOKE.grenadesArray[i].effectsTick++;
				if(SMOKE.grenadesArray[i].effectsTick >= 10)
				{
					for(var j in players)
					{
						if(checkProximity(SMOKE.grenadesArray[i].entity, players[j], 5))
						{
							Entity.addEffect(players[j], MobEffect.movementSlowdown, 100, 1, false, false);
							Entity.addEffect(players[j], MobEffect.weakness, 100, 1, false, false);
						}
					}
					SMOKE.grenadesArray[i].effectsTick = 0;
				}
			}
		}
	},

	parachute: function()
	{
		if(Player.getCarriedItem() == PARACHUTE_ID)
		{
			// player will hit the ground soon
			if(isParachuting && Level.getTile(Math.floor(Player.getX()), Math.floor(Player.getY()) - 2, Math.floor(Player.getZ())) > 0)
			{
				if(Entity.getVelY(Player.getEntity()) == VEL_Y_OFFSET)
				{
					// STOP parachuting
					isParachuting = false;

					if(Level.getGameMode() == GameMode.SURVIVAL)
					{
						// Entity.removeEffect(entity, id) doesn't remove particles of the effect https://github.com/zhuowei/MCPELauncher/issues/241
						//Entity.removeEffect(Player.getEntity(), MobEffect.jump);
						Entity.removeAllEffects(Player.getEntity());
						Player.damageCarriedItem();
					}
				}
			}

			// player is falling, oh no! We have to help him.
			if(Entity.getVelY(Player.getEntity()) <= -0.5)
			{
				// START parachuting
				Sound.playFromFileName("benboncan_parachute.mp3");
				isParachuting = true;

				if(Level.getGameMode() == GameMode.SURVIVAL)
					Entity.addEffect(Player.getEntity(), MobEffect.jump, 999999, 254, false, false);
			}
		} else
		{
			if(isParachuting)
			{
				// STOP parachuting
				isParachuting = false;

				if(Level.getGameMode() == GameMode.SURVIVAL)
				{
					// Entity.removeEffect(entity, id) doesn't remove particles of the effect https://github.com/zhuowei/MCPELauncher/issues/241
					//Entity.removeEffect(Player.getEntity(), MobEffect.jump);
					Entity.removeAllEffects(Player.getEntity());

					//Player.damageCarriedItem(); // TODO fix
					//Player.damageItemInInventory(item)
				}
			}
		}
		if(isParachuting)
		{
			// thanks to Anti for this line of code, it works better than making the player riding a chicken (that was my idea)
			Entity.setVelY(Player.getEntity(), -0.10);
		}
	},

	riotShield: function()
	{
		if(Player.getCarriedItem() == RIOT_SHIELD_ID)
		{
			Entity.addEffect(Player.getEntity(), MobEffect.damageResistance, 4, 3, false, false);
			Entity.addEffect(Player.getEntity(), MobEffect.movementSlowdown, 4, 0, false, false);

			if(Level.getGameMode() == GameMode.SURVIVAL)
				Player.damageCarriedItem();
		}
	},

	unstuckPigmenEE: function()
	{
		// Sin0psysS's spawning pattern code (with some changes by me)
		if(unstuck >= 1)
		{
			for(var i in pigmen)
			{
				if(Level.getTile(Math.floor(Entity.getX(pigmen[i])), Math.floor(Entity.getY(pigmen[i])), Math.floor(Entity.getZ(pigmen[i]))) != 0)
				{
					Entity.setPosition(pigmen[i], Entity.getX(pigmen[i]), Entity.getY(pigmen[i]) + 1, Entity.getZ(pigmen[i]));
				}
			}
			unstuck--;
		}
	}
};


//########################################################################################################################################################
// Added functions (No GUI and No render)
//########################################################################################################################################################

//########## WEAPONS functions ##########
function isItemAGun(itemId)
{
	//
	return(itemId >= 460 && itemId <= 512) || (itemId >= 3366 && itemId <= 3369);
}

function addNewGun(gun)
{
	if(gun.textureNumber > 0)
		Item.defineItem(gun.id, gun.texture, gun.textureNumber, gun.name, 1);
	else
		Item.defineItem(gun.id, gun.texture, 0, gun.name, 1);
	addGunCraftingRecipe(gun.id, 1, gun.recipe);
	Item.setMaxDamage(gun.id, gun.ammo);
	Item.setCategory(gun.id, ITEM_CATEGORY_TOOL);
	Item.setVerticalRender(gun.id);
}

function addGunCraftingRecipe(id, howMany, recipe)
{
	// here add other items for crafting with the chosen letter.
	Item.addShapedRecipe(id, howMany, 0, recipe, ["i", 265, 0, "r", 331, 0, "s", 287 /*string*/, 0, "|", 262 /*arrow*/, 0, "a", AMMO_ASSAULT_RIFLE_ID, 0, "b", AMMO_SUB_MACHINE_ID, 0, "c", AMMO_LIGHT_MACHINE_ID, 0, "d", AMMO_SNIPER_RIFLE_ID, 0, "e", AMMO_SHOTGUN_ID, 0, "f", AMMO_MACHINE_PISTOL_ID, 0, "g", AMMO_HANDGUN_ID, 0, "h", AMMO_LAUNCHER_ID, 0, "j", AMMO_MINIGUN_ID, 0,  "k", AMMO_ARROW_EXPLOSIVE_ID, 0]);
}

function shootGrenadeHand(grenadeObject)
{
	var yawAccuracyValue = ((Math.random() * RANDOMNESS) - (RANDOMNESS / 2)) * grenadeObject.accuracy;
	var pitchAccuracyValue = ((Math.random() * RANDOMNESS) - (RANDOMNESS / 2)) * grenadeObject.accuracy;
	var playerShootDir = getDirection(getYaw() + yawAccuracyValue, getPitch() + pitchAccuracyValue);

	var handShootDir = getDirection(getYaw() + 30, getPitch());

	if(grenadeObject.explodeOnTouch)
		var grenade = Level.spawnMob(getPlayerX() + (handShootDir.x * 2), getPlayerY() + (handShootDir.y * 2.5), getPlayerZ() + (handShootDir.z * 2), 81);
	else
	{
		var grenade = Level.spawnMob(getPlayerX() + (handShootDir.x * 2), getPlayerY() + (handShootDir.y * 2.5), getPlayerZ() + (handShootDir.z * 2), 11);
		Entity.setHealth(grenade, 99999);
	}
	setVelX(grenade, playerShootDir.x * grenadeObject.grenadeSpeed);
	setVelY(grenade, playerShootDir.y * grenadeObject.grenadeSpeed);
	setVelZ(grenade, playerShootDir.z * grenadeObject.grenadeSpeed);
	if(grenadeObject.id == GRENADE.id || grenadeObject.id == SMOKE.id)
	{
		Entity.setGrenadeRender(grenade);
		Entity.setMobSkin(grenade, "mob/grenade.png");
	}
	if(grenadeObject.id == FRAGMENT.id)
	{
		Entity.setGrenadeRender(grenade);
		Entity.setMobSkin(grenade, "mob/fraggrenade.png");
	}

	if(grenadeObject.isWithFire)
		Entity.setFireTicks(grenade, 1000);

	if(grenadeObject.id == SMOKE.id)
		grenadeObject.grenadesArray.push(new smokeGrenadeClass(grenade));
	else
		grenadeObject.grenadesArray.push(new entityClass(grenade));

	if(!grenadeObject.explodeOnTouch)
	{
		if(grenadeObject.id == FRAGMENT.id)
		{
			new android.os.Handler().postDelayed(new java.lang.Runnable(
			{
				run: function()
				{
					if(isInGame && FRAGMENT.grenadesArray.length > 0)
					{
						// push() put the object at the end so the first object ( [0] ) is the object that will explode
						var explosionX = Entity.getX(FRAGMENT.grenadesArray[0].entity);
						var explosionY = Entity.getY(FRAGMENT.grenadesArray[0].entity);
						var explosionZ = Entity.getZ(FRAGMENT.grenadesArray[0].entity);
						Entity.remove(FRAGMENT.grenadesArray[0].entity);
						FRAGMENT.grenadesArray.splice(0, 1);

						for(var i = 0; i < FRAGMENT.howManyFragments; i++)
						{
							var fragment = Level.spawnMob(explosionX + ((Math.random() * 2) - 1), explosionY + ((Math.random() * 2) - 1), explosionZ + ((Math.random() * 2) - 1), 11);
							Entity.setHealth(fragment, 99999);
							Entity.setGrenadeRender(fragment);
							Entity.setMobSkin(fragment, "mob/fraggrenade.png");
							FRAGMENT.fragmentArray.push(new entityClass(fragment));

							new android.os.Handler().postDelayed(new java.lang.Runnable(
							{
								run: function()
								{
									if(isInGame && FRAGMENT.fragmentArray.length > 0)
									{
										if(infiniteGrenade)
										{
											fragmentShit();
										} else
										{
											var fragmentX = Entity.getX(FRAGMENT.fragmentArray[0].entity);
											var fragmentY = Entity.getY(FRAGMENT.fragmentArray[0].entity);
											var fragmentZ = Entity.getZ(FRAGMENT.fragmentArray[0].entity);
											Entity.remove(FRAGMENT.fragmentArray[0].entity);
											FRAGMENT.fragmentArray.splice(0, 1);

											Level.explode(fragmentX, fragmentY, fragmentZ, FRAGMENT.grenadesExplosionRadius);
										}
									}
								}
							}), FRAGMENT.fragmentDelay);
						}

						Level.explode(explosionX, explosionY, explosionZ, FRAGMENT.grenadesExplosionRadius);
					}
				}
			}), grenadeObject.delay);
		}

		if(grenadeObject.id == GRENADE.id)
		{
			new android.os.Handler().postDelayed(new java.lang.Runnable(
			{
				run: function()
				{
					if(isInGame && GRENADE.grenadesArray.length > 0)
					{
						// push() put the object at the end so the first object ( [0] ) is the object that will explode
						var explosionX = Entity.getX(GRENADE.grenadesArray[0].entity);
						var explosionY = Entity.getY(GRENADE.grenadesArray[0].entity);
						var explosionZ = Entity.getZ(GRENADE.grenadesArray[0].entity);
						Entity.remove(GRENADE.grenadesArray[0].entity);
						GRENADE.grenadesArray.splice(0, 1);

						Level.explode(explosionX, explosionY, explosionZ, GRENADE.grenadesExplosionRadius);
					}
				}
			}), grenadeObject.delay);
		}

		if(grenadeObject.id == SMOKE.id)
		{
			new android.os.Handler().postDelayed(new java.lang.Runnable(
			{
				run: function()
				{
					if(isInGame && SMOKE.grenadesArray.length > 0)
					{
						var entity = SMOKE.grenadesArray[0].entity;
						SMOKE.grenadesArray.splice(0, 1);
						Entity.remove(entity);
					}
				}
			}), grenadeObject.delay);

			new android.os.Handler().postDelayed(new java.lang.Runnable(
			{
				run: function()
				{
					if(isInGame && SMOKE.grenadesArray.length > 0)
					{
						players = Server.getAllPlayers();
					}
				}
			}), 1);

			Sound.playFromFileName("smoke-grenade.mp3");
		}
	}
}

function fragmentShit()
{
	// different number of fragments and different delay

	var explosionX = Entity.getX(FRAGMENT.fragmentArray[0].entity);
	var explosionY = Entity.getY(FRAGMENT.fragmentArray[0].entity);
	var explosionZ = Entity.getZ(FRAGMENT.fragmentArray[0].entity);
	Entity.remove(FRAGMENT.fragmentArray[0].entity);
	FRAGMENT.fragmentArray.splice(0, 1);

	for(var i = 0; i < 2; i++)
	{
		var fragment = Level.spawnMob(explosionX + ((Math.random() * 2) - 1), explosionY + ((Math.random() * 2) - 1), explosionZ + ((Math.random() * 2) - 1), 11);
		Entity.setHealth(fragment, 99999);
		Entity.setGrenadeRender(fragment);
		Entity.setMobSkin(fragment, "mob/fraggrenade.png");
		FRAGMENT.fragmentArray.push(new entityClass(fragment));

		new android.os.Handler().postDelayed(new java.lang.Runnable(
		{
			run: function()
			{
				if(isInGame && FRAGMENT.fragmentArray.length > 0)
				{
					fragmentShit();
				}
			}
		}), FRAGMENT.fragmentDelay * 2);
	}

	Level.explode(explosionX, explosionY, explosionZ, FRAGMENT.grenadesExplosionRadius);
}

function smokeGrenadeClass(entity)
{
	var smokeObject = new entityClass(entity);
	smokeObject.effectsTick = 0;
	return smokeObject;
}

function shoot(gun)
{
	if(gun.isShotgun)
	{
		shootShotgun(gun);
	}

	if(gun.isFlamethrower)
	{
		shootFlamethrower(gun);
	}

	if(gun.isGrenadeLauncher)
	{
		shootGrenadeWeapon(gun);
	}

	if(!(gun.isShotgun || gun.isFlamethrower || gun.isGrenadeLauncher)) // not shotgun and not flamethrower
	{
		shootSingleBullet(gun);
	}
}

function shootShotgun(gun)
{
	// multiple arrows

	var gunAccuracy = getDefaultAccuracy(gun);

	var playerDir = getDirection(getYaw(), getPitch());
	var bulletsPerShotForXY = gun.shotgunWidth / (gun.shotgunBulletsPerLineShot - 1) * 2;
	for(var i = -gun.shotgunWidth; i <= gun.shotgunWidth; i += bulletsPerShotForXY)
	{
		for(var j = -gun.shotgunWidth; j <= gun.shotgunWidth; j += bulletsPerShotForXY)
		{
			var yawAccuracyValue = ((Math.random() * RANDOMNESS) - (RANDOMNESS / 2)) * gunAccuracy;
			var pitchAccuracyValue = ((Math.random() * RANDOMNESS) - (RANDOMNESS / 2)) * gunAccuracy;
			var gunShootDir = getDirection(getYaw() + yawAccuracyValue + i, getPitch() + pitchAccuracyValue + j);

			var arrow = shootBullet(gun, playerDir, gunShootDir);

			if(gun.hasExplosiveBulletsOnTouch)
				gun.bulletsArray.push(new entityClass(arrow));
		}
	}
}

function shootFlamethrower(gun)
{
	// fire

	var gunAccuracy = getDefaultAccuracy(gun);

	var yawAccuracyValue = ((Math.random() * RANDOMNESS) - (RANDOMNESS / 2)) * gun.accuracy;
	var pitchAccuracyValue = ((Math.random() * RANDOMNESS) - (RANDOMNESS / 2)) * gun.accuracy;
	var playerShootDir = getDirection(getYaw() + yawAccuracyValue, getPitch() + pitchAccuracyValue);

	var flameShootDir = getDirection(getYaw() + 45, getPitch());

	var xDir;
	var yDir;
	var zDir;
	var tile;

	// particles near the player
	xDir = Player.getX() + (playerShootDir.x * 0.75) + flameShootDir.x;
	yDir = Player.getY() + (playerShootDir.y * 0.75) - 0.3;
	zDir = Player.getZ() + (playerShootDir.z * 0.75) + flameShootDir.z;

	Level.addParticle(5, xDir + Math.random() - 0.5, yDir, zDir + Math.random() - 0.5, playerShootDir.x * 0.05, playerShootDir.y * 0.05, playerShootDir.z * 0.05, 1);
	Level.addParticle(5, xDir - Math.random() + 0.5, yDir, zDir - Math.random() + 0.5, playerShootDir.x * 0.05, playerShootDir.y * 0.05, playerShootDir.z * 0.05, 1);


	// first flame tick
	xDir = Player.getX() + (playerShootDir.x * flameTick) + flameShootDir.x;
	yDir = Player.getY() + (playerShootDir.y * flameTick) - 0.3;
	zDir = Player.getZ() + (playerShootDir.z * flameTick) + flameShootDir.z;

	tile = Level.getTile(Math.floor(xDir), Math.floor(yDir), Math.floor(zDir));

	if(tile == 0 || tile == 31) // 31 grass
	{
		if(flameTick > 5)
		{
			Level.setTile(Math.floor(xDir), Math.floor(yDir), Math.floor(zDir), 51);
		} else
		{
			Level.setTile(Math.floor(xDir), Math.floor(yDir), Math.floor(zDir), 51);
		}
	}

	Level.addParticle(5, xDir + Math.random() - 0.5, yDir, zDir + Math.random() - 0.5, playerShootDir.x * 0.05, playerShootDir.y * 0.05, playerShootDir.z * 0.05, 1);
	Level.addParticle(5, xDir - Math.random() + 0.5, yDir, zDir - Math.random() + 0.5, playerShootDir.x * 0.05, playerShootDir.y * 0.05, playerShootDir.z * 0.05, 1);


	flameTick += 0.5;


	// second flame tick
	xDir = Player.getX() + (playerShootDir.x * flameTick) + flameShootDir.x;
	yDir = Player.getY() + (playerShootDir.y * flameTick) - 0.3;
	zDir = Player.getZ() + (playerShootDir.z * flameTick) + flameShootDir.z;

	tile = Level.getTile(Math.floor(xDir), Math.floor(yDir), Math.floor(zDir));

	if(tile == 0 || tile == 31) // 31 grass
		Level.setTile(Math.floor(xDir), Math.floor(yDir), Math.floor(zDir), 51);

	Level.addParticle(5, xDir + Math.random() - 0.5, yDir, zDir + Math.random() - 0.5, playerShootDir.x * 0.05, playerShootDir.y * 0.05, playerShootDir.z * 0.05, 1);
	Level.addParticle(5, xDir - Math.random() + 0.5, yDir, zDir - Math.random() + 0.5, playerShootDir.x * 0.05, playerShootDir.y * 0.05, playerShootDir.z * 0.05, 1);


	flameTick += 0.5;

	if(flameTick > 10)
		flameTick = 2;
}

function shootGrenadeWeapon(gun)
{
	var gunAccuracy = getDefaultAccuracy(gun);

	var yawAccuracyValue = ((Math.random() * RANDOMNESS) - (RANDOMNESS / 2)) * gunAccuracy;
	var pitchAccuracyValue = ((Math.random() * RANDOMNESS) - (RANDOMNESS / 2)) * gunAccuracy;
	var gunShootDir = getDirection(getYaw() + yawAccuracyValue, getPitch() + pitchAccuracyValue);

	if(gun.hasIncendiaryBullets)
		var grenade = Level.spawnMob(getPlayerX() + (gunShootDir.x * 2), getPlayerY() + (gunShootDir.y * 2.5), getPlayerZ() + (gunShootDir.z * 2), 81);
	else
		var grenade = Level.spawnMob(getPlayerX() + (gunShootDir.x * 2), getPlayerY() + (gunShootDir.y * 2.5), getPlayerZ() + (gunShootDir.z * 2), 65);
	setVelX(grenade, gunShootDir.x * gun.bulletSpeed);
	setVelY(grenade, gunShootDir.y * gun.bulletSpeed);
	setVelZ(grenade, gunShootDir.z * gun.bulletSpeed);

	if(gun.hasIncendiaryBullets)
		gun.grenadesArray.push(new entityClass(grenade));
}

function shootSingleBullet(gun)
{
	// a single arrow

	var gunAccuracy = getDefaultAccuracy(gun);

	var yawAccuracyValue = ((Math.random() * RANDOMNESS) - (RANDOMNESS / 2)) * gunAccuracy;
	var pitchAccuracyValue = ((Math.random() * RANDOMNESS) - (RANDOMNESS / 2)) * gunAccuracy;
	var gunShootDir = getDirection(getYaw() + yawAccuracyValue, getPitch() + pitchAccuracyValue);

	var arrow = shootBullet(gun, gunShootDir);

	if(gun.hasExplosiveBulletsOnTouch || gun.hasExplosiveBulletsOnTime)
		gun.bulletsArray.push(new entityClass(arrow));

	if(gun.hasExplosiveBulletsOnTime)
	{
		Sound.playFromFileName("explosion-countdown.wav");

		new android.os.Handler().postDelayed(new java.lang.Runnable(
		{
			run: function()
			{
				if(isInGame && gun.bulletsArray.length > 0) // gun.bulletsArray.length > 0 fix a crash that happens when the player shoot an explosive bullet, exit the world and re-enter in the world
				{
					// TODO check x y z == 0; if yes then use .x .y .z of Entity class that are put in modTick
					var explosionX = Entity.getX(gun.bulletsArray[0].entity);
					var explosionY = Entity.getY(gun.bulletsArray[0].entity);
					var explosionZ = Entity.getZ(gun.bulletsArray[0].entity);

					if(explosionX == 0 && explosionY == 0 && explosionZ == 0)
					{
						// arrow hit an entity
						Entity.remove(gun.bulletsArray[0].entity);
						Level.explode(gun.bulletsArray[0].previousX, gun.bulletsArray[0].previousY - 1, gun.bulletsArray[0].previousZ, gun.bulletsExplosionRadius); // y - 1 because usually the arrow is removed when it hits an entity and the explosion happens on a previous position that is not on the ground.
					} else
					{
						Entity.remove(gun.bulletsArray[0].entity);
						Level.explode(explosionX, explosionY, explosionZ, gun.bulletsExplosionRadius);
					}
					gun.bulletsArray.splice(0, 1);
				}
			}
		}), gun.bulletsExplosionDelay);
	}
}

function shootBullet(gun, playerDir, arrowDir)
{
	if(arrowDir == null)
		arrowDir = playerDir;

	if(gun.hasIceBullets)
		var arrow = Level.spawnMob(getPlayerX() + (playerDir.x * 2), getPlayerY() + (playerDir.y * 2.5), getPlayerZ() + (playerDir.z * 2), 81);
	else
		var arrow = Level.spawnMob(getPlayerX() + (playerDir.x * 2), getPlayerY() + (playerDir.y * 2.5), getPlayerZ() + (playerDir.z * 2), 80);
	setVelX(arrow, arrowDir.x * gun.bulletSpeed);
	setVelY(arrow, arrowDir.y * gun.bulletSpeed);
	setVelZ(arrow, arrowDir.z * gun.bulletSpeed);

	return arrow;
}

function getDefaultAccuracy(gun)
{
	if(isAiming)
	{
		return gun.accuracy - 1;
	} else
	{
		if(gun.gunType == GUN_TYPE_SNIPER_RIFLE)
			return gun.accuracy + 25;
		else
			return gun.accuracy;
	}
}

function showCloudParticle(amount)
{
	if(amount > 0)
	{
		new android.os.Handler().postDelayed(new java.lang.Runnable(
		{
			run: function()
			{
				if(isInGame)
				{
					var gunDir = getDirection(getYaw() + 30, getPitch());
					for(var i = 0; i < amount; i++)
						Level.addParticle(4, getPlayerX() + (gunDir.x * 1.5), getPlayerY() + (gunDir.y * 1.5), getPlayerZ() + (gunDir.z * 1.5), 0, 0, 0, 1);
				}
			}
		}), 250);
	}
}

function getGun(id)
{
	var currentGun = 0;
	findTheGun:
	for(var i in guns)
	{
		if(id == guns[i].id)
		{
			currentGun = guns[i];
			break findTheGun;
		}
	}
	if(currentGun == 0)
	{
		clientMessage("Error: gun not found in getGun()");
		currentGun = AK47;
	}
	return currentGun;
}

function getGunTypeName(gunType)
{
	switch(gunType)
	{
		case GUN_TYPE_ASSAULT_RIFLE:
		{
			return "Assault Rifle";
		}
		case GUN_TYPE_SUB_MACHINE:
		{
			return "Sub Machine";
		}
		case GUN_TYPE_LIGHT_MACHINE:
		{
			return "Light Machine";
		}
		case GUN_TYPE_SNIPER_RIFLE:
		{
			return "Sniper Rifle";
		}
		case GUN_TYPE_SHOTGUN:
		{
			return "Shotgun";
		}
		case GUN_TYPE_MACHINE_PISTOL:
		{
			return "Machine Pistol";
		}
		case GUN_TYPE_HANDGUN:
		{
			return "Handgun";
		}
		case GUN_TYPE_LAUNCHER:
		{
			return "Launcher";
		}
		case GUN_TYPE_MINIGUN:
		{
			return "Minigun";
		}
	}
}

function setUpGunsWithDate()
{
	var cal = java.util.Calendar.getInstance();
	var day = cal.get(java.util.Calendar.DAY_OF_MONTH);
	var month = cal.get(java.util.Calendar.MONTH);

	if((day > 6 && month == java.util.Calendar.JANUARY) || month == java.util.Calendar.FEBRUARY || (day <= 21 && month == java.util.Calendar.MARCH))
	{
		// winter after Xmas period
		XMAS_SNIPER.name = "Winter Sniper";
		XMAS_MINIGUN.name = "Winter Minigun";
		guns.push(XMAS_MINIGUN);
		guns.push(XMAS_SNIPER);
	}

	if(month == java.util.Calendar.DECEMBER || (day <= 6 && month == java.util.Calendar.JANUARY))
	{
		// Xmas period
		guns.push(XMAS_MINIGUN);
		guns.push(XMAS_SNIPER);
	}
}
//########## WEAPONS functions - END ##########


//########## ON CLICK GUNS functions ##########
function onClickWeaponShoot(gun)
{
	if(latestShotTime == null || java.lang.System.currentTimeMillis() > (latestShotTime + (gun.fireRate * 50)))
	{
		if(shouldReload())
		{
			// survival or creative with reload option enabled
			onClickShootWithReload(gun);
		} else
		{
			// creative with reload option disabled
			onClickShootWithoutReload(gun);
		}
	}
}

function onClickShootWithReload(gun)
{
	if(Player.getCarriedItemData() >= gun.ammo)
	{
		Sound.playFromFileName("EmptyGun.ogg");
		ModPE.showTipMessage("Press the ammo text to reload.");
	} else
	{
		stopReloading();
		Sound.playLoadedSoundPool();
		shoot(gun);
		damageCarriedGun(gun);
		latestShotTime = java.lang.System.currentTimeMillis();
		showCloudParticle(gun.smoke);
		Recoil.makeRecoil(gun);
	}
}

function onClickShootWithoutReload(gun)
{
	Sound.playLoadedSoundPool();
	shoot(gun);
	latestShotTime = java.lang.System.currentTimeMillis();
	showCloudParticle(gun.smoke);
	Recoil.makeRecoil(gun);
}
//########## ON CLICK GUNS functions - END ##########


//########## ON TOUCH GUNS functions ##########
function onTouchWeaponShoot(event, gun, reload)
{
	var action = event.getActionMasked();
	if(action == android.view.MotionEvent.ACTION_CANCEL || action == android.view.MotionEvent.ACTION_UP)
	{
		isShooting = false;
		showCloudParticle(gun.smoke);
	} else
	{
		if(!isShooting)
		{
			isShooting = true;
			currentShotTicks = gun.fireRate;
			if(reload)
				onTouchShootingRunnableWithReload(gun);
			else
				onTouchShootingRunnableWithoutReload(gun);
		}
	}
}

function onTouchShootingRunnableWithReload(gun)
{
	shootingRunnable = (new java.lang.Runnable(
	{
		run: function()
		{
			if(currentShotTicks == gun.fireRate)
			{
				if(Player.getCarriedItemData() >= gun.ammo)
				{
					Sound.playFromFileName("EmptyGun.ogg");
					ModPE.showTipMessage("Press the ammo text to reload.");
				} else
				{
					stopReloading();
					currentShotTicks = 0;
					Sound.playLoadedSoundPool(GUNS_ON_TOUCH_SHOOT_VOLUME);
					shoot(gun);
					damageCarriedGun(gun);
					Recoil.makeRecoil(gun);
				}
			}
			currentShotTicks++;
		}
	}));
}

function onTouchShootingRunnableWithoutReload(gun)
{
	shootingRunnable = (new java.lang.Runnable(
	{
		run: function()
		{
			if(currentShotTicks == gun.fireRate)
			{
				currentShotTicks = 0;
				Sound.playLoadedSoundPool(GUNS_ON_TOUCH_SHOOT_VOLUME);
				shoot(gun);
				Recoil.makeRecoil(gun);
			}
			currentShotTicks++;
		}
	}));
}
//########## ON TOUCH GUNS functions - END ##########


//########## ON TOUCH WITH WAIT GUNS functions ##########
function onTouchWithWaitWeaponShoot(event, gun, reload)
{
	var action = event.getActionMasked();
	if(action == android.view.MotionEvent.ACTION_CANCEL || action == android.view.MotionEvent.ACTION_UP)
	{
		onTouchWithWaitWeaponButtonReleased(gun);
	} else
	{
		if(!isShooting && !isTouchingFireButtonGunsWithWait)
		{
			try
			{
				var warmupSoundString;
				if(gun.hasRandomWarmupSound)
					warmupSoundString = createRandomString(gun.warmupSound);
				else
					warmupSoundString = gun.warmupSound;

				isTouchingFireButtonGunsWithWait = true;
				gunWarmupSound.reset();
				gunWarmupSound.setDataSource(sdcard + "/games/com.mojang/desnoguns-sounds/" + warmupSoundString);
				gunWarmupSound.setVolume(generalVolume, generalVolume);
				gunWarmupSound.prepare();
				gunWarmupSound.setOnCompletionListener(new android.media.MediaPlayer.OnCompletionListener()
				{
					onCompletion: function(mp)
					{
						if(isTouchingFireButtonGunsWithWait)
						{
							isShooting = true;
							gunSpinSound.start();
							currentShotTicks = gun.fireRate;
							if(reload)
								onTouchWithWaitShootingRunnableWithReload(gun);
							else
								onTouchWithWaitShootingRunnableWithoutReload(gun);
						}
					}
				});
				gunWarmupSound.start();
			} catch(e) {
				ModPE.log(getLogText() + "Error in onTouchWithWaitWeaponShoot(): " + e);
				clientMessage("The minigun needs sounds to work properly.");
			}
		}
	}
}

function onTouchWithWaitWeaponButtonReleased(gun)
{
	if(gun.isFlamethrower)
		flameTick = 2;

	isTouchingFireButtonGunsWithWait = false;
	if(gunWarmupSound.isPlaying())
		gunWarmupSound.stop();
	if(isShooting)
		showCloudParticle(gun.smoke);
	isShooting = false;
	try {
		gunSpinSound.stop();
		gunSpinSound.prepareAsync();
	} catch(e) {
		// sometimes an error happens also if you have sounds installed correctly and I didn't find why
		clientMessage("A wild error appeared. See log.");
		ModPE.log(getLogText() + "Error in onTouchWithWaitWeaponButtonReleased(): " + e);
		try {
			gunSpinSound.reset();
			gunSpinSound.setDataSource(sdcard + "/games/com.mojang/desnoguns-sounds/" + gun.spinSound);
			gunSpinSound.setLooping(true);
			gunSpinSound.setVolume(generalVolume, generalVolume);
			gunSpinSound.prepareAsync();
		} catch(e) { /* sounds not installed */ }
	}

	if(!gun.hasntCooldownSound)
		Sound.playFromFileName(gun.cooldownSound);
}

function onTouchWithWaitShootingRunnableWithReload(gun)
{
	shootingRunnable = (new java.lang.Runnable(
	{
		run: function()
		{
			if(currentShotTicks == gun.fireRate)
			{
				if(Player.getCarriedItemData() >= gun.ammo)
				{
					Sound.playFromFileName("EmptyGun.ogg");
					ModPE.showTipMessage("Press the ammo text to reload.");
				} else
				{
					stopReloading();
					currentShotTicks = 0;
					if(!gun.hasntShootingSound)
						Sound.playLoadedSoundPool(GUNS_ON_TOUCH_WITH_WAIT_SHOOT_VOLUME);
					shoot(gun);
					damageCarriedGun(gun);
					Recoil.makeRecoil(gun);
				}
			}
			currentShotTicks++;
		}
	}));
}

function onTouchWithWaitShootingRunnableWithoutReload(gun)
{
	shootingRunnable = (new java.lang.Runnable(
	{
		run: function()
		{
			if(currentShotTicks == gun.fireRate)
			{
				currentShotTicks = 0;
				if(!gun.hasntShootingSound)
					Sound.playLoadedSoundPool(GUNS_ON_TOUCH_WITH_WAIT_SHOOT_VOLUME);
				shoot(gun);
				Recoil.makeRecoil(gun);
			}
			currentShotTicks++;
		}
	}));
}
//########## ON TOUCH WITH WAIT GUNS functions - END ##########


//########## SOUND functions ##########
var sound1;
var sound2;
var sound3;

var Sound = {

	playFromFileName: function(fileName, x, y, z)
	{
		var volume = 1.0;

		// change volume based on distance from source
		if(!(x == null || y == null || z == null))
		{
			var distance = Math.sqrt( Math.pow(x - Player.getX(), 2) + Math.pow(y - Player.getY(), 2) + Math.pow(z - Player.getZ(), 2) );
			if(distance > MAX_LOGARITHMIC_VOLUME)
				volume = 0.0;
			else
			{
				volume = 1 - (Math.log(distance) / Math.log(MAX_LOGARITHMIC_VOLUME));
			}
		}

		// apply general volume
		volume = volume * generalVolume;

		// play sound
		try
		{
			if(sound1 == null)
			{
				if(DEBUG1)
					clientMessage("sound 1");

				if(sound1 == null)
					sound1 = new android.media.MediaPlayer();
				sound1.reset();
				sound1.setDataSource(sdcard + "/games/com.mojang/desnoguns-sounds/" + fileName);
				sound1.setVolume(volume, volume);
				sound1.prepare();
				sound1.setOnCompletionListener(new android.media.MediaPlayer.OnCompletionListener()
				{
					onCompletion: function(mp)
					{
						if(DEBUG1)
							clientMessage("sound 1 finish");
						sound1.release();
						sound1 = null;
					}
				});
				sound1.start();
				return 1; // END
			}
			if(sound2 == null)
			{
				if(DEBUG1)
					clientMessage("sound 2");

				if(sound2 == null)
					sound2 = new android.media.MediaPlayer();
				sound2.reset();
				sound2.setDataSource(sdcard + "/games/com.mojang/desnoguns-sounds/" + fileName);
				sound2.setVolume(volume, volume);
				sound2.prepare();
				sound2.setOnCompletionListener(new android.media.MediaPlayer.OnCompletionListener()
				{
					onCompletion: function(mp)
					{
						if(DEBUG1)
							clientMessage("sound 2 finish");
						sound2.release();
						sound2 = null;
					}
				});
				sound2.start();
				return 2; // END
			}
			if(sound3 == null)
			{
				if(DEBUG1)
					clientMessage("sound 3");

				if(sound3 == null)
					sound3 = new android.media.MediaPlayer();
				sound3.reset();
				sound3.setDataSource(sdcard + "/games/com.mojang/desnoguns-sounds/" + fileName);
				sound3.setVolume(volume, volume);
				sound3.prepare();
				sound3.setOnCompletionListener(new android.media.MediaPlayer.OnCompletionListener()
				{
					onCompletion: function(mp)
					{
						if(DEBUG1)
							clientMessage("sound 3 finish");
						sound3.release();
						sound3 = null;
					}
				});
				sound3.start();
				return 3; // END
			} else
			{
				if(DEBUG1)
					clientMessage("sound 1 all");

				if(sound1 == null)
					sound1 = new android.media.MediaPlayer();
				sound1.reset();
				sound1.setDataSource(sdcard + "/games/com.mojang/desnoguns-sounds/" + fileName);
				sound1.setVolume(volume, volume);
				sound1.prepare();
				sound1.setOnCompletionListener(new android.media.MediaPlayer.OnCompletionListener()
				{
					onCompletion: function(mp)
					{
						if(DEBUG1)
							clientMessage("sound 1 all finish");
						sound1.release();
						sound1 = null;
					}
				});
				sound1.start();
				return 1; // END
			}
		} catch(err)
		{
			if(!displayedMessageNoSound)
			{
				ModPE.showTipMessage(getLogText() + "Sounds not installed!");
				displayedMessageNoSound = true;
				ModPE.log(getLogText() + "Error in playSoundFromFile: " + err);
			}
		}
	},

	loadSoundPoolFromPath: function(path)
	{
		try
		{
			soundPool = new android.media.SoundPool(5, android.media.AudioManager.STREAM_MUSIC, 0);
			soundID = soundPool.load(path, 1);
		} catch(err)
		{
			ModPE.showTipMessage(getLogText() + "Sounds not installed!");
			ModPE.log(getLogText() + "Error in loadSoundPoolFromPath: " + err);
		}
	},

	playLoadedSoundPool: function(volume)
	{
		if(volume == null)
			volume = 1.0;

		try
		{
			volume = volume * generalVolume;
			soundPool.play(soundID, volume, volume, 1, 0, 1.0);
		} catch(e) { /* probably sounds not installed error */ }
	}
};
//########## SOUND functions - END ##########


//########## SHOOT UI functions ##########
function displayShootAndAimButtons(loadAimButton)
{
	currentActivity.runOnUiThread(new java.lang.Runnable(
	{
		run: function()
		{
			try
			{
				if(loadAimButton)
				{
					var aimText;
					if(minecraftStyleForButtons)
					{
						aimText = MinecraftButton(buttonsSize);
						aimText.setText("Aim");
					} else
					{
						aimText = defaultColoredMinecraftButton("aim", "#FFFFFFFF");
					}
					aimText.setOnClickListener(new android.view.View.OnClickListener()
					{
						onClick: function(v)
						{
							aim();
							return false;
						}
					});
					aimText.setSoundEffectsEnabled(true);

					popupAim = new android.widget.PopupWindow(aimText, android.view.ViewGroup.LayoutParams.WRAP_CONTENT, android.view.ViewGroup.LayoutParams.WRAP_CONTENT);
					popupAim.setBackgroundDrawable(new android.graphics.drawable.ColorDrawable(android.graphics.Color.TRANSPARENT));
					popupAim.showAtLocation(currentActivity.getWindow().getDecorView(), (switchedButtonsPosition ? android.view.Gravity.LEFT : android.view.Gravity.RIGHT) | android.view.Gravity.CENTER, 0, pixelsOffsetButtons);
				}



				displaySight();



				if(minecraftStyleForButtons)
				{
					shotText = MinecraftButton(buttonsSize, false);
					shotText.setText("Fire");
				} else
				{
					shotText = defaultColoredMinecraftButton("fire", "#FFDE0000");
				}
				shotText.setOnClickListener(new android.view.View.OnClickListener()
				{
					onClick: function(v)
					{
						if(onClickRunnable != null)
							onClickRunnable.run();
						return false;
					}
				});
				shotText.setOnLongClickListener(new android.view.View.OnLongClickListener()
				{
					onLongClick: function(v)
					{
						return false;
					}
				});
				shotText.setSoundEffectsEnabled(false);

				popupShot = new android.widget.PopupWindow(shotText, android.view.ViewGroup.LayoutParams.WRAP_CONTENT, android.view.ViewGroup.LayoutParams.WRAP_CONTENT);
				popupShot.setBackgroundDrawable(new android.graphics.drawable.ColorDrawable(android.graphics.Color.TRANSPARENT));
				popupShot.setOutsideTouchable(false);
				popupShot.setSplitTouchEnabled(true);
				popupShot.showAtLocation(currentActivity.getWindow().getDecorView(), (switchedButtonsPosition ? android.view.Gravity.RIGHT : android.view.Gravity.LEFT) | android.view.Gravity.CENTER, 0, pixelsOffsetButtons);



				ammoText = basicMinecraftTextView("null", ammoTextSize);
				ammoText.setOnClickListener(new android.view.View.OnClickListener()
				{
					onClick: function(v)
					{
						reloadAmmo(getGun(Player.getCarriedItem()));
						return false;
					}
				});
				ammoText.setGravity(android.view.Gravity.CENTER);
				ammoText.setTextColor(android.graphics.Color.parseColor("#FFFFFFFF"));
				ammoText.setLayoutParams(new android.view.ViewGroup.LayoutParams(android.view.ViewGroup.LayoutParams.WRAP_CONTENT, android.view.ViewGroup.LayoutParams.WRAP_CONTENT));

				popupAmmo = new android.widget.PopupWindow(ammoText, android.view.ViewGroup.LayoutParams.WRAP_CONTENT, android.view.ViewGroup.LayoutParams.WRAP_CONTENT);
				popupAmmo.setBackgroundDrawable(new android.graphics.drawable.ColorDrawable(android.graphics.Color.TRANSPARENT));
				popupAmmo.showAtLocation(currentActivity.getWindow().getDecorView(), android.view.Gravity.CENTER | android.view.Gravity.BOTTOM, 0, 64 * deviceDensity);
			} catch(err)
			{
				clientMessage("Error: " + err);
			}
		}
	}));
}

function removeShootAndAimButtons()
{
	currentActivity.runOnUiThread(new java.lang.Runnable(
	{
		run: function()
		{
			try {
				popupShot.dismiss();
			} catch(e) {}
			try {
				popupSettingsImage.dismiss();
			} catch(e) {}
			try {
				popupSightImage.dismiss();
			} catch(e) {}
			try {
				popupAmmo.dismiss();
			} catch(e) {}
			try {
				popupAim.dismiss();
			} catch(e) {}
			try {
				popupAiming.dismiss();
			} catch(e) {}
			try {
				popupZoom.dismiss();
			} catch(e) {}
		}
	}));
	currentShotTicks = 0;
}

function resetRunnables()
{
	if(shootingRunnable != null)
	{
		isShooting = false;
		shootingRunnable = null;
	}
	if(onClickRunnable != null)
		onClickRunnable = null;
}
//########## SHOOT UI functions - END ##########


//########## RECOIL functions ##########
var timedRecoilVar;

var Recoil = {

	makeRecoil: function(gun)
	{
		if(gun.fireRate < 2)
		{
			if(gun.type == BUTTON_TYPE_ON_CLICK)
			{
				Recoil.makeLessTimedRecoil(gun);
				return;
			} else
			{
				Recoil.makeInstantRecoil(gun);
				return;
			}
		}

		if(gun.fireRate >= 2 && gun.fireRate <= 5)
		{
			Recoil.makeLessTimedRecoil(gun);
			return;
		}

		// fire rate > 5
		if(gun.recoil >= 15)
		{
			Recoil.makeTimedRecoil(gun);
			return;
		} else
		{
			Recoil.makeLessTimedRecoil(gun);
			return;
		}
	},

	makeInstantRecoil: function(gun)
	{
		var recoilDegree = gun.recoil / RECOIL;
		Entity.setRot(Player.getEntity(), Entity.getYaw(Player.getEntity()), Entity.getPitch(Player.getEntity()) - recoilDegree);
	},

	makeLessTimedRecoil: function(gun)
	{
		var recoilDegree = gun.recoil / RECOIL;
		var timedRecoilVar = recoilDegree / 4;
		currentActivity.runOnUiThread(new java.lang.Runnable(
		{
			run: function()
			{
				new android.os.Handler().postDelayed(new java.lang.Runnable(
				{
					run: function()
					{
						Entity.setRot(Player.getEntity(), Entity.getYaw(Player.getEntity()), Entity.getPitch(Player.getEntity()) - (timedRecoilVar));
					}
				}), 1 * 6);

				new android.os.Handler().postDelayed(new java.lang.Runnable(
				{
					run: function()
					{
						Entity.setRot(Player.getEntity(), Entity.getYaw(Player.getEntity()), Entity.getPitch(Player.getEntity()) - (timedRecoilVar * 0.9));
					}
				}), 2 * 6);

				new android.os.Handler().postDelayed(new java.lang.Runnable(
				{
					run: function()
					{
						Entity.setRot(Player.getEntity(), Entity.getYaw(Player.getEntity()), Entity.getPitch(Player.getEntity()) - (timedRecoilVar * 0.8));
					}
				}), 3 * 6);

				new android.os.Handler().postDelayed(new java.lang.Runnable(
				{
					run: function()
					{
						Entity.setRot(Player.getEntity(), Entity.getYaw(Player.getEntity()), Entity.getPitch(Player.getEntity()) - (timedRecoilVar * 0.7));
					}
				}), 4 * 6);
			}
		}));
	},

	makeTimedRecoil: function(gun)
	{
		var recoilDegree = gun.recoil / RECOIL;
		var timedRecoilVar = recoilDegree / 8;
		currentActivity.runOnUiThread(new java.lang.Runnable(
		{
			run: function()
			{
				for(var ms = 1; ms <= 5; ms++)
				{
					new android.os.Handler().postDelayed(new java.lang.Runnable(
					{
						run: function()
						{
							Entity.setRot(Player.getEntity(), Entity.getYaw(Player.getEntity()), Entity.getPitch(Player.getEntity()) - timedRecoilVar);
						}
					}), ms * 7);
				}

				new android.os.Handler().postDelayed(new java.lang.Runnable(
				{
					run: function()
					{
						Entity.setRot(Player.getEntity(), Entity.getYaw(Player.getEntity()), Entity.getPitch(Player.getEntity()) - (timedRecoilVar * 0.9));
					}
				}), 6 * 7);

				new android.os.Handler().postDelayed(new java.lang.Runnable(
				{
					run: function()
					{
						Entity.setRot(Player.getEntity(), Entity.getYaw(Player.getEntity()), Entity.getPitch(Player.getEntity()) - (timedRecoilVar * 0.75));
					}
				}), 7 * 7);

				new android.os.Handler().postDelayed(new java.lang.Runnable(
				{
					run: function()
					{
						Entity.setRot(Player.getEntity(), Entity.getYaw(Player.getEntity()), Entity.getPitch(Player.getEntity()) - (timedRecoilVar * 0.5));
					}
				}), 8 * 7);
			}
		}));
	}
};
//########## RECOIL functions - END ##########


//########## AIM functions ##########
function displaySight()
{
	currentActivity.runOnUiThread(new java.lang.Runnable(
	{
		run: function()
		{
			try
			{
				if(shouldDisplaySight)
				{
					try {
						popupSightImage.dismiss();
					} catch(e) {}

					var sightImageView = new android.widget.ImageView(currentActivity);
					sightImageView.setImageBitmap(sightPngScaled);

					popupSightImage = new android.widget.PopupWindow(sightImageView, android.view.ViewGroup.LayoutParams.WRAP_CONTENT, android.view.ViewGroup.LayoutParams.WRAP_CONTENT);
					popupSightImage.setBackgroundDrawable(new android.graphics.drawable.ColorDrawable(android.graphics.Color.TRANSPARENT));
					popupSightImage.showAtLocation(currentActivity.getWindow().getDecorView(), android.view.Gravity.CENTER | android.view.Gravity.CENTER, -convertDpToPixel(1), -convertDpToPixel(1));
				}
			} catch(err)
			{
				clientMessage("Error: " + err);
			}
		}
	}));
}

function aim()
{
	if(!isDisplayingAimingAnimation)
	{
		var gun = getGun(Player.getCarriedItem());
		if(gun.hasAimImageLayer)
		{
			// with aim image

			aimingGun = gun;
			if(!isAiming)
			{
				isAiming = true;
				isDisplayingAimingAnimation = true;

				addZoomGradually(gun.zoomLevel - 1); // total steps = gun.zoomLevel - 1; total time: (gun.zoomLevel - 1) * 12

				// last step of decreasing FOV
				new android.os.Handler().postDelayed(new java.lang.Runnable( // executed 1 time. Total: gun.zoomLevel times
				{
					run: function()
					{
						zoomWithFov--;
						ModPE.setFov(zoomWithFov);

						displayAimImageLayer(aimingGun);
						isDisplayingAimingAnimation = false;
					}
				}), gun.zoomLevel * 12);
			} else
			{
				displaySight();
				removeZoomAndAimImageLayer();
			}
		} else
		{
			// just zoom, no aim image

			if(!isAiming)
			{
				isAiming = true;
				isDisplayingAimingAnimation = true;

				addZoomGradually(gun.zoomLevel - 1); // total steps = gun.zoomLevel - 1; total time: (gun.zoomLevel - 1) * 12

				// last step of decreasing FOV
				new android.os.Handler().postDelayed(new java.lang.Runnable( // executed 1 time. Total: gun.zoomLevel times
				{
					run: function()
					{
						zoomWithFov--;
						ModPE.setFov(zoomWithFov);

						isDisplayingAimingAnimation = false;
					}
				}), gun.zoomLevel * 12);
			} else
			{
				removeZoomAndAimImageLayer();
			}
		}
	}
}

function addZoomGradually(amount)
{
	for(var ms = 1; ms <= amount; ms++)
	{
		new android.os.Handler().postDelayed(new java.lang.Runnable(
		{
			run: function()
			{
				zoomWithFov--;
				ModPE.setFov(zoomWithFov);
			}
		}), ms * 12);
	}
}

function removeZoomAndAimImageLayer()
{
	currentActivity.runOnUiThread(new java.lang.Runnable(
	{
		run: function()
		{
			if(!isDisplayingAimingAnimation)
			{
				if(isAiming)
				{
					isAiming = false;
					isDisplayingAimingAnimation = true;
					var removeAiming = zoomWithFov;

					for(var ms = 1; ms < (72 - removeAiming); ms++)
					{
						new android.os.Handler().postDelayed(new java.lang.Runnable(
						{
							run: function()
							{
								zoomWithFov++;
								ModPE.setFov(zoomWithFov);
							}
						}), ms * 12);
					}

					new android.os.Handler().postDelayed(new java.lang.Runnable(
					{
						run: function()
						{
							zoomWithFov++;
							ModPE.setFov(zoomWithFov);

							isDisplayingAimingAnimation = false;
						}
					}), (72 - removeAiming) * 12);
				}
				try {
					popupAiming.dismiss();
				} catch(e) {}
				try {
					popupZoom.dismiss();
				} catch(e) {}
			}
		}
	}));
}

function displayAimImageLayer(gun)
{
	currentActivity.runOnUiThread(new java.lang.Runnable(
	{
		run: function()
		{
			try
			{
				// get the correct image
				var aimImage;
				switch(gun.id)
				{
					case BARRETT.id:
					case BARRETT_EXPLOSIVE.id:
					{
						aimImage = barrettUIDecoded;
						break;
					}
					case DRAGUNOV.id:
					{
						aimImage = dragunovUIDecoded;
						break;
					}
					case M21.id:
					{
						aimImage = m21UIDecoded;
						break;
					}
					case M40A3.id:
					case M40A3_ICE.id:
					{
						aimImage = m40a3UIDecoded;
						break;
					}
					case R700.id:
					{
						aimImage = r700UIDecoded;
						break;
					}
					case CROSSBOW.id:
					case CROSSBOW_EXPLOSIVE.id:
					{
						aimImage = crossbowUIDecoded;
						break;
					}
					case MSR.id:
					{
						aimImage = msrUIDecoded;
						break;
					}
					default:
					{
						aimImage = barrettUIDecoded;
					}
				}

				removeShootAndAimButtons();

				var backgroundAimImageView = new android.widget.ImageView(currentActivity);
				backgroundAimImageView.setImageBitmap(aimImage);
				backgroundAimImageView.setScaleType(android.widget.ImageView.ScaleType.CENTER_CROP);
				backgroundAimImageView.setLayoutParams(new android.widget.LinearLayout.LayoutParams(android.view.ViewGroup.LayoutParams.MATCH_PARENT, android.view.ViewGroup.LayoutParams.MATCH_PARENT));

				popupAiming = new android.widget.PopupWindow();
				popupAiming.setContentView(backgroundAimImageView);
				popupAiming.setOutsideTouchable(false);
				popupAiming.setFocusable(false);
				popupAiming.setTouchable(false);
				popupAiming.setAnimationStyle(android.R.style.Animation_Translucent); // Animation_Activity, Animation_Dialog, Animation_Translucent, 
				popupAiming.setWidth(displayWidth);
				popupAiming.setHeight(displayHeight);
				popupAiming.showAtLocation(currentActivity.getWindow().getDecorView(), android.view.Gravity.CENTER | android.view.Gravity.CENTER, 0, 0);

				if(gun.hasManualZoom)
					displayManualZoom(gun);

				displayShootAndAimButtons(true);
				if(shouldReload())
					setAmmoTextFromGun(gun);
				else
					setAmmoText(" ");
				try {
					popupSightImage.dismiss();
				} catch(e) {}

				if(gun.type == BUTTON_TYPE_ON_TOUCH)
				{
					// load touch events
					if(shouldReload())
					{
						// survival or creative with reload option enabled
						currentActivity.runOnUiThread(new java.lang.Runnable(
						{
							run: function()
							{
								shotText.setOnTouchListener(new android.view.View.OnTouchListener()
								{
									onTouch: function(v, event)
									{
										if(minecraftStyleForButtons)
											MinecraftButtonLibrary.onTouch(v, event, false); // make touch effect
										onTouchWeaponShoot(event, gun, true);
										return false;
									}
								});
							}
						}));
					} else
					{
						// creative with reload option disabled
						currentActivity.runOnUiThread(new java.lang.Runnable(
						{
							run: function()
							{
								shotText.setOnTouchListener(new android.view.View.OnTouchListener()
								{
									onTouch: function(v, event)
									{
										if(minecraftStyleForButtons)
											MinecraftButtonLibrary.onTouch(v, event, false); // make touch effect
										onTouchWeaponShoot(event, gun, false);
										return false;
									}
								});
							}
						}));
					}
				}
			} catch(err)
			{
				clientMessage("Error: " + err);
			}
		}
	}));
}

function displayManualZoom(gun)
{
	currentActivity.runOnUiThread(new java.lang.Runnable(
	{
		run: function()
		{
			try
			{
				var zoomChooser = new android.widget.SeekBar(currentActivity);
				zoomChooser.setMax(68);
				zoomChooser.setProgress(72 - zoomWithFov);
				zoomChooser.setOnSeekBarChangeListener(new android.widget.SeekBar.OnSeekBarChangeListener()
				{
					onProgressChanged: function()
					{
						zoomWithFov = 72 - zoomChooser.getProgress();
						gun.zoomLevel = zoomChooser.getProgress();
						if(zoomWithFov == 72)
							ModPE.resetFov();
						else
							ModPE.setFov(zoomWithFov);
					}
				});

				popupZoom = new android.widget.PopupWindow();
				popupZoom.setContentView(zoomChooser);
				popupZoom.setWidth(Math.floor(displayWidth * 0.4));
				popupZoom.setHeight(android.widget.RelativeLayout.LayoutParams.WRAP_CONTENT);
				popupZoom.setBackgroundDrawable(new android.graphics.drawable.ColorDrawable(android.graphics.Color.TRANSPARENT));
				popupZoom.showAtLocation(currentActivity.getWindow().getDecorView(), android.view.Gravity.TOP | android.view.Gravity.CENTER, 0, convertDpToPixel(8));
			} catch(err)
			{
				clientMessage("Error: " + err);
			}
		}
	}));
}
//########## AIM functions - END ##########


//########## RELOAD GUN functions ##########
function reloadAmmo(gun)
{
	if(Level.getGameMode() == GameMode.SURVIVAL)
	{
		// gamemode survival
		var slot = Player.getSlotOfItem(getAmmoId(gun));
		if(Player.getCarriedItemData() != 0)
		{
			if(slot == -1)
				clientMessage("You don't have one " + Item.getName(getAmmoId(gun), 0, false) + " in your inventory.");
			else
			{
				try
				{
					isReloading = true;
					reloadingGun = gun;

					reloadSound.reset();
					reloadSound.setDataSource(sdcard + "/games/com.mojang/desnoguns-sounds/reload/" + gun.reloadSound);
					reloadSound.setVolume(generalVolume, generalVolume);
					reloadSound.prepare();
					reloadSound.setOnCompletionListener(new android.media.MediaPlayer.OnCompletionListener()
					{
						onCompletion: function(mp)
						{
							isReloading = false;

							// let's do again a check to see if the player hasn't changed his carried item
							if(Player.getCarriedItem() == reloadingGun.id)
							{
								var ammoSlot = Player.getSlotOfItem(getAmmoId(reloadingGun));
								if(ammoSlot == -1)
									clientMessage("You don't have one " + Item.getName(getAmmoId(gun), 0, false) + " ammo in your inventory.");
								else
								{
									Entity.setCarriedItem(Player.getEntity(), Player.getCarriedItem(), Player.getCarriedItemCount(), 0);
									setAmmoTextFromGun(gun);
									Player.removeItemsFromInventory(ammoSlot, 1);
								}
							}

							// reset sound
							reloadSound.release();
							reloadSound = null;
							reloadSound = new android.media.MediaPlayer();
						}
					});
					reloadSound.start();
					ModPE.showTipMessage("Reloading");
				} catch(e)
				{
					ModPE.showTipMessage("Sounds not installed.");
					ModPE.log(getLogText() + "error in reloadAmmo: " + e);
				}
			}
		}
	} else
	{
		// gamemode creative
		if(Player.getCarriedItemData() != 0)
		{
			if(instantReloadInCreative)
			{
				// instant reload enabled
				isReloading = false;

				// let's do a re-check to see if the player hasn't changed his carried item
				if(Player.getCarriedItem() == gun.id)
				{
					Entity.setCarriedItem(Player.getEntity(), Player.getCarriedItem(), Player.getCarriedItemCount(), 0);
					setAmmoTextFromGun(gun);
				}
			} else
			{
				// instant reload NOT enabled
				try
				{
					isReloading = true;
					reloadingGun = gun;

					reloadSound.reset();
					reloadSound.setDataSource(sdcard + "/games/com.mojang/desnoguns-sounds/reload/" + gun.reloadSound);
					reloadSound.setVolume(generalVolume, generalVolume);
					reloadSound.prepare();
					reloadSound.setOnCompletionListener(new android.media.MediaPlayer.OnCompletionListener()
					{
						onCompletion: function(mp)
						{
							isReloading = false;

							// let's do a re-check to see if the player hasn't changed his carried item
							if(Player.getCarriedItem() == reloadingGun.id)
							{
								Entity.setCarriedItem(Player.getEntity(), Player.getCarriedItem(), Player.getCarriedItemCount(), 0);
								setAmmoTextFromGun(reloadingGun);
							}

							// reset sound
							reloadSound.release();
							reloadSound = null;
							reloadSound = new android.media.MediaPlayer();
						}
					});
					reloadSound.start();
					ModPE.showTipMessage("Reloading");
				} catch(e)
				{
					ModPE.showTipMessage("Sounds not installed.");
					ModPE.log(getLogText() + "error in reloadAmmo: " + e);

					// since we are in creative we should reload the ammo, also if sounds aren't installed.
					isReloading = false;

					// let's do a re-check to see if the player hasn't changed his carried item
					if(Player.getCarriedItem() == reloadingGun.id)
					{
						Entity.setCarriedItem(Player.getEntity(), Player.getCarriedItem(), Player.getCarriedItemCount(), 0);
						setAmmoTextFromGun(reloadingGun);
					}
				}
			}
		}
	}
}

function stopReloading()
{
	if(isReloading)
	{
		try {
			reloadSound.stop();
		} catch(e) {
			ModPE.log(getLogText() + "error while stopping reloadSound: " + e);
		}
		isReloading = false;
		ModPE.showTipMessage("Ammo reload interrupted.");
	}
}

function setAmmoTextFromGun(gun)
{
	if(displayGunNameInAmmo)
		setAmmoText(gun.name + " " + (gun.ammo - Player.getCarriedItemData()) + "/" + gun.ammo);
	else
		setAmmoText((gun.ammo - Player.getCarriedItemData()) + "/" + gun.ammo);
}

function setAmmoText(text)
{
	currentActivity.runOnUiThread(new java.lang.Runnable(
	{
		run: function()
		{
			try
			{
				ammoText.setText(text);
			} catch(err)
			{
				clientMessage("Error: " + err);
			}
		}
	}));
}

function damageCarriedGun(gun)
{
	var maxDamage = gun.ammo;
	if(Player.getCarriedItemData() < maxDamage)
		Entity.setCarriedItem(Player.getEntity(), Player.getCarriedItem(), Player.getCarriedItemCount(), Player.getCarriedItemData() + 1);
	setAmmoTextFromGun(gun);
}

function getAmmoId(gun)
{
	if(gun.ammunitionID != null)
	{
		return gun.ammunitionID;
	}
	else
	{
		switch(gun.gunType)
		{
			case GUN_TYPE_ASSAULT_RIFLE:
			{
				return AMMO_ASSAULT_RIFLE_ID;
			}
			case GUN_TYPE_SUB_MACHINE:
			{
				return AMMO_SUB_MACHINE_ID;
			}
			case GUN_TYPE_LIGHT_MACHINE:
			{
				return AMMO_LIGHT_MACHINE_ID;
			}
			case GUN_TYPE_SNIPER_RIFLE:
			{
				return AMMO_SNIPER_RIFLE_ID;
			}
			case GUN_TYPE_SHOTGUN:
			{
				return AMMO_SHOTGUN_ID;
			}
			case GUN_TYPE_MACHINE_PISTOL:
			{
				return AMMO_MACHINE_PISTOL_ID;
			}
			case GUN_TYPE_HANDGUN:
			{
				return AMMO_HANDGUN_ID;
			}
			case GUN_TYPE_LAUNCHER:
			{
				return AMMO_LAUNCHER_ID;
			}
			case GUN_TYPE_MINIGUN:
			{
				return AMMO_MINIGUN_ID;
			}
			default:
			{
				clientMessage("Error in getAmmoId() with gunType " + gun.gunType);
			}
		}
	}
}

function shouldReload()
{
	// reload in survival, or in creative with reload option enabled
	return reloadInCreative || Level.getGameMode() == GameMode.SURVIVAL;
}
//########## RELOAD GUN functions - END ##########


//########## MED KIT functions ##########
function displayHealButton()
{
	currentActivity.runOnUiThread(new java.lang.Runnable()
	{
		run: function()
		{
			try
			{
				var healthText;
				if(minecraftStyleForButtons)
				{
					healthText = MinecraftButton(buttonsSize);
					healthText.setText("Heal");
				} else
				{
					healthText = defaultColoredMinecraftButton("heal", "#FF00DE00");
				}
				healthText.setOnClickListener(new android.view.View.OnClickListener()
				{
					onClick: function(v)
					{
						if(Player.getCarriedItem() == MEDICAL_KIT_ID) // one more check before removing items
						{
							var currentHealth = Entity.getHealth(Player.getEntity());
							if(currentHealth >= 20)
							{
								ModPE.showTipMessage("Your health is full.");
								return;
							}
							var healthToBeRestored = 20 - currentHealth;
							var healthMedicalKitCanRestore = MEDICAL_KIT_MAX_RESTORABLE_HEALTH - Player.getCarriedItemData() + 1;
							if(healthToBeRestored > healthMedicalKitCanRestore)
							{
								Player.setHealth(currentHealth + healthMedicalKitCanRestore);
								for(var i = 0; i < healthMedicalKitCanRestore; i++)
									Player.damageCarriedItem();
								ModPE.showTipMessage("Medical Kit broke before restoring all health.");
							} else
							{
								Player.setHealth(20);
								for(var i = 0; i < healthToBeRestored; i++)
									Player.damageCarriedItem();
								ModPE.showTipMessage("Restored " + (healthToBeRestored / 2) + " hearts.");
							}
						} else
						{
							popupHealth.dismiss();
						}
					}
				});
				healthText.setSoundEffectsEnabled(true);

				popupHealth = new android.widget.PopupWindow(healthText, android.view.ViewGroup.LayoutParams.WRAP_CONTENT, android.view.ViewGroup.LayoutParams.WRAP_CONTENT);
				popupHealth.setBackgroundDrawable(new android.graphics.drawable.ColorDrawable(android.graphics.Color.TRANSPARENT));
				popupHealth.setOutsideTouchable(false);
				popupHealth.setSplitTouchEnabled(true);
				popupHealth.showAtLocation(currentActivity.getWindow().getDecorView(), android.view.Gravity.LEFT | android.view.Gravity.CENTER, 0, pixelsOffsetButtons);
			} catch(err)
			{
				clientMessage("Error: " + err);
			}
		}
	});
}

function removeHealButton()
{
	currentActivity.runOnUiThread(new java.lang.Runnable(
	{
		run: function()
		{
			try {
				popupHealth.dismiss();
			} catch(e) {}
		}
	}));
}
//########## MED KIT functions - END ##########


//########## INFO ITEM functions ##########
function displayInfoItemUI()
{
	currentActivity.runOnUiThread(new java.lang.Runnable()
	{
		run: function()
		{
			try
			{
				var settingsImage = new android.widget.ImageView(currentActivity);
				settingsImage.setImageBitmap(settingsPngScaled);
				settingsImage.setOnClickListener(new android.view.View.OnClickListener({
					onClick: function()
					{
						infoDesnoGunsMod();
					}
				}));

				popupSettingsImage = new android.widget.PopupWindow(settingsImage, android.view.ViewGroup.LayoutParams.WRAP_CONTENT, android.view.ViewGroup.LayoutParams.WRAP_CONTENT);
				popupSettingsImage.setBackgroundDrawable(new android.graphics.drawable.ColorDrawable(android.graphics.Color.TRANSPARENT));
				popupSettingsImage.setOutsideTouchable(false);
				popupSettingsImage.setSplitTouchEnabled(true);
				popupSettingsImage.showAtLocation(currentActivity.getWindow().getDecorView(), android.view.Gravity.LEFT | android.view.Gravity.CENTER, convertDpToPixel(4), 0);



				var tipText = basicMinecraftTextView(getRandomTip(), 14);
				tipText.setOnClickListener(new android.view.View.OnClickListener()
				{
					onClick: function(v)
					{
						v.setText(new android.text.Html.fromHtml(getRandomTip()));
						return false;
					}
				});
				tipText.setMovementMethod(android.text.method.LinkMovementMethod.getInstance());
				tipText.setLinkTextColor(android.graphics.Color.parseColor("#FFFBFF97"));
				tipText.setGravity(android.view.Gravity.LEFT);
				tipText.setTextColor(android.graphics.Color.parseColor("#FFFFFFFF"));
				tipText.setPadding(convertDpToPixel(4), convertDpToPixel(4), convertDpToPixel(4), convertDpToPixel(4));
				tipText.setLayoutParams(new android.view.ViewGroup.LayoutParams(android.view.ViewGroup.LayoutParams.WRAP_CONTENT, android.view.ViewGroup.LayoutParams.WRAP_CONTENT));

				popupTip = new android.widget.PopupWindow(tipText, android.view.ViewGroup.LayoutParams.WRAP_CONTENT, android.view.ViewGroup.LayoutParams.WRAP_CONTENT);
				popupTip.setBackgroundDrawable(new android.graphics.drawable.ColorDrawable(android.graphics.Color.TRANSPARENT));
				popupTip.showAtLocation(currentActivity.getWindow().getDecorView(), android.view.Gravity.RIGHT | android.view.Gravity.CENTER, 0, -64 * deviceDensity);
			} catch(err)
			{
				clientMessage("Error: " + err);
			}
		}
	});
}

function getRandomTip()
{
	var cal = java.util.Calendar.getInstance();
	var day = cal.get(java.util.Calendar.DAY_OF_MONTH);
	var month = cal.get(java.util.Calendar.MONTH);
	if(day == 3 && month == java.util.Calendar.JULY)
	{
		return "Happy birthday, Desno365!";
	}
	if(day == 31 && month == java.util.Calendar.OCTOBER)
	{
		return "Keep calm and scary on.";
	}
	if(day == 25 && month == java.util.Calendar.DECEMBER)
	{
		return "Merry Christmas!";
	}
	if(day == 1 && month == java.util.Calendar.JANUARY)
	{
		return "Happy new year!";
	}

	var random = Math.floor((Math.random() * 21) + 1);
	switch(random)
	{
		case 1:
		{
			return "Guns have better accuracy while aiming.";
		}
		case 2:
		{
			return "Follow @Desno365 on Twitter";
		}
		case 3:
		{
			return "Sniper Rifles have a really bad accuracy if you don't aim.";
		}
		case 4:
		{
			return "Textures and sounds are made by @jamioflan, a big thanks to him!";
		}
		case 5:
		{
			return "Place a Block of Coal on top of a Block of Iron, then touch it.";
		}
		case 6:
		{
			return "The damage of a bullet to a mob depends on his speed.";
		}
		case 7:
		{
			return "This mod causes addiction, use with caution.";
		}
		case 8:
		{
			return "In Minecraft the damage of an arrow depends on his speed.";
		}
		case 9:
		{
			return "This mod is compatible with the Portal 2 Mod by Desno365!";
		}
		case 10:
		{
			return ".shootDatCreeper()";
		}
		case 11:
		{
			return "Press the settings icon on the left, there are awesome things inside.";
		}
		case 12:
		{
			return "Do a 360 noscope.";
		}
		case 13:
		{
			return "author.name = \"Dennis Motta\"; author.nickname = \"Desno365\";";
		}
		case 14:
		{
			return "@AntiModPe made the grenade renders and helped me with some other things. Thanks Anti!";
		}
		case 15:
		{
			return "A good sniper calculates the gravity before shooting.";
		}
		case 16:
		{
			if(isPro())
				return "Pro Key installed. Thanks for your support! :)";
			else
				return "Consider getting the Pro Key, you will support the development and unlock features.";
		}
		case 17:
		{
			return "You're running the " + CURRENT_VERSION + " version of the DesnoGuns mod!";
		}
		case 18:
		{
			return "There is an option in Settings that enables reload in creative.";
		}
		case 19:
		{
			return "Did you find the Easter Egg? No? You'll find a tip on one of these splash texts.";
		}
		case 20:
		{
			return "/swag grenade";
		}
		case 21:
		{
			if(isPro())
				return "If you like the pro features consider leaving a good review on the Play Store: <a href=\"https://play.google.com/store/apps/details?id=com.desno365.desnogunsmodkey\">DesnoGuns Mod Pro Key</a>.";
			else
				return "Get notifications when a new version of one of my mod is released, download the <a href=\"https://play.google.com/store/apps/details?id=com.desno365.mods\">Desno365's Mods app</a> now!";
		}
	}
}

function removeInfoItemUI()
{
	currentActivity.runOnUiThread(new java.lang.Runnable(
	{
		run: function()
		{
			try {
				popupSettingsImage.dismiss();
			} catch(e) {}
			try {
				popupTip.dismiss();
			} catch(e) {}
		}
	}));
}
//########## INFO ITEM functions - END ##########


//########## INTERNET functions ##########
function updateLatestVersionMod()
{
	try
	{
		// download content
		var url = new java.net.URL("https://raw.githubusercontent.com/Desno365/MCPE-scripts/master/desnogunsMOD-version");
		var connection = url.openConnection();
 
		// get content
		inputStream = connection.getInputStream();
 
		// read result
		var loadedVersion = "";
		var bufferedVersionReader = new java.io.BufferedReader(new java.io.InputStreamReader(inputStream));
		var rowVersion = "";
		while((rowVersion = bufferedVersionReader.readLine()) != null)
		{
			loadedVersion += rowVersion;
		}
		latestVersion = loadedVersion.split(" ")[0];
 
		// close what needs to be closed
		bufferedVersionReader.close();
		inputStream.close();
	} catch(err)
	{
		clientMessage("DesnoGuns Mod: Can't check for updates, please check your Internet connection.");
		ModPE.log(getLogText() + "updateLatestVersionMod(): caught an error: " + err);
	}
}
//########## INTERNET functions - END ##########


//########## DIRECTION functions ##########
function vector3d(x, y, z)
{
	this.x = x;
	this.y = y;
	this.z = z;
}

function getDirection(yaw, pitch)
{
	var direction = new vector3d(0, 0, 0);
	direction.y = -Math.sin(java.lang.Math.toRadians(pitch));
	direction.x = -Math.sin(java.lang.Math.toRadians(yaw)) * Math.cos(java.lang.Math.toRadians(pitch));
	direction.z = Math.cos(java.lang.Math.toRadians(yaw)) * Math.cos(java.lang.Math.toRadians(pitch));
	return direction;
}
//########## DIRECTION functions - END ##########


//########## PLAYER functions ##########
Player.damageCarriedItem = function()
{
	var maxDamage;
	if(Player.getCarriedItem() == KNIFE_ID)
		maxDamage = KNIFE_MAX_DAMAGE;
	if(Player.getCarriedItem() == PARACHUTE_ID)
		maxDamage = PARACHUTE_MAX_DAMAGE;
	if(Player.getCarriedItem() == MEDICAL_KIT_ID)
		maxDamage = MEDICAL_KIT_MAX_RESTORABLE_HEALTH;
	if(Player.getCarriedItem() == RIOT_SHIELD_ID)
		maxDamage = RIOT_SHIELD_MAX_DAMAGE;

	if(Player.getCarriedItemData() < maxDamage)
		Entity.setCarriedItem(Player.getEntity(), Player.getCarriedItem(), Player.getCarriedItemCount(), Player.getCarriedItemData() + 1);
	else
	{
		Level.playSoundEnt(Player.getEntity(), "random.break", 100, 30);
		if(Player.getCarriedItemCount() == 1)
			Player.clearInventorySlot(Player.getSelectedSlotId());
		else
			Entity.setCarriedItem(Player.getEntity(), Player.getCarriedItem(), Player.getCarriedItemCount() - 1, 0);
	}
}

Player.decreaseByOneCarriedItem = function()
{
	if(Player.getCarriedItemCount() == 1)
		Player.clearInventorySlot(Player.getSelectedSlotId());
	else
		Entity.setCarriedItem(Player.getEntity(), Player.getCarriedItem(), Player.getCarriedItemCount() - 1, 0);
}

Player.getSlotOfItem = function(item, count)
{
	if(count == null || count <= 0)
		count = 1;
	// return -1 if the item wasn't found otherwise returns the inventory slot
	for(var i = 0; i <= 255; i++)
	{
		if(Player.getInventorySlot(i) == item)
		{
			if(Player.getInventorySlotCount(i) >= count)
			{
				return i;
			}
		}
	}
	return -1;
}

Player.removeItemsFromInventory = function(slot, count)
{
	if(Player.getInventorySlotCount(slot) > count)
	{
		var id = Player.getInventorySlot(slot);
		var countBefore = Player.getInventorySlotCount(slot);

		Player.clearInventorySlot(slot);
		Player.addItemInventory(id, countBefore - count);
	} else
	{
		Player.clearInventorySlot(slot);
	}
}
//########## PLAYER functions - END ##########


//########## FILE functions ##########
function deleteFile(path)
{
	var file = new java.io.File(path);

	if(file.isDirectory())
	{
		var directoryFiles = file.listFiles();
		for(var i in directoryFiles)
		{
			deleteFile(directoryFiles[i].getAbsolutePath());
		}
		file.delete();
	}

	if(file.isFile())
		file.delete();
}

function doesFileExist(path)
{
	var file = new java.io.File(path);
	return file.exists();
}

function isFileEmpty(path)
{
	var file = new java.io.File(path);
	if(file.length() > 0)
		return false;
	else
		return true;
}

function writeFileFromByteArray(byteArray, path)
{
	var file = new java.io.File(path);
	if(file.exists())
		file.delete();
	file.createNewFile();
	var stream = new java.io.FileOutputStream(file);
	stream.write(byteArray);
	stream.close();
	byteArray = null;
}
//########## FILE functions - END ##########


//########## IMAGE functions ##########
function createImages()
{
	var settingsPngDecoded = decodeImageFromBase64(settingsPng);
	settingsPngScaled = scaleImageToSize(settingsPngDecoded, settingsPngDecoded.getHeight() * deviceDensity * 0.3, settingsPngDecoded.getHeight() * deviceDensity * 0.3, true);
	settingsPng = null;

	var sightPngDecoded = decodeImageFromBase64(sightPng);
	sightPngScaled = scaleImageToDensity(sightPngDecoded);
	sightPng = null;

	var backgroundDarkDirtDecoded = decodeImageFromBase64(backgroundDarkDirtPng);
	backgroundDarkDirtScaled = scaleImageToDensity(backgroundDarkDirtDecoded);
	background = new android.graphics.drawable.BitmapDrawable(backgroundDarkDirtScaled);
	background.setTileModeXY(android.graphics.Shader.TileMode.REPEAT, android.graphics.Shader.TileMode.REPEAT);
	backgroundDarkDirtPng = null;

	var playStorePngDecoded = decodeImageFromBase64(playStorePng);
	playStorePngScaled = scaleImageToSize(playStorePngDecoded, playStorePngDecoded.getWidth() * (deviceDensity / 3), playStorePngDecoded.getHeight() * (deviceDensity / 3), true);
	playStorePng = null;

	barrettUIDecoded = decodeImageFromBase64(barrettUI);
	barrettUI = null;
	dragunovUIDecoded = decodeImageFromBase64(dragunovUI);
	dragunovUI = null;
	m21UIDecoded = decodeImageFromBase64(m21UI);
	m21UI = null;
	m40a3UIDecoded = decodeImageFromBase64(m40a3UI);
	m40a3UI = null;
	r700UIDecoded = decodeImageFromBase64(r700UI);
	r700UI = null;
	crossbowUIDecoded = decodeImageFromBase64(crossbowUI);
	crossbowUI = null;
	msrUIDecoded = decodeImageFromBase64(msrUI);
	msrUI = null;
}

function decodeImageFromBase64(base64String)
{
	if(base64String != null)
	{
		var byteArray = android.util.Base64.decode(base64String, 0);
		return android.graphics.BitmapFactory.decodeByteArray(byteArray, 0, byteArray.length);
	}else
	{
		throw getLogText() + "decodeImageFromBase64 has found a null string.";
	}
}

function scaleImageToDensity(image)
{
	//
	return scaleImageToSize(image, Math.round(image.getWidth() * deviceDensity), Math.round(image.getHeight() * deviceDensity));
}

function scaleImageToSize(image, width, height, filter)
{
	if(filter == null)
		filter = false;
	return android.graphics.Bitmap.createScaledBitmap(image, Math.round(width), Math.round(height), filter);
}
//########## IMAGE functions - END ##########


//########## MISC functions ##########
function createRandomString(randomObject)
{
	// randomObjectExample = { startingFrom:1, endingAt:4, startText:"ignite_flamethrower", endText:".ogg" }
	var random = Math.floor((Math.random() * (randomObject.endingAt - randomObject.startingFrom + 1)) + randomObject.startingFrom);
	return(randomObject.startText + random + randomObject.endText);
}

function entityClass(entity)
{
	this.entity = entity;
	this.previousX = 0;
	this.previousY = 0;
	this.previousZ = 0;
}

function checkProximity(entity1, entity2, distanceXZ, distanceY)
{
	if(distanceY == null)
		distanceY = distanceXZ;

	if(!(Math.abs(Entity.getX(entity1) - Entity.getX(entity2)) <= distanceXZ))
		return false;
	if(!(Math.abs(Entity.getY(entity1) - Entity.getY(entity2)) <= distanceY))
		return false;
	if(!(Math.abs(Entity.getZ(entity1) - Entity.getZ(entity2)) <= distanceXZ))
		return false;
	return true;
}

function stringToBoolean(string)
{
	switch(string.toLowerCase())
	{
		case "true":
		case "yes":
		case "1":
			return true;
		case "false":
		case "no":
		case "0":
		case null:
			return false;
		default:
			return Boolean(string);
	}
}

function getSavedBoolean(name, defaultValue, debug)
{
	var savedDataTest = ModPE.readData(name);
	debug = debug || false;

	// debug code
	if(DEBUG1 && debug)
	{
		var debugTest;

		if(typeof savedDataTest == "boolean")
		{
			clientMessage(name + " is bool");
			debugTest = savedDataTest;
		} else
		{
			if(typeof savedDataTest == "string")
			{
				clientMessage(name + " is string");
				debugTest = stringToBoolean(savedDataTest);
			} else
			{
				clientMessage(name + " is " + typeof savedDataTest);
			}
		}

		clientMessage(name + ": " + debugTest);

		if(typeof debugTest == "boolean")
		{
			if(debugTest)
				clientMessage(name + " true");
			else
				clientMessage(name + " false");
		} else
		{
			clientMessage(name + ", something really wrong here!");
		}
	}

	// return the saved boolean
	if(typeof savedDataTest == "boolean")
	{
		return savedDataTest;
	} else
	{
		if(typeof savedDataTest == "string")
		{
			if(savedDataTest != "" && savedDataTest != null && savedDataTest != undefined)
			{
				return stringToBoolean(savedDataTest);
			} else
			{
				// this setting has never been saved.
				if(typeof defaultValue == "boolean")
					return defaultValue;
				else
					return stringToBoolean(defaultValue)
			}
		} else
		{
			clientMessage("Error in getSavedBoolean() for " + name);
			return false;
		}
	}
}

function getLogText()
{
	//
	return(TAG + ": ");
}
//########## MISC functions - END ##########


//########## UTILS OF UIs functions ##########
function convertDpToPixel(dp)
{
	//
	return Math.round(dp * deviceDensity);
}

function basicMinecraftTextView(text, textSize) // TextView with just the Minecraft font
{
	var lineSpacing = convertDpToPixel(4);

	var textview = new android.widget.TextView(currentActivity);
	textview.setText(new android.text.Html.fromHtml(text));
	if(textSize != null)
		textview.setTextSize(textSize);
	textview.setTypeface(MinecraftButtonLibrary.ProcessedResources.font);
	textview.setPaintFlags(textview.getPaintFlags() | android.graphics.Paint.SUBPIXEL_TEXT_FLAG);
	textview.setLineSpacing(lineSpacing, 1);
	if(android.os.Build.VERSION.SDK_INT > 19) // KITKAT
		textview.setShadowLayer(1, Math.round((textview.getLineHeight() - lineSpacing) / 8), Math.round((textview.getLineHeight() - lineSpacing) / 8), android.graphics.Color.parseColor("#FF333333"));
	else
		textview.setShadowLayer(0.001, Math.round((textview.getLineHeight() - lineSpacing) / 8), Math.round((textview.getLineHeight() - lineSpacing) / 8), android.graphics.Color.parseColor("#FF333333"));

	return textview;
}

function defaultColoredMinecraftButton(text, colorString)
{
	var padding = convertDpToPixel(4);

	var bg = android.graphics.drawable.GradientDrawable();
	bg.setColor(android.graphics.Color.TRANSPARENT);
	bg.setShape(android.graphics.drawable.GradientDrawable.RECTANGLE);
	bg.setStroke(convertDpToPixel(1), android.graphics.Color.parseColor(colorString));

	var coloredButton = basicMinecraftTextView(text, buttonsSize);
	coloredButton.setGravity(android.view.Gravity.CENTER);
	coloredButton.setTextColor(android.graphics.Color.parseColor(colorString));
	coloredButton.setBackgroundDrawable(bg);
	coloredButton.setPadding(padding, padding, padding, padding);
	coloredButton.setLayoutParams(new android.view.ViewGroup.LayoutParams(android.view.ViewGroup.LayoutParams.WRAP_CONTENT, android.view.ViewGroup.LayoutParams.WRAP_CONTENT));

	return coloredButton;
}
//########## UTILS OF UIs functions - END ##########


//########################################################################################################################################################
// Utils of popup's UI functions
//########################################################################################################################################################

const MARGIN_HORIZONTAL_BIG = 16;
const MARGIN_HORIZONTAL_SMALL = 4;

function setMarginsLinearLayout(view, left, top, right, bottom)
{
	var originalParams = view.getLayoutParams();
	var newParams = new android.widget.LinearLayout.LayoutParams(originalParams);
	newParams.setMargins(convertDpToPixel(left), convertDpToPixel(top), convertDpToPixel(right), convertDpToPixel(bottom));
	view.setLayoutParams(newParams);
}

function dividerText()
{
	var dividerText = new android.widget.TextView(currentActivity);
	dividerText.setText(" ");
	return dividerText;
}

function progressBarForInformation(value, max, invert, text)
{
	if(value > max)
		value = max;
	if(invert)
		value = max - value;
	var progressBar = new android.widget.ProgressBar(currentActivity, null, android.R.attr.progressBarStyleHorizontal);
	progressBar.setIndeterminate(false);
	progressBar.setMax(max);
	progressBar.setProgress(Math.round(value));
	progressBar.setLayoutParams(new android.widget.LinearLayout.LayoutParams(0, android.view.ViewGroup.LayoutParams.WRAP_CONTENT, 3));

	var text1 = new android.widget.TextView(currentActivity);
	text1.setText(text);
	text1.setGravity(android.view.Gravity.LEFT);
	text1.setTextSize(12);
	text1.setPadding(Math.floor(8 * deviceDensity), 0, Math.floor(8 * deviceDensity), 0);
	text1.setLayoutParams(new android.widget.LinearLayout.LayoutParams(0, android.view.ViewGroup.LayoutParams.WRAP_CONTENT, 1));

	var layoutH = new android.widget.LinearLayout(currentActivity);
	layoutH.setOrientation(android.widget.LinearLayout.HORIZONTAL);

	layoutH.addView(progressBar);
	layoutH.addView(text1);
	return layoutH;
}

function defaultContentTextView(text) // TextView for contents (basicMinecraftTextView with little changes)
{
	var textview = basicMinecraftTextView(text, 12);
	textview.setTextColor(android.graphics.Color.parseColor(MinecraftButtonLibrary.defaultButtonTextColor));

	return textview;
}

function defaultSubTitle(subtitle) // TextView with Minecraft background
{
	var padding = convertDpToPixel(8);

	var bg = android.graphics.drawable.GradientDrawable();
	bg.setColor(android.graphics.Color.parseColor("#FF736A6F"));
	bg.setShape(android.graphics.drawable.GradientDrawable.RECTANGLE);
	bg.setStroke(convertDpToPixel(2), android.graphics.Color.parseColor("#FF93898B"));

	var title = basicMinecraftTextView(subtitle, 16);
	title.setTextColor(android.graphics.Color.WHITE);
	title.setBackgroundDrawable(bg);
	title.setPadding(padding, padding, padding, padding);

	return title;
}

function defaultLayout(title)
{
	var layout = new android.widget.LinearLayout(currentActivity);
	layout.setOrientation(android.widget.LinearLayout.VERTICAL);
	var padding = convertDpToPixel(8);
	layout.setPadding(padding, padding, padding, padding);
	layout.setBackgroundDrawable(background);

	var titleTextView = basicMinecraftTextView(title, 18);
	titleTextView.setTextColor(android.graphics.Color.WHITE);
	titleTextView.setGravity(android.view.Gravity.CENTER);
	layout.addView(titleTextView);
	setMarginsLinearLayout(titleTextView, 0, 4, 0, 4);

	var divider = new android.view.View(currentActivity);
	divider.setBackgroundDrawable(new android.graphics.drawable.ColorDrawable(android.graphics.Color.parseColor("#958681")));
	divider.setLayoutParams(new android.view.ViewGroup.LayoutParams(android.view.ViewGroup.LayoutParams.FILL_PARENT, convertDpToPixel(1)));
	layout.addView(divider);
	setMarginsLinearLayout(divider, 0, 8, 0, 8);

	return layout;
}

function defaultPopup(layout)
{
	var scroll = new android.widget.ScrollView(currentActivity);
	scroll.addView(layout);

	var popup = new android.app.Dialog(currentActivity);
	popup.requestWindowFeature(android.view.Window.FEATURE_NO_TITLE);
	popup.setContentView(scroll);
	return popup;
}


//########################################################################################################################################################
// Popup's UI functions
//########################################################################################################################################################

function infoDesnoGunsMod()
{
	currentActivity.runOnUiThread(new java.lang.Runnable()
	{
		run: function()
		{
			try
			{
				var layout;
				if(isPro())
					layout = defaultLayout("DesnoGuns Mod Pro");
				else
					layout = defaultLayout("DesnoGuns Mod");

				var text = defaultContentTextView("Welcome to the DesnoGuns Mod by Desno365!");
				layout.addView(text);
				setMarginsLinearLayout(text, 0, MARGIN_HORIZONTAL_SMALL, 0, MARGIN_HORIZONTAL_BIG);

				var informationButton = MinecraftButton();
				informationButton.setText("Information");
				informationButton.setOnClickListener(new android.view.View.OnClickListener()
				{
					onClick: function()
					{
						informationUI();
						popup.dismiss();
					}
				});
				layout.addView(informationButton);
				setMarginsLinearLayout(informationButton, 0, MARGIN_HORIZONTAL_SMALL, 0, MARGIN_HORIZONTAL_SMALL);

				var settingsButton = MinecraftButton();
				settingsButton.setText("Settings");
				settingsButton.setOnClickListener(new android.view.View.OnClickListener()
				{
					onClick: function()
					{
						settingsUI();
						popup.dismiss();
					}
				});
				layout.addView(settingsButton);
				setMarginsLinearLayout(settingsButton, 0, MARGIN_HORIZONTAL_SMALL, 0, MARGIN_HORIZONTAL_BIG);

				var updatesButton = MinecraftButton();
				updatesButton.setText("Check for updates");
				updatesButton.setOnClickListener(new android.view.View.OnClickListener()
				{
					onClick: function()
					{
						if(latestVersion == CURRENT_VERSION || latestVersion == undefined || latestVersion == " ")
						{
							latestVersionUI();
							popup.dismiss();
						} else
						{
							updateAvailableUI();
						}
					}
				});
				layout.addView(updatesButton);
				setMarginsLinearLayout(updatesButton, 0, MARGIN_HORIZONTAL_SMALL, 0, MARGIN_HORIZONTAL_SMALL);

				var modThreadButton = MinecraftButton();
				modThreadButton.setText("Visit the mod thread");
				modThreadButton.setOnClickListener(new android.view.View.OnClickListener()
				{
					onClick: function()
					{
						visitThread();
						popup.dismiss();
					}
				});
				layout.addView(modThreadButton);
				setMarginsLinearLayout(modThreadButton, 0, MARGIN_HORIZONTAL_SMALL, 0, MARGIN_HORIZONTAL_SMALL);

				var supportButton = MinecraftButton();
				supportButton.setText("Support the developer");
				supportButton.setOnClickListener(new android.view.View.OnClickListener()
				{
					onClick: function()
					{
						supportUI();
						popup.dismiss();
					}
				});
				layout.addView(supportButton);
				setMarginsLinearLayout(supportButton, 0, MARGIN_HORIZONTAL_SMALL, 0, MARGIN_HORIZONTAL_BIG);

				var exitButton = MinecraftButton();
				exitButton.setText("Close");
				exitButton.setOnClickListener(new android.view.View.OnClickListener()
				{
					onClick: function()
					{
						popup.dismiss();
					}
				});
				layout.addView(exitButton);
				setMarginsLinearLayout(exitButton, 0, MARGIN_HORIZONTAL_SMALL, 0, MARGIN_HORIZONTAL_SMALL);


				var popup = defaultPopup(layout);
				popup.show();

			} catch(err)
			{
				clientMessage("Error: " + err);
			}
		}
	});
}

function informationUI()
{
	currentActivity.runOnUiThread(new java.lang.Runnable()
	{
		run: function()
		{
			try
			{
				var layout;
				layout = defaultLayout("Information");

				var button = MinecraftButton();
				button.setText("View guns specifications");
				button.setOnClickListener(new android.view.View.OnClickListener()
				{
					onClick: function()
					{
						informationGunsSpecifications();
						popup.dismiss();
					}
				});
				layout.addView(button);
				setMarginsLinearLayout(button, 0, MARGIN_HORIZONTAL_SMALL, 0, MARGIN_HORIZONTAL_SMALL);

				var button = MinecraftButton();
				button.setText("Other items");
				button.setOnClickListener(new android.view.View.OnClickListener()
				{
					onClick: function()
					{
						informationOtherItems();
						popup.dismiss();
					}
				});
				layout.addView(button);
				setMarginsLinearLayout(button, 0, MARGIN_HORIZONTAL_SMALL, 0, MARGIN_HORIZONTAL_BIG);

				var backButton = MinecraftButton();
				backButton.setText("Back");
				backButton.setOnClickListener(new android.view.View.OnClickListener()
				{
					onClick: function()
					{
						infoDesnoGunsMod();
						popup.dismiss();
					}
				});
				layout.addView(backButton);
				setMarginsLinearLayout(backButton, 0, MARGIN_HORIZONTAL_SMALL, 0, MARGIN_HORIZONTAL_SMALL);

				var exitButton = MinecraftButton();
				exitButton.setText("Close");
				exitButton.setOnClickListener(new android.view.View.OnClickListener()
				{
					onClick: function()
					{
						popup.dismiss();
					}
				});
				layout.addView(exitButton);
				setMarginsLinearLayout(exitButton, 0, MARGIN_HORIZONTAL_SMALL, 0, MARGIN_HORIZONTAL_SMALL);


				var popup = defaultPopup(layout);
				popup.show();

			} catch(err)
			{
				clientMessage("Error: " + err);
			}
		}
	});
}

function informationGunsSpecifications()
{
	currentActivity.runOnUiThread(new java.lang.Runnable()
	{
		run: function()
		{
			try
			{
				var layout;
				layout = defaultLayout("Guns specifications");

				var button = MinecraftButton();
				button.setText(getGunTypeName(GUN_TYPE_ASSAULT_RIFLE));
				button.setOnClickListener(new android.view.View.OnClickListener()
				{
					onClick: function()
					{
						informationGunsSpecificationsForGunType(GUN_TYPE_ASSAULT_RIFLE);
						popup.dismiss();
					}
				});
				layout.addView(button);
				setMarginsLinearLayout(button, 0, MARGIN_HORIZONTAL_SMALL, 0, MARGIN_HORIZONTAL_SMALL);

				var button = MinecraftButton();
				button.setText(getGunTypeName(GUN_TYPE_SUB_MACHINE));
				button.setOnClickListener(new android.view.View.OnClickListener()
				{
					onClick: function()
					{
						informationGunsSpecificationsForGunType(GUN_TYPE_SUB_MACHINE);
						popup.dismiss();
					}
				});
				layout.addView(button);
				setMarginsLinearLayout(button, 0, MARGIN_HORIZONTAL_SMALL, 0, MARGIN_HORIZONTAL_SMALL);

				var button = MinecraftButton();
				button.setText(getGunTypeName(GUN_TYPE_LIGHT_MACHINE));
				button.setOnClickListener(new android.view.View.OnClickListener()
				{
					onClick: function()
					{
						informationGunsSpecificationsForGunType(GUN_TYPE_LIGHT_MACHINE);
						popup.dismiss();
					}
				});
				layout.addView(button);
				setMarginsLinearLayout(button, 0, MARGIN_HORIZONTAL_SMALL, 0, MARGIN_HORIZONTAL_SMALL);

				var button = MinecraftButton();
				button.setText(getGunTypeName(GUN_TYPE_SNIPER_RIFLE));
				button.setOnClickListener(new android.view.View.OnClickListener()
				{
					onClick: function()
					{
						informationGunsSpecificationsForGunType(GUN_TYPE_SNIPER_RIFLE);
						popup.dismiss();
					}
				});
				layout.addView(button);
				setMarginsLinearLayout(button, 0, MARGIN_HORIZONTAL_SMALL, 0, MARGIN_HORIZONTAL_SMALL);

				var button = MinecraftButton();
				button.setText(getGunTypeName(GUN_TYPE_SHOTGUN));
				button.setOnClickListener(new android.view.View.OnClickListener()
				{
					onClick: function()
					{
						informationGunsSpecificationsForGunType(GUN_TYPE_SHOTGUN);
						popup.dismiss();
					}
				});
				layout.addView(button);
				setMarginsLinearLayout(button, 0, MARGIN_HORIZONTAL_SMALL, 0, MARGIN_HORIZONTAL_SMALL);

				var button = MinecraftButton();
				button.setText(getGunTypeName(GUN_TYPE_MACHINE_PISTOL));
				button.setOnClickListener(new android.view.View.OnClickListener()
				{
					onClick: function()
					{
						informationGunsSpecificationsForGunType(GUN_TYPE_MACHINE_PISTOL);
						popup.dismiss();
					}
				});
				layout.addView(button);
				setMarginsLinearLayout(button, 0, MARGIN_HORIZONTAL_SMALL, 0, MARGIN_HORIZONTAL_SMALL);

				var button = MinecraftButton();
				button.setText(getGunTypeName(GUN_TYPE_HANDGUN));
				button.setOnClickListener(new android.view.View.OnClickListener()
				{
					onClick: function()
					{
						informationGunsSpecificationsForGunType(GUN_TYPE_HANDGUN);
						popup.dismiss();
					}
				});
				layout.addView(button);
				setMarginsLinearLayout(button, 0, MARGIN_HORIZONTAL_SMALL, 0, MARGIN_HORIZONTAL_SMALL);

				var button = MinecraftButton();
				button.setText(getGunTypeName(GUN_TYPE_LAUNCHER));
				button.setOnClickListener(new android.view.View.OnClickListener()
				{
					onClick: function()
					{
						informationGunsSpecificationsForGunType(GUN_TYPE_LAUNCHER);
						popup.dismiss();
					}
				});
				layout.addView(button);
				setMarginsLinearLayout(button, 0, MARGIN_HORIZONTAL_SMALL, 0, MARGIN_HORIZONTAL_SMALL);

				var button = MinecraftButton();
				button.setText(getGunTypeName(GUN_TYPE_MINIGUN));
				button.setOnClickListener(new android.view.View.OnClickListener()
				{
					onClick: function()
					{
						informationGunsSpecificationsForGunType(GUN_TYPE_MINIGUN);
						popup.dismiss();
					}
				});
				layout.addView(button);
				setMarginsLinearLayout(button, 0, MARGIN_HORIZONTAL_SMALL, 0, MARGIN_HORIZONTAL_BIG);

				var backButton = MinecraftButton();
				backButton.setText("Back");
				backButton.setOnClickListener(new android.view.View.OnClickListener()
				{
					onClick: function()
					{
						informationUI();
						popup.dismiss();
					}
				});
				layout.addView(backButton);
				setMarginsLinearLayout(backButton, 0, MARGIN_HORIZONTAL_SMALL, 0, MARGIN_HORIZONTAL_SMALL);

				var exitButton = MinecraftButton();
				exitButton.setText("Close");
				exitButton.setOnClickListener(new android.view.View.OnClickListener()
				{
					onClick: function()
					{
						popup.dismiss();
					}
				});
				layout.addView(exitButton);
				setMarginsLinearLayout(exitButton, 0, MARGIN_HORIZONTAL_SMALL, 0, MARGIN_HORIZONTAL_SMALL);


				var popup = defaultPopup(layout);
				popup.show();

			} catch(err)
			{
				clientMessage("Error: " + err);
			}
		}
	});
}

function informationGunsSpecificationsForGunType(gunType)
{
	currentActivity.runOnUiThread(new java.lang.Runnable()
	{
		run: function()
		{
			try
			{
				var layout;
				layout = defaultLayout(getGunTypeName(gunType) + " specifications");

				for(var i in guns)
				{
					if(guns[i].gunType == gunType)
					{
						var text1 = new android.widget.TextView(currentActivity);
						text1.setText(new android.text.Html.fromHtml("<b>" + guns[i].name + "</b> (ID: " + guns[i].id + ")"));
						layout.addView(text1);

						var text = new android.widget.TextView(currentActivity);
						text.setText(getGunTypeName(guns[i].gunType));
						text.setGravity(android.view.Gravity.RIGHT);
						text.setTextSize(12);
						layout.addView(text);


						if(guns[i].ammo != 1)
						{
							var text2 = new android.widget.TextView(currentActivity);
							text2.setText("Fire rate");
							layout.addView(text2);
							if(guns[i].fireRate == 1 && guns[i].type == BUTTON_TYPE_ON_CLICK)
							{
								var text2_1 = new android.widget.TextView(currentActivity);
								text2_1.setText("Shoot one bullet every time the user clicks the \"fire\" button");
								text2_1.setTextSize(12);
								layout.addView(text2_1);
							} else
							{
								layout.addView(progressBarForInformation(guns[i].fireRate, 20, true, (guns[i].fireRate / 20) + " second(s)"));
							}
						}


						var text7 = new android.widget.TextView(currentActivity);
						text7.setText("Recoil");
						layout.addView(text7);

						layout.addView(progressBarForInformation(guns[i].recoil, 30, true, (61 - (guns[i].recoil * 2)) + "/60"));


						var text3 = new android.widget.TextView(currentActivity);
						text3.setText("Accuracy");
						layout.addView(text3);

						layout.addView(progressBarForInformation(guns[i].accuracy, SPAS.accuracy, true, (51 - guns[i].accuracy) + "/50"));


						var text4 = new android.widget.TextView(currentActivity);
						text4.setText("Zoom level (when aiming)");
						layout.addView(text4);

						layout.addView(progressBarForInformation(guns[i].zoomLevel, ZOOM_SNIPER, false, guns[i].zoomLevel + " FOV"));


						var text7 = new android.widget.TextView(currentActivity);
						text7.setText("Bullet speed");
						layout.addView(text7);

						layout.addView(progressBarForInformation(guns[i].bulletSpeed * 10, 100, false, guns[i].bulletSpeed * 10 + "/100"));


						var text5 = new android.widget.TextView(currentActivity);
						text5.setText("Ammo");
						layout.addView(text5);

						layout.addView(progressBarForInformation(guns[i].ammo, 125, false, guns[i].ammo.toString()));


						if(guns[i].hasExplosiveBulletsOnTouch || guns[i].hasExplosiveBulletsOnTime)
						{
							var text6 = new android.widget.TextView(currentActivity);
							text6.setText("Explosion radius");
							layout.addView(text6);

							layout.addView(progressBarForInformation(guns[i].bulletsExplosionRadius, 5, false, guns[i].bulletsExplosionRadius + "/10"));;
						}

						layout.addView(dividerText());
					}
				}

				var backButton = MinecraftButton();
				backButton.setText("Back");
				backButton.setOnClickListener(new android.view.View.OnClickListener()
				{
					onClick: function()
					{
						informationGunsSpecifications();
						popup.dismiss();
					}
				});
				layout.addView(backButton);
				setMarginsLinearLayout(backButton, 0, MARGIN_HORIZONTAL_SMALL, 0, MARGIN_HORIZONTAL_SMALL);

				var exitButton = MinecraftButton();
				exitButton.setText("Close");
				exitButton.setOnClickListener(new android.view.View.OnClickListener()
				{
					onClick: function()
					{
						popup.dismiss();
					}
				});
				layout.addView(exitButton);
				setMarginsLinearLayout(exitButton, 0, MARGIN_HORIZONTAL_SMALL, 0, MARGIN_HORIZONTAL_SMALL);


				var popup = defaultPopup(layout);
				popup.show();

			} catch(err)
			{
				clientMessage("Error: " + err);
			}
		}
	});
}

function informationOtherItems()
{
	currentActivity.runOnUiThread(new java.lang.Runnable()
	{
		run: function()
		{
			try
			{
				var layout;
				layout = defaultLayout("Other items");

				var textview = defaultContentTextView("<i>Knife</i>: ID: " + KNIFE_ID);
				layout.addView(textview);

				layout.addView(dividerText());

				var textview = defaultContentTextView("<i>Parachute</i>: ID: " + PARACHUTE_ID);
				layout.addView(textview);

				layout.addView(dividerText());

				var textview = defaultContentTextView("<i>Medical Kit</i>: ID: " + MEDICAL_KIT_ID);
				layout.addView(textview);

				layout.addView(dividerText());

				var textview = defaultContentTextView("<i>Riot Shield</i>: ID: " + RIOT_SHIELD_ID);
				layout.addView(textview);

				layout.addView(dividerText());

				var textview = defaultContentTextView("<i>Grenade</i>: ID: " + GRENADE.id);
				layout.addView(textview);

				layout.addView(dividerText());

				var textview = defaultContentTextView("<i>Fragment Grenade</i>: ID: " + FRAGMENT.id);
				layout.addView(textview);

				layout.addView(dividerText());

				var textview = defaultContentTextView("<i>Molotov</i>: ID: " + MOLOTOV.id);
				layout.addView(textview);

				layout.addView(dividerText());

				var textview = defaultContentTextView("<i>Smoke Grenade</i>: ID: " + SMOKE.id);
				layout.addView(textview);

				layout.addView(dividerText());

				var textview = defaultContentTextView("<i>Assault Rifle Ammo</i>: ID: " + AMMO_ASSAULT_RIFLE_ID);
				layout.addView(textview);

				layout.addView(dividerText());

				var textview = defaultContentTextView("<i>Sub Machine Ammo</i>: ID: " + AMMO_SUB_MACHINE_ID);
				layout.addView(textview);

				layout.addView(dividerText());

				var textview = defaultContentTextView("<i>Light Machine Ammo</i>: ID: " + AMMO_LIGHT_MACHINE_ID);
				layout.addView(textview);

				layout.addView(dividerText());

				var textview = defaultContentTextView("<i>Sniper Rifle Ammo</i>: ID: " + AMMO_SNIPER_RIFLE_ID);
				layout.addView(textview);

				layout.addView(dividerText());

				var textview = defaultContentTextView("<i>Shotgun Ammo</i>: ID: " + AMMO_SHOTGUN_ID);
				layout.addView(textview);

				layout.addView(dividerText());

				var textview = defaultContentTextView("<i>Machine Pistol Ammo</i>: ID: " + AMMO_SHOTGUN_ID);
				layout.addView(textview);

				layout.addView(dividerText());

				var textview = defaultContentTextView("<i>Handgun Ammo</i>: ID: " + AMMO_HANDGUN_ID);
				layout.addView(textview);

				layout.addView(dividerText());

				var textview = defaultContentTextView("<i>Launcher Ammo</i>: ID: " + AMMO_LAUNCHER_ID);
				layout.addView(textview);

				layout.addView(dividerText());

				var textview = defaultContentTextView("<i>Minigun Ammo</i>: ID: " + AMMO_MINIGUN_ID);
				layout.addView(textview);

				layout.addView(dividerText());

				var textview = defaultContentTextView("<i>Juggernaut Helmet</i>: ID: " + JUGGERNAUT_HELMET_ID);
				layout.addView(textview);

				layout.addView(dividerText());

				var textview = defaultContentTextView("<i>Juggernaut Body</i>: ID: " + JUGGERNAUT_BODY_ID);
				layout.addView(textview);

				layout.addView(dividerText());

				var textview = defaultContentTextView("<i>Juggernaut Pants</i>: ID: " + JUGGERNAUT_PANTS_ID);
				layout.addView(textview);

				layout.addView(dividerText());

				var textview = defaultContentTextView("<i>Juggernaut Boots</i>: ID: " + JUGGERNAUT_BOOTS_ID);
				layout.addView(textview);

				layout.addView(dividerText());


				var backButton = MinecraftButton();
				backButton.setText("Back");
				backButton.setOnClickListener(new android.view.View.OnClickListener()
				{
					onClick: function()
					{
						informationUI();
						popup.dismiss();
					}
				});
				layout.addView(backButton);
				setMarginsLinearLayout(backButton, 0, MARGIN_HORIZONTAL_SMALL, 0, MARGIN_HORIZONTAL_SMALL);

				var exitButton = MinecraftButton();
				exitButton.setText("Close");
				exitButton.setOnClickListener(new android.view.View.OnClickListener()
				{
					onClick: function()
					{
						popup.dismiss();
					}
				});
				layout.addView(exitButton);
				setMarginsLinearLayout(exitButton, 0, MARGIN_HORIZONTAL_SMALL, 0, MARGIN_HORIZONTAL_SMALL);


				var popup = defaultPopup(layout);
				popup.show();

			} catch(err)
			{
				clientMessage("Error: " + err);
			}
		}
	});
}

function settingsUI()
{
	currentActivity.runOnUiThread(new java.lang.Runnable()
	{
		run: function()
		{
			try
			{
				var layout;
				layout = defaultLayout("Settings");

				var padding = convertDpToPixel(8);


				var title = defaultSubTitle("Buttons");
				layout.addView(title);

				layout.addView(dividerText());

				var sizeText = new android.widget.TextView(currentActivity);
				sizeText.setText("Select the preferred size of the \"fire\" and \"aim\" buttons (default is " + BUTTONS_SIZE_DEFAULT + ")");
				sizeText.setTextColor(android.graphics.Color.parseColor("#FFFFFFFF"));
				sizeText.setPadding(padding, 0, padding, 0);
				layout.addView(sizeText);

				var sizeChooser = new android.widget.SeekBar(currentActivity);
				sizeChooser.setMax(30);
				sizeChooser.setProgress(buttonsSize - 10);
				sizeChooser.setOnSeekBarChangeListener(new android.widget.SeekBar.OnSeekBarChangeListener()
				{
					onProgressChanged: function()
					{
						buttonsSize = sizeChooser.getProgress() + 10;
						sizeText1.setText("Size: " + buttonsSize + "/" + (sizeChooser.getMax() + 10));
					},
					onStopTrackingTouch: function()
					{
						ModPE.saveData("bSize", buttonsSize);
					}
				});
				sizeChooser.setPadding(padding * 2, 0, padding * 2, 0);
				layout.addView(sizeChooser);

				var sizeText1 = new android.widget.TextView(currentActivity);
				sizeText1.setText("Size: " + buttonsSize + "/" + (sizeChooser.getMax() + 10));
				sizeText1.setTextColor(android.graphics.Color.parseColor("#FFC0C0C0"));
				sizeText1.setPadding(padding * 2, 0, padding * 2, 0);
				layout.addView(sizeText1);

				layout.addView(dividerText());



				var moveButtonsText = new android.widget.TextView(currentActivity);
				moveButtonsText.setText("Select the y positions of the \"fire\" and \"aim\" buttons (default is 0)");
				moveButtonsText.setTextColor(android.graphics.Color.parseColor("#FFFFFFFF"));
				moveButtonsText.setPadding(padding, 0, padding, 0);
				layout.addView(moveButtonsText);

				var maxY = (displayHeight / 4 * 3);
				if(maxY % 2 != 0)
					maxY--;
				var moveButtonsChooser = new android.widget.SeekBar(currentActivity);
				moveButtonsChooser.setMax(maxY);
				moveButtonsChooser.setProgress((-pixelsOffsetButtons) + (maxY / 2));
				moveButtonsChooser.setOnSeekBarChangeListener(new android.widget.SeekBar.OnSeekBarChangeListener()
				{
					onProgressChanged: function()
					{
						pixelsOffsetButtons = -(moveButtonsChooser.getProgress() - (maxY / 2));
						moveButtonsText1.setText("Y position: " + (-pixelsOffsetButtons) + " pixels");
					},
					onStopTrackingTouch: function()
					{
						ModPE.saveData("mButtons", pixelsOffsetButtons);
					}
				});
				moveButtonsChooser.setPadding(padding * 2, 0, padding * 2, 0);
				layout.addView(moveButtonsChooser);

				var moveButtonsText1 = new android.widget.TextView(currentActivity);
				moveButtonsText1.setText("Y position: " + (-pixelsOffsetButtons) + " pixels");
				moveButtonsText1.setTextColor(android.graphics.Color.parseColor("#FFC0C0C0"));
				moveButtonsText1.setPadding(padding * 2, 0, padding * 2, 0);
				layout.addView(moveButtonsText1);

				layout.addView(dividerText());



				var sizeText2 = new android.widget.TextView(currentActivity);
				sizeText2.setText("Select the preferred size of the ammo text (default is " + AMMO_TEXT_SIZE_DEFAULT + ")");
				sizeText2.setTextColor(android.graphics.Color.parseColor("#FFFFFFFF"));
				sizeText2.setPadding(padding, 0, padding, 0);
				layout.addView(sizeText2);

				var sizeChooser1 = new android.widget.SeekBar(currentActivity);
				sizeChooser1.setMax(20);
				sizeChooser1.setProgress(ammoTextSize - 8);
				sizeChooser1.setOnSeekBarChangeListener(new android.widget.SeekBar.OnSeekBarChangeListener()
				{
					onProgressChanged: function()
					{
						ammoTextSize = sizeChooser1.getProgress() + 8;
						sizeText3.setText("Size: " + ammoTextSize + "/" + (sizeChooser1.getMax() + 8));
					},
					onStopTrackingTouch: function()
					{
						ModPE.saveData("aTSize", ammoTextSize);
					}
				});
				sizeChooser1.setPadding(padding * 2, 0, padding * 2, 0);
				layout.addView(sizeChooser1);

				var sizeText3 = new android.widget.TextView(currentActivity);
				sizeText3.setText("Size: " + ammoTextSize + "/" + (sizeChooser1.getMax() + 8));
				sizeText3.setTextColor(android.graphics.Color.parseColor("#FFC0C0C0"));
				sizeText3.setPadding(padding * 2, 0, padding * 2, 0);
				layout.addView(sizeText3);

				layout.addView(dividerText());



				var switchButtonsPosition = new android.widget.Switch(currentActivity);
				switchButtonsPosition.setChecked(switchedButtonsPosition);
				switchButtonsPosition.setText("Switch position of the \"fire\" and \"aim\" buttons");
				switchButtonsPosition.setTextColor(android.graphics.Color.parseColor("#FFFFFFFF"));
				switchButtonsPosition.setOnCheckedChangeListener(new android.widget.CompoundButton.OnCheckedChangeListener()
				{
					onCheckedChanged: function()
					{
						switchedButtonsPosition = !switchedButtonsPosition;
						ModPE.saveData("sBPosition", switchedButtonsPosition);
					}
				});
				switchButtonsPosition.setPadding(padding, 0, padding, 0);
				layout.addView(switchButtonsPosition);

				layout.addView(dividerText());



				var switchButtonsStyle = new android.widget.Switch(currentActivity);
				switchButtonsStyle.setChecked(minecraftStyleForButtons);
				switchButtonsStyle.setText("Enable Minecraft style for the \"fire\" and \"aim\" buttons");
				switchButtonsStyle.setTextColor(android.graphics.Color.parseColor("#FFFFFFFF"));
				switchButtonsStyle.setOnCheckedChangeListener(new android.widget.CompoundButton.OnCheckedChangeListener()
				{
					onCheckedChanged: function()
					{
						minecraftStyleForButtons = !minecraftStyleForButtons;
						ModPE.saveData("sBStyle", minecraftStyleForButtons);
					}
				});
				switchButtonsStyle.setPadding(padding, 0, padding, 0);
				layout.addView(switchButtonsStyle);

				layout.addView(dividerText());




				var title = defaultSubTitle("UI");
				layout.addView(title);

				layout.addView(dividerText());

				var switchSight = new android.widget.Switch(currentActivity);
				switchSight.setChecked(shouldDisplaySight);
				switchSight.setText("Display a little cross in the center of the screen");
				switchSight.setTextColor(android.graphics.Color.parseColor("#FFFFFFFF"));
				switchSight.setOnCheckedChangeListener(new android.widget.CompoundButton.OnCheckedChangeListener()
				{
					onCheckedChanged: function()
					{
						shouldDisplaySight = !shouldDisplaySight;
						ModPE.saveData("dSight", shouldDisplaySight);
						try {
							popupSightImage.dismiss();
						} catch(e) {}
					}
				});
				switchSight.setPadding(padding, 0, padding, 0);
				layout.addView(switchSight);

				layout.addView(dividerText());



				var switchGunName = new android.widget.Switch(currentActivity);
				switchGunName.setChecked(displayGunNameInAmmo);
				switchGunName.setText("Display gun's name in the ammo text");
				switchGunName.setTextColor(android.graphics.Color.parseColor("#FFFFFFFF"));
				switchGunName.setOnCheckedChangeListener(new android.widget.CompoundButton.OnCheckedChangeListener()
				{
					onCheckedChanged: function()
					{
						displayGunNameInAmmo = !displayGunNameInAmmo;
						ModPE.saveData("dNameAmmo", displayGunNameInAmmo);
					}
				});
				switchGunName.setPadding(padding, 0, padding, 0);
				layout.addView(switchGunName);

				layout.addView(dividerText());



				var title = defaultSubTitle("Audio");
				layout.addView(title);

				layout.addView(dividerText());

				var audioText = new android.widget.TextView(currentActivity);
				audioText.setText("Set the sound volume of the mod (default is " + 10 + ")");
				audioText.setTextColor(android.graphics.Color.parseColor("#FFFFFFFF"));
				audioText.setPadding(padding, 0, padding, 0);
				layout.addView(audioText);

				var audioChooser = new android.widget.SeekBar(currentActivity);
				audioChooser.setMax(10);
				audioChooser.setProgress(generalVolume * 10);
				audioChooser.setOnSeekBarChangeListener(new android.widget.SeekBar.OnSeekBarChangeListener()
				{
					onProgressChanged: function()
					{
						generalVolume = audioChooser.getProgress() / 10;
						audioText1.setText("Volume: " + audioChooser.getProgress() + "/" + audioChooser.getMax());
					},
					onStopTrackingTouch: function()
					{
						ModPE.saveData("generalVolume", generalVolume);
					}
				});
				audioChooser.setPadding(padding * 2, 0, padding * 2, 0);
				layout.addView(audioChooser);

				var audioText1 = new android.widget.TextView(currentActivity);
				audioText1.setText("Volume: " + (generalVolume * 10) + "/" + audioChooser.getMax());
				audioText1.setTextColor(android.graphics.Color.parseColor("#FFC0C0C0"));
				audioText1.setPadding(padding * 2, 0, padding * 2, 0);
				layout.addView(audioText1);

				layout.addView(dividerText());



				var title = defaultSubTitle("Other");
				layout.addView(title);

				layout.addView(dividerText());

				var switchWorkaround = new android.widget.Switch(currentActivity);
				switchWorkaround.setChecked(deathWorkaround);
				switchWorkaround.setText("Enable workaround to prevent returning arrows while shooting (experimental)");
				switchWorkaround.setTextColor(android.graphics.Color.parseColor("#FFFFFFFF"));
				switchWorkaround.setOnCheckedChangeListener(new android.widget.CompoundButton.OnCheckedChangeListener()
				{
					onCheckedChanged: function()
					{
						deathWorkaround = !deathWorkaround;
						ModPE.saveData("dWorkaround", deathWorkaround);

						if(DEBUG1)
						{
							var dWorkaroundTest = ModPE.readData("dWorkaround");
							if(typeof dWorkaroundTest == "boolean")
							{
								clientMessage("bool");
							} else
							{
								if(typeof dWorkaroundTest == "string")
								{
									clientMessage("string");
								} else
								{
									clientMessage(typeof dWorkaroundTest);
								}
							}
							clientMessage(dWorkaroundTest);

							if(deathWorkaround)
								clientMessage("workaround");
							else
								clientMessage("keep everything");
						}
					}
				});
				switchWorkaround.setPadding(padding, 0, padding, 0);
				layout.addView(switchWorkaround);

				layout.addView(dividerText());



				var switchReloadCreative = new android.widget.Switch(currentActivity);
				switchReloadCreative.setChecked(reloadInCreative);
				switchReloadCreative.setText("Reload in creative");
				switchReloadCreative.setTextColor(android.graphics.Color.parseColor("#FFFFFFFF"));
				switchReloadCreative.setOnCheckedChangeListener(new android.widget.CompoundButton.OnCheckedChangeListener()
				{
					onCheckedChanged: function()
					{
						reloadInCreative = !reloadInCreative;
						ModPE.saveData("rCreative", reloadInCreative);

						switchInstantReloadCreative.setEnabled(reloadInCreative);
					}
				});
				switchReloadCreative.setPadding(padding, 0, padding, 0);
				layout.addView(switchReloadCreative);

				layout.addView(dividerText());



				var switchInstantReloadCreative = new android.widget.Switch(currentActivity);
				switchInstantReloadCreative.setChecked(instantReloadInCreative);
				switchInstantReloadCreative.setText("Instant reload in creative (disable reload sounds)");
				switchInstantReloadCreative.setTextColor(android.graphics.Color.parseColor("#FFFFFFFF"));
				switchInstantReloadCreative.setOnCheckedChangeListener(new android.widget.CompoundButton.OnCheckedChangeListener()
				{
					onCheckedChanged: function()
					{
						instantReloadInCreative = !instantReloadInCreative;
						ModPE.saveData("instReload", instantReloadInCreative);
					}
				});
				switchInstantReloadCreative.setEnabled(reloadInCreative);
				switchInstantReloadCreative.setPadding(padding, 0, padding, 0);
				layout.addView(switchInstantReloadCreative);

				layout.addView(dividerText());



				var backButton = MinecraftButton();
				backButton.setText("Back");
				backButton.setOnClickListener(new android.view.View.OnClickListener()
				{
					onClick: function()
					{
						infoDesnoGunsMod();
						popup.dismiss();
					}
				});
				layout.addView(backButton);
				setMarginsLinearLayout(backButton, 0, MARGIN_HORIZONTAL_SMALL, 0, MARGIN_HORIZONTAL_SMALL);

				var exitButton = MinecraftButton();
				exitButton.setText("Close");
				exitButton.setOnClickListener(new android.view.View.OnClickListener()
				{
					onClick: function()
					{
						popup.dismiss();
					}
				});
				layout.addView(exitButton);
				setMarginsLinearLayout(exitButton, 0, MARGIN_HORIZONTAL_SMALL, 0, MARGIN_HORIZONTAL_SMALL);


				var popup = defaultPopup(layout);
				popup.show();

			} catch(err)
			{
				clientMessage("Error: " + err);
			}
		}
	});
}

function latestVersionUI()
{
	currentActivity.runOnUiThread(new java.lang.Runnable()
	{
		run: function()
		{
			try
			{
				var layout;
				layout = defaultLayout("You're up to date");

				var updatesText = defaultContentTextView("You have the latest version of the mod.<br><br>" +
					"Download the Desno365's Mods app to receive notifications of new updates and get the latest news about my mods.");
				layout.addView(updatesText);
				setMarginsLinearLayout(updatesText, 0, MARGIN_HORIZONTAL_SMALL, 0, MARGIN_HORIZONTAL_BIG);

				var playStoreView = new android.widget.ImageView(currentActivity);
				playStoreView.setImageBitmap(playStorePngScaled);
				playStoreView.setOnClickListener(new android.view.View.OnClickListener(
				{
					onClick: function()
					{
						try
						{
							//play store installed
							currentActivity.startActivity(new android.content.Intent(android.content.Intent.ACTION_VIEW, android.net.Uri.parse("market://details?id=" + "com.desno365.mods")));
						} catch (err)
						{
							//play store not installed
							currentActivity.startActivity(new android.content.Intent(android.content.Intent.ACTION_VIEW, android.net.Uri.parse("http://play.google.com/store/apps/details?id=" + "com.desno365.mods")));
						}
					}
				}));
				layout.addView(playStoreView);
				setMarginsLinearLayout(playStoreView, 0, MARGIN_HORIZONTAL_SMALL, 0, MARGIN_HORIZONTAL_BIG);



				var backButton = MinecraftButton();
				backButton.setText("Back");
				backButton.setOnClickListener(new android.view.View.OnClickListener()
				{
					onClick: function()
					{
						infoDesnoGunsMod();
						popup.dismiss();
					}
				});
				layout.addView(backButton);
				setMarginsLinearLayout(backButton, 0, MARGIN_HORIZONTAL_SMALL, 0, MARGIN_HORIZONTAL_SMALL);

				var exitButton = MinecraftButton();
				exitButton.setText("Close");
				exitButton.setOnClickListener(new android.view.View.OnClickListener()
				{
					onClick: function()
					{
						popup.dismiss();
					}
				});
				layout.addView(exitButton);
				setMarginsLinearLayout(exitButton, 0, MARGIN_HORIZONTAL_SMALL, 0, MARGIN_HORIZONTAL_SMALL);


				var popup = defaultPopup(layout);
				popup.show();

			} catch(err)
			{
				clientMessage("Error: " + err);
			}
		}
	});
}

function updateAvailableUI()
{
	currentActivity.runOnUiThread(new java.lang.Runnable()
	{
		run: function()
		{
			try
			{
				var layout;
				layout = defaultLayout("DesnoGuns Mod: new version");

				var updatesText = defaultContentTextView("New version available, you have the " + CURRENT_VERSION + " version and the latest version is " + latestVersion + ".<br>" +
					"You can find a download link on Desno365's website (press the button to visit it).");
				layout.addView(updatesText);
				setMarginsLinearLayout(updatesText, 0, MARGIN_HORIZONTAL_SMALL, 0, MARGIN_HORIZONTAL_SMALL);

				var threadButton = MinecraftButton();
				threadButton.setText("Visit website");
				threadButton.setOnClickListener(new android.view.View.OnClickListener()
				{
					onClick: function()
					{
						var intentBrowser = new android.content.Intent(currentActivity);
						intentBrowser.setAction(android.content.Intent.ACTION_VIEW);
						intentBrowser.setData(android.net.Uri.parse("http://desno365.github.io/minecraft/desnoguns-mod/"));
						currentActivity.startActivity(intentBrowser);
						popup.dismiss();
					}
				});
				layout.addView(threadButton);
				setMarginsLinearLayout(threadButton, 0, MARGIN_HORIZONTAL_SMALL, 0, MARGIN_HORIZONTAL_BIG);

				var exitButton = MinecraftButton();
				exitButton.setText("Close");
				exitButton.setOnClickListener(new android.view.View.OnClickListener()
				{
					onClick: function()
					{
						popup.dismiss();
					}
				});
				layout.addView(exitButton);
				setMarginsLinearLayout(exitButton, 0, MARGIN_HORIZONTAL_SMALL, 0, MARGIN_HORIZONTAL_SMALL);


				var popup = defaultPopup(layout);
				popup.setCanceledOnTouchOutside(false);
				popup.show();

			} catch(err)
			{
				clientMessage("Error: " + err);
			}
		}
	});
}

function visitThread()
{
	currentActivity.runOnUiThread(new java.lang.Runnable()
	{
		run: function()
		{
			try
			{
				var intentBrowser = new android.content.Intent(currentActivity);
				intentBrowser.setAction(android.content.Intent.ACTION_VIEW);
				intentBrowser.setData(android.net.Uri.parse("http://www.minecraftforum.net/forums/minecraft-pocket-edition/mcpe-mods-tools/2299721-mod-desnoguns-mod-more-than-50-weapons-r001-by"));
				currentActivity.startActivity(intentBrowser);
			} catch(err)
			{
				clientMessage("Error: " + err);
			}
		}
	});
}

function supportUI()
{
	currentActivity.runOnUiThread(new java.lang.Runnable()
	{
		run: function()
		{
			try
			{
				var layout;
				layout = defaultLayout("Support me");

				var text = defaultContentTextView("This mod was brought to you with love by Desno365 :)<br>Thank you for playing with it.");
				layout.addView(text);
				setMarginsLinearLayout(text, 0, MARGIN_HORIZONTAL_SMALL, 0, MARGIN_HORIZONTAL_SMALL);

				var button1 = MinecraftButton();
				button1.setText("Follow me on Twitter");
				button1.setOnClickListener(new android.view.View.OnClickListener()
				{
					onClick: function()
					{
						android.widget.Toast.makeText(currentActivity, "Opening the URL...", 0).show();
						var intentBrowser = new android.content.Intent(currentActivity);
						intentBrowser.setAction(android.content.Intent.ACTION_VIEW);
						intentBrowser.setData(android.net.Uri.parse("https://twitter.com/desno365"));
						currentActivity.startActivity(intentBrowser);
						popup.dismiss();
					}
				});
				layout.addView(button1);
				setMarginsLinearLayout(button1, 0, MARGIN_HORIZONTAL_SMALL, 0, MARGIN_HORIZONTAL_SMALL);

				var button2 = MinecraftButton();
				button2.setText("Subscribe to my YouTube channel");
				button2.setOnClickListener(new android.view.View.OnClickListener()
				{
					onClick: function()
					{
						android.widget.Toast.makeText(currentActivity, "Opening the URL...", 0).show();
						var intentBrowser = new android.content.Intent(currentActivity);
						intentBrowser.setAction(android.content.Intent.ACTION_VIEW);
						intentBrowser.setData(android.net.Uri.parse("http://www.youtube.com/channel/UCJQL47nQnsijcaN_7pMsjCQ/videos"));
						currentActivity.startActivity(intentBrowser);
						popup.dismiss();
					}
				});
				layout.addView(button2);
				if(!isPro())
					setMarginsLinearLayout(button2, 0, MARGIN_HORIZONTAL_SMALL, 0, MARGIN_HORIZONTAL_SMALL);
				else
					setMarginsLinearLayout(button2, 0, MARGIN_HORIZONTAL_SMALL, 0, MARGIN_HORIZONTAL_BIG);

				if(!isPro())
				{
					var button3 = MinecraftButton();
					button3.setText("Get the Pro Key");
					button3.setOnClickListener(new android.view.View.OnClickListener()
					{
						onClick: function()
						{
							openProKeyOnPlayStore();
							popup.dismiss();
						}
					});
					layout.addView(button3);
					setMarginsLinearLayout(button3, 0, MARGIN_HORIZONTAL_SMALL, 0, MARGIN_HORIZONTAL_BIG);
				}

				var backButton = MinecraftButton();
				backButton.setText("Back");
				backButton.setOnClickListener(new android.view.View.OnClickListener()
				{
					onClick: function()
					{
						infoDesnoGunsMod();
						popup.dismiss();
					}
				});
				layout.addView(backButton);
				setMarginsLinearLayout(backButton, 0, MARGIN_HORIZONTAL_SMALL, 0, MARGIN_HORIZONTAL_SMALL);

				var exitButton = MinecraftButton();
				exitButton.setText("Close");
				exitButton.setOnClickListener(new android.view.View.OnClickListener()
				{
					onClick: function()
					{
						popup.dismiss();
					}
				});
				layout.addView(exitButton);
				setMarginsLinearLayout(exitButton, 0, MARGIN_HORIZONTAL_SMALL, 0, MARGIN_HORIZONTAL_SMALL);


				var popup = defaultPopup(layout);
				popup.show();

			} catch(err)
			{
				clientMessage("Error: " + err);
				clientMessage("Maybe GUI is not supported for your device.");
			}
		}
	});
}

function easterEggUI()
{
	currentActivity.runOnUiThread(new java.lang.Runnable()
	{
		run: function()
		{
			try
			{
				var layout;
				layout = defaultLayout("I don't want to explode!");

				layout.addView(dividerText());

				var layoutH = new android.widget.LinearLayout(currentActivity);
				layoutH.setOrientation(android.widget.LinearLayout.HORIZONTAL);

				var inputText1 = new android.widget.EditText(currentActivity);
				inputText1.setHint("The code");
				if(codeEE == null || codeEE == undefined)
					inputText1.setEnabled(false);
				layoutH.addView(inputText1);

				var button1 = MinecraftButton();
				button1.setText("Ok");
				button1.setOnClickListener(new android.view.View.OnClickListener()
				{
					onClick: function()
					{
						if(codeEE != null && codeEE != undefined)
						{
							if(String(codeEE) == String(inputText1.getText()))
							{
								Level.setTime(1000);
								Level.setTime(10000);
								Level.setTime(1000);
								Level.setTile(xCoalEE, yCoalEE, zCoalEE, 0);
								Level.setTile(xCoalEE, yCoalEE - 1, zCoalEE, 0);

								popup.dismiss();
								easterEgg = true;
								unstuck = -1;
								pigmen = [];
								codeEE = null;

								BARRETT_EXPLOSIVE.type = BUTTON_TYPE_ON_TOUCH;
								BARRETT_EXPLOSIVE.ammo = 500;
								BARRETT_EXPLOSIVE.recoil = 3;
								BARRETT_EXPLOSIVE.fireRate = 3;
								Item.setMaxDamage(BARRETT_EXPLOSIVE.id, 500);

								if(Player.getCarriedItem() == BARRETT_EXPLOSIVE.id)
									changeCarriedItemHook(BARRETT_EXPLOSIVE.id, BARRETT.id);

								currentActivity.runOnUiThread(new java.lang.Runnable(
								{
									run: function()
									{
										for(var ms = 0; ms < 60; ms++)
										{
											new android.os.Handler().postDelayed(new java.lang.Runnable(
											{
												run: function()
												{
													ModPE.showTipMessage("§" + currentColorEE.toString(16) + "Easter Egg enabled!");
													if(currentColorEE == 15)
														currentColorEE = 0;
													else
														currentColorEE++;
												}
											}), ms * 250 + 1);
										}
									}
								}));
							} else
							{
								currentActivity.runOnUiThread(new java.lang.Runnable()
								{
									run: function()
									{
										android.widget.Toast.makeText(currentActivity, new android.text.Html.fromHtml("Wrong code!"), android.widget.Toast.LENGTH_SHORT).show();
									}
								});
							}
						}
					}
				});
				if(codeEE == null || codeEE == undefined)
					button1.setEnabled(false);
				layoutH.addView(button1);

				layout.addView(layoutH);

				layout.addView(dividerText());

				var button2 = MinecraftButton();
				button2.setText("Start wave");
				button2.setOnClickListener(new android.view.View.OnClickListener()
				{
					onClick: function()
					{
						Level.setTime(10000);
						for(var i = 0; i <= 20; i++)
						{
							var playerDir = getDirection(getYaw(), getPitch());

							pigmen.push(Level.spawnMob(getPlayerX() + (playerDir.x * 10), getPlayerY(), getPlayerZ() + (playerDir.z * 10), 36));

							// enable Sin0psysS's spawning pattern code (with some changes by me)
							unstuck = 20;
						}
						clientMessage("Barrett Explosive.");
						popup.dismiss();
					}
				});
				layout.addView(button2);

				layout.addView(dividerText());

				var exitButton = MinecraftButton();
				exitButton.setText("Close");
				exitButton.setOnClickListener(new android.view.View.OnClickListener()
				{
					onClick: function()
					{
						popup.dismiss();
					}
				});
				layout.addView(exitButton);


				var popup = defaultPopup(layout);
				popup.show();

			} catch(err)
			{
				clientMessage("Error: " + err);
			}
		}
	});
}

// No Minecraft Layout because this UI can be showed at startup
function pleaseInstallTextureUI()
{
	textureUiShowed = true;
	currentActivity.runOnUiThread(new java.lang.Runnable()
	{
		run: function()
		{
			try
			{
				var layout = new android.widget.LinearLayout(currentActivity);
				var padding = convertDpToPixel(8);
				layout.setPadding(padding, padding, padding, padding);
				layout.setOrientation(android.widget.LinearLayout.VERTICAL);

				var scroll = new android.widget.ScrollView(currentActivity);
				scroll.addView(layout);

				var popup = new android.app.Dialog(currentActivity);
				popup.setContentView(scroll);
				popup.setTitle(new android.text.Html.fromHtml("Texture not installed"));
				popup.setCanceledOnTouchOutside(false);

				var text = new android.widget.TextView(currentActivity);
				text.setText(new android.text.Html.fromHtml("Seems that you haven't installed the DesnoGuns texture pack.<br><br>Please install the Texture Pack of the mod and <b>restart BlockLauncher</b> to enjoy all the features of the DesnoGuns Mod."));
				layout.addView(text);

				layout.addView(dividerText());

				var exitButton = new android.widget.Button(currentActivity);
				exitButton.setText("OK");
				exitButton.setOnClickListener(new android.view.View.OnClickListener()
				{
					onClick: function()
					{
						textureUiShowed = false;
						popup.dismiss();
					}
				});
				layout.addView(exitButton);


				popup.show();

			} catch(err)
			{
				print("Error: " + err);
			}
		}
	});
}


//########################################################################################################################################################
// Renders
//########################################################################################################################################################

// grenade render by Anti, thanks!
function addGrenadeRenderType(renderer)
{
	var model = renderer.getModel();

	var head = model.getPart("head");
	var body = model.getPart("body");
	var rArm = model.getPart("rightArm");
	var lArm = model.getPart("leftArm");
	var rLeg = model.getPart("rightLeg");
	var lLeg = model.getPart("leftLeg");

	head.clear();

	body.clear();
	body.setTextureOffset(0, 0);
	body.addBox(-1, 20, -1.5, 2, 4, 3);
	body.setTextureOffset(8, 0);
	body.addBox(-0.5, 20.5, 1.5, 1, 1, 1);

	rArm.clear();

	lArm.clear();

	rLeg.clear();

	lLeg.clear();
}
var grenadeRenderType = Renderer.createHumanoidRenderer();
addGrenadeRenderType(grenadeRenderType);
const GRENADE_RENDER_COLLISION_SIZE_XZ = 1/16 * 4;
const GRENADE_RENDER_COLLISION_SIZE_Y = 1/16 * 4;

Entity.setGrenadeRender = function(entity)
{
	Entity.setRenderType(entity, grenadeRenderType.renderType);
	Entity.setCollisionSize(entity, GRENADE_RENDER_COLLISION_SIZE_XZ, GRENADE_RENDER_COLLISION_SIZE_Y);
}


//########################################################################################################################################################
// Sounds installation
//########################################################################################################################################################

var SoundsInstaller = {
	sounds:
	{
		version: 3,
		soundArray: [
			// { fileName: "", file: "" },
			// { fileName: "", fileDirectory: "", file: "" },

			{
				fileName: "44Magnum.mp3"
			},
			{
				fileName: "AA-12Shoot.ogg"
			},
			{
				fileName: "AK47Shoot.ogg"
			},
			{
				fileName: "AK74Shoot.ogg"
			},
			{
				fileName: "AT4_and_M72LAW_and_Panzerfaust3Shoot.ogg"
			},
			{
				fileName: "BarrettShoot.ogg"
			},
			{
				fileName: "bell.mp3"
			},
			{
				fileName: "benboncan_parachute.mp3"
			},
			{
				fileName: "CrossbowShoot.wav"
			},
			{
				fileName: "DesertEagleShoot.ogg"
			},
			{
				fileName: "DragunovShoot.ogg"
			},
			{
				fileName: "EmptyGun.ogg"
			},
			{
				fileName: "explosion-countdown.wav"
			},
			{
				fileName: "fire-explosion.mp3"
			},
			{
				fileName: "flamethrower.mp3"
			},
			{
				fileName: "FNSCAR_and_AUG_and_MTARShoot.ogg"
			},
			{
				fileName: "G36Shoot.ogg"
			},
			{
				fileName: "GlockShoot.ogg"
			},
			{
				fileName: "GrenadeLauncherShoot.ogg"
			},
			{
				fileName: "ignite_flamethrower1.ogg"
			},
			{
				fileName: "ignite_flamethrower2.ogg"
			},
			{
				fileName: "ignite_flamethrower3.ogg"
			},
			{
				fileName: "knife_on_blocks.mp3"
			},
			{
				fileName: "knife_stab1.mp3"
			},
			{
				fileName: "knife_stab2.mp3"
			},
			{
				fileName: "L96Shoot.ogg"
			},
			{
				fileName: "LICENSE.txt"
			},
			{
				fileName: "M9Shoot.ogg"
			},
			{
				fileName: "M14_and_M16A4Shoot.ogg"
			},
			{
				fileName: "M21Shoot.ogg"
			},
			{
				fileName: "M249_and_L86Shoot.ogg"
			},
			{
				fileName: "M1014Shoot.ogg"
			},
			{
				fileName: "M1887Shoot.ogg"
			},
			{
				fileName: "MakarovShoot.ogg"
			},
			{
				fileName: "MinigunCooldown.ogg"
			},
			{
				fileName: "MinigunSpin.ogg"
			},
			{
				fileName: "MinigunWarmup.ogg"
			},
			{
				fileName: "MiniUziShoot.ogg"
			},
			{
				fileName: "MolotovExplosion.mp3"
			},
			{
				fileName: "MP5Shoot.ogg"
			},
			{
				fileName: "MSRShoot.mp3"
			},
			{
				fileName: "P90_and_Bizon_and_G3Shoot_and_Minigun.ogg"
			},
			{
				fileName: "R700_and_M40A3Shoot.ogg"
			},
			{
				fileName: "R870Shoot.ogg"
			},
			{
				fileName: "BARReload.ogg",
				fileDirectory: "reload"
			},
			{
				fileName: "BazookaReload.ogg",
				fileDirectory: "reload"
			},
			{
				fileName: "BrenReload.ogg",
				fileDirectory: "reload"
			},
			{
				fileName: "BrowningReload.ogg",
				fileDirectory: "reload"
			},
			{
				fileName: "ColtReload.ogg",
				fileDirectory: "reload"
			},
			{
				fileName: "CrossbowReload.wav",
				fileDirectory: "reload"
			},
			{
				fileName: "DP28Reload.ogg",
				fileDirectory: "reload"
			},
			{
				fileName: "GL6Reload.ogg",
				fileDirectory: "reload"
			},
			{
				fileName: "GrenadeLauncherReload.ogg",
				fileDirectory: "reload"
			},
			{
				fileName: "Kar98kReload.ogg",
				fileDirectory: "reload"
			},
			{
				fileName: "LeeEnfieldReload.ogg",
				fileDirectory: "reload"
			},
			{
				fileName: "LugerReload.ogg",
				fileDirectory: "reload"
			},
			{
				fileName: "M1CarbineReload.ogg",
				fileDirectory: "reload"
			},
			{
				fileName: "M1014Reload.ogg",
				fileDirectory: "reload"
			},
			{
				fileName: "M1887Reload.ogg",
				fileDirectory: "reload"
			},
			{
				fileName: "MG42Reload.ogg",
				fileDirectory: "reload"
			},
			{
				fileName: "MP40Reload.ogg",
				fileDirectory: "reload"
			},
			{
				fileName: "MP44Reload.ogg",
				fileDirectory: "reload"
			},
			{
				fileName: "PPSHReload.ogg",
				fileDirectory: "reload"
			},
			{
				fileName: "Reload1.ogg",
				fileDirectory: "reload"
			},
			{
				fileName: "SpringfieldReload.ogg",
				fileDirectory: "reload"
			},
			{
				fileName: "StenReload.ogg",
				fileDirectory: "reload"
			},
			{
				fileName: "ThompsonReload.ogg",
				fileDirectory: "reload"
			},
			{
				fileName: "TT33Reload.ogg",
				fileDirectory: "reload"
			},
			{
				fileName: "W1200Reload.ogg",
				fileDirectory: "reload"
			},
			{
				fileName: "riot_shield_attack.mp3"
			},
			{
				fileName: "RPD_and_M60E4_and_RPKShoot.ogg"
			},
			{
				fileName: "RPGShoot.ogg"
			},
			{
				fileName: "SG550Shoot.ogg"
			},
			{
				fileName: "SIGP226Shoot.ogg"
			},
			{
				fileName: "smoke-grenade.mp3"
			},
			{
				fileName: "SkorpionShoot.ogg"
			},
			{
				fileName: "USPShoot.ogg"
			},
			{
				fileName: "W1200_and_SPASShoot.ogg"
			}
		]
	},

	progressDialog: null,

	versionFileName: "version.txt",


	checkAtStartup: function()
	{
		ModPE.log(getLogText() + "checkAtStartup(): started check.");

		if(SoundsInstaller.needsInstallation())
		{
			if(DEBUG1)
				print("DesnoGuns Debug: checkAtStartup(): sounds NOT correctly installed!");

			SoundsInstaller.installUI();
		} else
		{
			if(DEBUG1)
				print("DesnoGuns Debug: checkAtStartup(): sounds correctly installed.");
			ModPE.log(getLogText() + "checkAtStartup(): sounds correctly installed.");
		}
	},


	needsInstallation: function()
	{
		if(doesFileExist(sdcard + "/games/com.mojang/desnoguns-sounds/" + SoundsInstaller.versionFileName))
		{
			var versionOfSounds = SoundsInstaller.getInstalledVersion();
			ModPE.log(getLogText() + "needsInstallation(): version file found, version: " + versionOfSounds);

			// check version
			if(versionOfSounds == SoundsInstaller.sounds.version)
			{
				ModPE.log(getLogText() + "needsInstallation(): version of the file matches saved version.");
				return !SoundsInstaller.areSoundsPresent();
			} else
			{
				ModPE.log(getLogText() + "needsInstallation(): version of the file is different than saved version.");
				return true;
			}
		} else
		{
			ModPE.log(getLogText() + "needsInstallation(): version file not found.");
			return true;
		}
	},

	getInstalledVersion: function()
	{
		var versionFile = new java.io.File(sdcard + "/games/com.mojang/desnoguns-sounds/" + SoundsInstaller.versionFileName);
		if(versionFile.exists())
		{
			var loadedVersion = "";
			var streamVersionInput = new java.io.FileInputStream(versionFile);
			var bufferedVersionReader = new java.io.BufferedReader(new java.io.InputStreamReader(streamVersionInput));
			var rowVersion = "";
			while((rowVersion = bufferedVersionReader.readLine()) != null)
			{
				loadedVersion += rowVersion;
			}
			var loadedVersion = loadedVersion.split(" ");
			bufferedVersionReader.close();

			ModPE.log(getLogText() + "getInstalledVersion(): text on the version file: " + loadedVersion);
			return parseInt(loadedVersion);
		} else
		{
			print("Bug found: remember that getInstalledVersion() should be used only when version file exists.");
			return -1;
		}
	},

	areSoundsPresent: function()
	{
		var arrayOfMissingSounds = SoundsInstaller.checkMissingSounds();

		if(arrayOfMissingSounds.length == 0)
		{
			// yeah, all sounds needed have been found
			ModPE.log(getLogText() + "areSoundsPresent(): all sounds present.");
			return true;
		} else
		{
			// not correctly installed :(
			ModPE.log(getLogText() + "areSoundsPresent(): some sounds are missing.");
			ModPE.log(getLogText() + "areSoundsPresent(): missing: " + arrayOfMissingSounds.toString());
			return false;
		}
	},

	checkMissingSounds: function()
	{
		var tmpPath = sdcard + "/games/com.mojang/desnoguns-sounds/";
		var arrayOfErrors = [];
		for(var i in SoundsInstaller.sounds.soundArray)
		{
			if(SoundsInstaller.sounds.soundArray[i].fileDirectory == undefined || SoundsInstaller.sounds.soundArray[i].fileDirectory == null)
			{
				// file is inside the general sound folder
				if(!doesFileExist(tmpPath + SoundsInstaller.sounds.soundArray[i].fileName))
				{
					if(arrayOfErrors.indexOf(SoundsInstaller.sounds.soundArray[i].fileName) == -1)
						arrayOfErrors.push(SoundsInstaller.sounds.soundArray[i].fileName);
				} else
				{
					// file exists, maybe is empty?
					if(isFileEmpty(tmpPath + SoundsInstaller.sounds.soundArray[i].fileName))
					{
						if(arrayOfErrors.indexOf(SoundsInstaller.sounds.soundArray[i].fileName) == -1)
							arrayOfErrors.push(SoundsInstaller.sounds.soundArray[i].fileName);
					}
				}
			} else
			{
				// file is inside another folder
				if(!doesFileExist(tmpPath + SoundsInstaller.sounds.soundArray[i].fileDirectory + "/" + SoundsInstaller.sounds.soundArray[i].fileName))
				{
					if(arrayOfErrors.indexOf(SoundsInstaller.sounds.soundArray[i].fileName) == -1)
						arrayOfErrors.push(SoundsInstaller.sounds.soundArray[i].fileName);
				} else
				{
					// file exists, maybe is empty?
					if(isFileEmpty(tmpPath + SoundsInstaller.sounds.soundArray[i].fileDirectory + "/" + SoundsInstaller.sounds.soundArray[i].fileName))
					{
						if(arrayOfErrors.indexOf(SoundsInstaller.sounds.soundArray[i].fileName) == -1)
							arrayOfErrors.push(SoundsInstaller.sounds.soundArray[i].fileName);
					}
				}
			}
		}

		return arrayOfErrors;
	},


	installUI: function()
	{
		currentActivity.runOnUiThread(new java.lang.Runnable()
		{
			run: function()
			{
				try
				{
					ModPE.log(getLogText() + "installUI(): displayed installation for sounds UI.");

					var layout = new android.widget.LinearLayout(currentActivity);
					layout.setOrientation(android.widget.LinearLayout.VERTICAL);
					var padding = convertDpToPixel(8);
					layout.setPadding(padding, padding, padding, padding);

					var scroll = new android.widget.ScrollView(currentActivity);
					scroll.addView(layout);

					var popup = new android.app.AlertDialog.Builder(currentActivity);
					popup.setView(scroll);
					popup.setTitle("Download sounds?");

					var helpTextInstallation = new android.widget.TextView(currentActivity);
					helpTextInstallation.setText(android.text.Html.fromHtml("<br>Would you like to download and install DesnoGuns Mod sounds now?<br><br>" +
						"A total of approximately 3 MB of data will be saved on your internal storage.<br>" +
						"The installation may take up to one minute.<br><br>" +
						"An active Internet connection is needed to install sounds.<br>"));
					layout.addView(helpTextInstallation);

					popup.setPositiveButton("Install", new android.content.DialogInterface.OnClickListener() {
						onClick: function(viewarg)
						{
							SoundsInstaller.installingUI();
							ModPE.log(getLogText() + "installUI(): Sounds installation started by the user.");
						}
					});

					popup.setNegativeButton("Cancel", new android.content.DialogInterface.OnClickListener() {
						onClick: function(viewarg)
						{
							currentActivity.runOnUiThread(new java.lang.Runnable() {
								run: function() {
									android.widget.Toast.makeText(currentActivity, new android.text.Html.fromHtml("<b>DesnoGuns</b>: Some features may not work properly without sounds."), android.widget.Toast.LENGTH_LONG).show();
								}
							});
							ModPE.log(getLogText() + "installUI(): Sounds installation canceled.");
						}
					});


					var alertDialog = popup.create();
					alertDialog.setCanceledOnTouchOutside(false);
					alertDialog.show();

				} catch(err)
				{
					print("Error: " + err);
				}
			}
		});
	},

	installingUI: function()
	{
		currentActivity.runOnUiThread(new java.lang.Runnable()
		{
			run: function()
			{
				try
				{
					SoundsInstaller.progressDialog = new android.app.ProgressDialog(currentActivity);
					SoundsInstaller.progressDialog.setTitle("Downloading...");
					SoundsInstaller.progressDialog.setMessage("Downloading sound 1 of " + SoundsInstaller.sounds.soundArray.length);
					SoundsInstaller.progressDialog.setProgressStyle(android.app.ProgressDialog.STYLE_HORIZONTAL);
					SoundsInstaller.progressDialog.setCancelable(false);
					SoundsInstaller.progressDialog.setCanceledOnTouchOutside(false);
					SoundsInstaller.progressDialog.setIndeterminate(false);
					SoundsInstaller.progressDialog.setMax(SoundsInstaller.sounds.soundArray.length);
					SoundsInstaller.progressDialog.setProgress(0);
					SoundsInstaller.progressDialog.show();

					SoundsInstaller.install();
				} catch(err)
				{
					print("Error: " + err);
				}
			}
		});
	},

	install: function()
	{
		new java.lang.Thread(new java.lang.Runnable()
		{
			run: function()
			{
				var githubUrl = "https://raw.githubusercontent.com/Desno365/MCPE-scripts/master/version" + SoundsInstaller.sounds.version + "/desnoguns-sounds/";
				var tmpPath = sdcard + "/games/com.mojang/desnoguns-sounds/";

				deleteFile(tmpPath); //delete previous files if present

				// creates directories
				new java.io.File(tmpPath).mkdirs();
				new java.io.File(tmpPath + "reload/").mkdirs();

				for(var i in SoundsInstaller.sounds.soundArray)
				{
					// display progress
					currentActivity.runOnUiThread(new java.lang.Runnable()
					{
						run: function()
						{
							var progress = parseInt(i) + 1;
							SoundsInstaller.progressDialog.setMessage("Downloading sound " + (progress) + " of " + SoundsInstaller.sounds.soundArray.length);
							SoundsInstaller.progressDialog.setProgress(progress);

						}
					});

					// save file on the sdcard
					if(SoundsInstaller.sounds.soundArray[i].fileDirectory == undefined || SoundsInstaller.sounds.soundArray[i].fileDirectory == null)
					{
						// file is inside the general sound folder
						//writeFileFromByteArray(android.util.Base64.decode(SoundsInstaller.sounds.soundArray[i].file, 0), tmpPath + SoundsInstaller.sounds.soundArray[i].fileName);
						SoundsInstaller.downloadFile(githubUrl + SoundsInstaller.sounds.soundArray[i].fileName, tmpPath + SoundsInstaller.sounds.soundArray[i].fileName);
					} else
					{
						// file is inside another folder
						//writeFileFromByteArray(android.util.Base64.decode(SoundsInstaller.sounds.soundArray[i].file, 0), tmpPath + SoundsInstaller.sounds.soundArray[i].fileDirectory + "/" + SoundsInstaller.sounds.soundArray[i].fileName);
						SoundsInstaller.downloadFile(githubUrl + SoundsInstaller.sounds.soundArray[i].fileDirectory + "/" + SoundsInstaller.sounds.soundArray[i].fileName, tmpPath + SoundsInstaller.sounds.soundArray[i].fileDirectory + "/" + SoundsInstaller.sounds.soundArray[i].fileName);
					}
				}

				var nomediaFile = new java.io.File(sdcard + "/games/com.mojang/desnoguns-sounds/.nomedia");
				if(!nomediaFile.exists())
					nomediaFile.createNewFile();

				// put file version
				SoundsInstaller.saveFileWithVersion();

				// END INSTALLATION
				SoundsInstaller.onFinishInstallation();
			}
		}).start();
	},


	downloadFile: function(url, savePath)
	{
		try
		{
			// download content
			var url = new java.net.URL(url);
			var connection = url.openConnection();

			// create file
			var file = new java.io.File(savePath);
			if(file.exists())
				file.delete();
			file.createNewFile();
	 
			// get content
			inputStream = connection.getInputStream();

			// write to file
			var outputStream = new java.io.FileOutputStream(file);
			var read = 0;
			var bytes = java.lang.reflect.Array.newInstance(java.lang.Byte.TYPE, 1024);
			while ((read = inputStream.read(bytes)) != -1) {
				outputStream.write(bytes, 0, read);
			}
	 
			// close what needs to be closed
			outputStream.close();
		} catch(err)
		{
			ModPE.log(getLogText() + "downloadFile(): caught an error: " + err);
		}
	},


	onFinishInstallation: function()
	{
		SoundsInstaller.progressDialog.dismiss();

		ModPE.log(getLogText() + "Finished sounds installation. Re-checking sounds...");

		var notSuccess = SoundsInstaller.needsInstallation();
		if(notSuccess)
		{
			currentActivity.runOnUiThread(new java.lang.Runnable() {
				run: function() {
					android.widget.Toast.makeText(currentActivity, new android.text.Html.fromHtml("<b>DesnoGuns</b>: An error has happened during installation, so sounds aren't correctly installed, please check your Internet connection and try again."), android.widget.Toast.LENGTH_LONG).show();
				}
			});
			ModPE.log(getLogText() + "Sounds HAVEN'T been correctly installed!");
		} else
		{
			currentActivity.runOnUiThread(new java.lang.Runnable() {
				run: function() {
					android.widget.Toast.makeText(currentActivity, new android.text.Html.fromHtml("<b>DesnoGuns</b>: Congratulations, sounds are now correctly installed. You can start playing with the <i>DesnoGuns Mod</i>."), android.widget.Toast.LENGTH_LONG).show();
				}
			});
			ModPE.log(getLogText() + "Sounds have been correctly installed. Very good.");
		}

		removeSoundsInstaller();
	},

	saveFileWithVersion: function()
	{
		var versionSaveFile = new java.io.File(sdcard + "/games/com.mojang/desnoguns-sounds/" + SoundsInstaller.versionFileName);
		if(versionSaveFile.exists())
			versionSaveFile.delete();
		versionSaveFile.createNewFile();

		var streamOutputVersion = new java.io.FileOutputStream(versionSaveFile);
		var streamWriterVersion = new java.io.OutputStreamWriter(streamOutputVersion);

		streamWriterVersion.append(SoundsInstaller.sounds.version + " what are you searching for? This text is private and you shouldn't see. No, I'm joking, do whatever you want here.");
		streamWriterVersion.close();
		streamOutputVersion.close();
	}
};

function removeSoundsInstaller()
{
	// this should allow the GC to free the memory that all the sounds were using
	SoundsInstaller = null;
}

//########################################################################################################################################################
// Things to do at startup
//########################################################################################################################################################

// add guns
for(var i in guns)
{
	addNewGun(guns[i]);

	if(!isItemAGun(guns[i].id))
		throw getLogText() + "Not a gun: " + guns[i].name + ", " + guns[i].id + ".";
}

// check sounds
SoundsInstaller.checkAtStartup();

// create images from base64
new java.lang.Thread(new java.lang.Runnable()
{
	run: function()
	{
		try
		{
			createImages();
		} catch(e)
		{
			print("Error " + e);
		}
	}
}).start();

//########################################################################################################################################################
// MINECRAFT BUTTON LIBRARY
//########################################################################################################################################################

// Library version: 1.2.2
// Made by Dennis Motta, also known as Desno365
// https://github.com/Desno365/Minecraft-Button-Library

/*
	The MIT License (MIT)

	Copyright (c) 2015 Dennis Motta 

	Permission is hereby granted, free of charge, to any person obtaining a copy
	of this software and associated documentation files (the "Software"), to deal
	in the Software without restriction, including without limitation the rights
	to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
	copies of the Software, and to permit persons to whom the Software is
	furnished to do so, subject to the following conditions:

	The above copyright notice and this permission notice shall be included in all
	copies or substantial portions of the Software.

	THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
	IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
	FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
	AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
	LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
	OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
	SOFTWARE.
*/

var MinecraftButtonLibrary = {};

// Customization
// These are the default values of the library, you can change them to make the buttons look how you want to.
MinecraftButtonLibrary.defaultButtonPadding = 8;
MinecraftButtonLibrary.defaultButtonTextSize = 16;
MinecraftButtonLibrary.defaultButtonTextLineSpacing = 4;
MinecraftButtonLibrary.defaultButtonTextColor = "#FFDDDDDD";
MinecraftButtonLibrary.defaultButtonTextPressedColor = "#FFFBFF97";
MinecraftButtonLibrary.defaultButtonTextShadowColor = "#FF292929";

// Variables
MinecraftButtonLibrary.Resources = {};
MinecraftButtonLibrary.ProcessedResources = {};

MinecraftButtonLibrary.context = com.mojang.minecraftpe.MainActivity.currentMainActivity.get();
MinecraftButtonLibrary.metrics = new android.util.DisplayMetrics();
MinecraftButtonLibrary.context.getWindowManager().getDefaultDisplay().getMetrics(MinecraftButtonLibrary.metrics);
MinecraftButtonLibrary.sdcard = new android.os.Environment.getExternalStorageDirectory();
MinecraftButtonLibrary.LOG_TAG = "Minecraft Button Library ";

MinecraftButtonLibrary.ProcessedResources.font = null;
MinecraftButtonLibrary.ProcessedResources.mcNormalNineDrawable = null;
MinecraftButtonLibrary.ProcessedResources.mcPressedNineDrawable = null;

//########################################################################################################################################################
// LIBRARY
//########################################################################################################################################################

function MinecraftButton(textSize, enableSound)
{
	if(textSize == null)
		textSize = MinecraftButtonLibrary.defaultButtonTextSize;
	if(enableSound == null)
		enableSound = true;

	var button = new android.widget.Button(MinecraftButtonLibrary.context);
	button.setTextSize(textSize);
	button.setOnTouchListener(new android.view.View.OnTouchListener()
	{
		onTouch: function(v, motionEvent)
		{
			MinecraftButtonLibrary.onTouch(v, motionEvent, enableSound);
			return false;
		}
	});
	if (android.os.Build.VERSION.SDK_INT >= 14)
		button.setAllCaps(false);
	MinecraftButtonLibrary.setButtonBackground(button, MinecraftButtonLibrary.ProcessedResources.mcNormalNineDrawable);
	button.setTag(false); // is pressed?
	button.setSoundEffectsEnabled(false);
	button.setGravity(android.view.Gravity.CENTER);
	button.setTextColor(android.graphics.Color.parseColor(MinecraftButtonLibrary.defaultButtonTextColor));
	button.setPadding(MinecraftButtonLibrary.convertDpToPixel(MinecraftButtonLibrary.defaultButtonPadding), MinecraftButtonLibrary.convertDpToPixel(MinecraftButtonLibrary.defaultButtonPadding), MinecraftButtonLibrary.convertDpToPixel(MinecraftButtonLibrary.defaultButtonPadding), MinecraftButtonLibrary.convertDpToPixel(MinecraftButtonLibrary.defaultButtonPadding));
	button.setLineSpacing(MinecraftButtonLibrary.convertDpToPixel(MinecraftButtonLibrary.defaultButtonTextLineSpacing), 1);
	// apply custom font with shadow
	button.setTypeface(MinecraftButtonLibrary.ProcessedResources.font);
	button.setPaintFlags(button.getPaintFlags() | android.graphics.Paint.SUBPIXEL_TEXT_FLAG);
	if (android.os.Build.VERSION.SDK_INT >= 19) // KitKat
		button.setShadowLayer(1, Math.round((button.getLineHeight() - MinecraftButtonLibrary.convertDpToPixel(MinecraftButtonLibrary.defaultButtonTextLineSpacing)) / 8), Math.round((button.getLineHeight() - MinecraftButtonLibrary.convertDpToPixel(MinecraftButtonLibrary.defaultButtonTextLineSpacing)) / 8), android.graphics.Color.parseColor(MinecraftButtonLibrary.defaultButtonTextShadowColor));
	else
		button.setShadowLayer(0.0001, Math.round((button.getLineHeight() - MinecraftButtonLibrary.convertDpToPixel(MinecraftButtonLibrary.defaultButtonTextLineSpacing)) / 8), Math.round((button.getLineHeight() - MinecraftButtonLibrary.convertDpToPixel(MinecraftButtonLibrary.defaultButtonTextLineSpacing)) / 8), android.graphics.Color.parseColor(MinecraftButtonLibrary.defaultButtonTextShadowColor));

	return button;
}

// ######### BUTTON UTILS functions #########
MinecraftButtonLibrary.setButtonBackground = function(button, background)
{
	if (android.os.Build.VERSION.SDK_INT >= 16)
		button.setBackground(background);
	else
		button.setBackgroundDrawable(background);
}

MinecraftButtonLibrary.convertDpToPixel = function(dp)
{
	var density = MinecraftButtonLibrary.metrics.density;

	return (dp * density);
}

MinecraftButtonLibrary.onTouch = function(v, motionEvent, enableSound)
{
	var action = motionEvent.getActionMasked();
	if(action == android.view.MotionEvent.ACTION_DOWN)
	{
		// button pressed
		MinecraftButtonLibrary.changeToPressedState(v);
	}
	if(action == android.view.MotionEvent.ACTION_CANCEL || action == android.view.MotionEvent.ACTION_UP)
	{
		// button released
		MinecraftButtonLibrary.changeToNormalState(v);
		
		var rect = new android.graphics.Rect(v.getLeft(), v.getTop(), v.getRight(), v.getBottom());
		if(rect.contains(v.getLeft() + motionEvent.getX(), v.getTop() + motionEvent.getY())) // detect if the event happens inside the view
		{
			// onClick will run soon

			// play sound
			if(enableSound)
				Level.playSoundEnt(Player.getEntity(), "random.click", 100, 30);
		}
	}
	if(action == android.view.MotionEvent.ACTION_MOVE)
	{
		var rect = new android.graphics.Rect(v.getLeft(), v.getTop(), v.getRight(), v.getBottom());
		if(rect.contains(v.getLeft() + motionEvent.getX(), v.getTop() + motionEvent.getY())) // detect if the event happens inside the view
		{
			// pointer inside the view
			if(v.getTag() == false)
			{
				// restore pressed state
				v.setTag(true); // is pressed?

				MinecraftButtonLibrary.changeToPressedState(v);
			}
		} else
		{
			// pointer outside the view
			if(v.getTag() == true)
			{
				// restore pressed state
				v.setTag(false); // is pressed?

				MinecraftButtonLibrary.changeToNormalState(v);
			}
		}
	}
}

MinecraftButtonLibrary.changeToNormalState = function(button)
{
	MinecraftButtonLibrary.setButtonBackground(button, MinecraftButtonLibrary.ProcessedResources.mcNormalNineDrawable);
	button.setTextColor(android.graphics.Color.parseColor(MinecraftButtonLibrary.defaultButtonTextColor));
	// reset pressed padding
	button.setPadding(MinecraftButtonLibrary.convertDpToPixel(MinecraftButtonLibrary.defaultButtonPadding), MinecraftButtonLibrary.convertDpToPixel(MinecraftButtonLibrary.defaultButtonPadding), MinecraftButtonLibrary.convertDpToPixel(MinecraftButtonLibrary.defaultButtonPadding), MinecraftButtonLibrary.convertDpToPixel(MinecraftButtonLibrary.defaultButtonPadding));
}

MinecraftButtonLibrary.changeToPressedState = function(button)
{
	MinecraftButtonLibrary.setButtonBackground(button, MinecraftButtonLibrary.ProcessedResources.mcPressedNineDrawable);
	button.setTextColor(android.graphics.Color.parseColor(MinecraftButtonLibrary.defaultButtonTextPressedColor));
	// make the effect of a pressed button with padding
	button.setPadding(MinecraftButtonLibrary.convertDpToPixel(MinecraftButtonLibrary.defaultButtonPadding), MinecraftButtonLibrary.convertDpToPixel(MinecraftButtonLibrary.defaultButtonPadding) + MinecraftButtonLibrary.convertDpToPixel(2), MinecraftButtonLibrary.convertDpToPixel(MinecraftButtonLibrary.defaultButtonPadding), MinecraftButtonLibrary.convertDpToPixel(MinecraftButtonLibrary.defaultButtonPadding) - MinecraftButtonLibrary.convertDpToPixel(2));
}
// ######### END - BUTTON UTILS functions #########


// ######### CREATE NINE PATCH functions #########
MinecraftButtonLibrary.createNinePatchDrawables = function()
{
	var mcButtonNormalBitmap = MinecraftButtonLibrary.getMinecraftButtonBitmap();
	var mcButtonPressedBitmap = MinecraftButtonLibrary.getMinecraftButtonPressedBitmap();

	var mcNormalNinePatch = new android.graphics.NinePatch(mcButtonNormalBitmap, mcButtonNormalBitmap.getNinePatchChunk(), null);
	var mcPressedNinePatch = new android.graphics.NinePatch(mcButtonPressedBitmap, mcButtonPressedBitmap.getNinePatchChunk(), null);

	// here is used a deprecated method that doesn't deals with density
	//noinspection deprecation
	MinecraftButtonLibrary.ProcessedResources.mcNormalNineDrawable = new android.graphics.drawable.NinePatchDrawable(mcNormalNinePatch);
	MinecraftButtonLibrary.ProcessedResources.mcNormalNineDrawable.setFilterBitmap(false);
	//noinspection deprecation
	MinecraftButtonLibrary.ProcessedResources.mcPressedNineDrawable = new android.graphics.drawable.NinePatchDrawable(mcPressedNinePatch);
	MinecraftButtonLibrary.ProcessedResources.mcPressedNineDrawable.setFilterBitmap(false);
}

MinecraftButtonLibrary.getMinecraftButtonBitmap = function()
{
	var density = MinecraftButtonLibrary.metrics.density;

	if(density < 1)
	{
		ModPE.log(MinecraftButtonLibrary.LOG_TAG + "Density: " + density + ", ldpi");
		return MinecraftButtonLibrary.decodeImageFromBase64(MinecraftButtonLibrary.Resources.minecraftButtonStateNormalLDPI);
	}
	if(density >= 1 && density < 1.5)
	{
		ModPE.log(MinecraftButtonLibrary.LOG_TAG + "Density: " + density + ", mdpi");
		return MinecraftButtonLibrary.decodeImageFromBase64(MinecraftButtonLibrary.Resources.minecraftButtonStateNormalMDPI);
	}
	if(density >= 1.5 && density < 2)
	{
		ModPE.log(MinecraftButtonLibrary.LOG_TAG + "Density: " + density + ", hdpi");
		return MinecraftButtonLibrary.decodeImageFromBase64(MinecraftButtonLibrary.Resources.minecraftButtonStateNormalHDPI);
	}
	if(density >= 2 && density < 2.5)
	{
		ModPE.log(MinecraftButtonLibrary.LOG_TAG + "Density: " + density + ", xhdpi");
		return MinecraftButtonLibrary.decodeImageFromBase64(MinecraftButtonLibrary.Resources.minecraftButtonStateNormalXHDPI);
	}
	if(density >= 2.5)
	{
		ModPE.log(MinecraftButtonLibrary.LOG_TAG + "Density: " + density + ", xxhdpi");
		return MinecraftButtonLibrary.decodeImageFromBase64(MinecraftButtonLibrary.Resources.minecraftButtonStateNormalXXHDPI);
	}

	ModPE.log(MinecraftButtonLibrary.LOG_TAG + "Error: " + density + ", xhdpi");
	return MinecraftButtonLibrary.decodeImageFromBase64(MinecraftButtonLibrary.Resources.minecraftButtonStateNormalXHDPI);
}

MinecraftButtonLibrary.getMinecraftButtonPressedBitmap = function()
{
	var density = MinecraftButtonLibrary.metrics.density;

	if(density < 1)
	{
		ModPE.log(MinecraftButtonLibrary.LOG_TAG + "Density: " + density + ", ldpi");
		return MinecraftButtonLibrary.decodeImageFromBase64(MinecraftButtonLibrary.Resources.minecraftButtonStatePressedLDPI);
	}
	if(density >= 1 && density < 1.5)
	{
		ModPE.log(MinecraftButtonLibrary.LOG_TAG + "Density: " + density + ", mdpi");
		return MinecraftButtonLibrary.decodeImageFromBase64(MinecraftButtonLibrary.Resources.minecraftButtonStatePressedMDPI);
	}
	if(density >= 1.5 && density < 2)
	{
		ModPE.log(MinecraftButtonLibrary.LOG_TAG + "Density: " + density + ", hdpi");
		return MinecraftButtonLibrary.decodeImageFromBase64(MinecraftButtonLibrary.Resources.minecraftButtonStatePressedHDPI);
	}
	if(density >= 2 && density < 2.5)
	{
		ModPE.log(MinecraftButtonLibrary.LOG_TAG + "Density: " + density + ", xhdpi");
		return MinecraftButtonLibrary.decodeImageFromBase64(MinecraftButtonLibrary.Resources.minecraftButtonStatePressedXHDPI);
	}
	if(density >= 2.5)
	{
		ModPE.log(MinecraftButtonLibrary.LOG_TAG + "Density: " + density + ", xxhdpi");
		return MinecraftButtonLibrary.decodeImageFromBase64(MinecraftButtonLibrary.Resources.minecraftButtonStatePressedXXHDPI);
	}

	ModPE.log(MinecraftButtonLibrary.LOG_TAG + "Error: " + density + ", xhdpi");
	return MinecraftButtonLibrary.decodeImageFromBase64(MinecraftButtonLibrary.Resources.minecraftButtonStatePressedXHDPI);
}

MinecraftButtonLibrary.decodeImageFromBase64 = function(base64String)
{
	var byteArray = android.util.Base64.decode(base64String, 0);
	return android.graphics.BitmapFactory.decodeByteArray(byteArray, 0, byteArray.length);
}
// ######### END - CREATE NINE PATCH functions #########


// ######### CREATE TYPEFACE functions #########
MinecraftButtonLibrary.createTypeface = function()
{
	MinecraftButtonLibrary.writeFileFromByteArray(android.util.Base64.decode(MinecraftButtonLibrary.Resources.base64Font, 0), MinecraftButtonLibrary.sdcard + "/minecraft.ttf");
	MinecraftButtonLibrary.ProcessedResources.font = android.graphics.Typeface.createFromFile(MinecraftButtonLibrary.sdcard + "/minecraft.ttf");
	MinecraftButtonLibrary.deleteFile(MinecraftButtonLibrary.sdcard + "/minecraft.ttf");
}

MinecraftButtonLibrary.writeFileFromByteArray = function(byteArray, path)
{
	var file = new java.io.File(path);
	if(file.exists())
		file.delete();
	file.createNewFile();
	var stream = new java.io.FileOutputStream(file);
	stream.write(byteArray);
	stream.close();
	byteArray = null;
}
// ######### END - CREATE TYPEFACE functions #########


// ######### UTILS functions #########
MinecraftButtonLibrary.removeResources = function()
{
	MinecraftButtonLibrary.Resources.minecraftButtonStateNormalLDPI = null;
	MinecraftButtonLibrary.Resources.minecraftButtonStateNormalMDPI = null;
	MinecraftButtonLibrary.Resources.minecraftButtonStateNormalHDPI = null;
	MinecraftButtonLibrary.Resources.minecraftButtonStateNormalXHDPI = null;
	MinecraftButtonLibrary.Resources.minecraftButtonStateNormalXXHDPI = null;
	MinecraftButtonLibrary.Resources.minecraftButtonStatePressedLDPI = null;
	MinecraftButtonLibrary.Resources.minecraftButtonStatePressedMDPI = null;
	MinecraftButtonLibrary.Resources.minecraftButtonStatePressedHDPI = null;
	MinecraftButtonLibrary.Resources.minecraftButtonStatePressedXHDPI = null;
	MinecraftButtonLibrary.Resources.minecraftButtonStatePressedXXHDPI = null;

	MinecraftButtonLibrary.Resources.base64Font = null;
}

MinecraftButtonLibrary.deleteFile = function(path)
{
	var file = new java.io.File(path);

	if(file.isDirectory())
	{
		var directoryFiles = file.listFiles();
		for(var i in directoryFiles)
		{
			deleteFile(directoryFiles[i].getAbsolutePath());
		}
		file.delete();
	}

	if(file.isFile())
		file.delete();
}
// ######### END - UTILS functions #########


//########################################################################################################################################################
// RESOURCES IN BASE64
//########################################################################################################################################################

// backgrounds
MinecraftButtonLibrary.Resources.minecraftButtonStateNormalLDPI = "iVBORw0KGgoAAAANSUhEUgAAAAgAAAAICAYAAADED76LAAAAGG5wT2wAAAAAAAAAAAAAAAAAAAAAAAAAAP8AAADYHRhkAAAAVG5wVGMAAgIJIAAAACgAAAAAAAACAAAAAgAAAAMAAAACMAAAAAAAAAEAAAAHAAAAAgAAAAf/vLGr/7yxqwAAAAH/vLGr/5WGgQAAAAH/cmVnAAAAAf8oJyoMgs1WAAAASUlEQVQY02Pcs3H1fwY8gAmf5NYtexhYGBgYGG5evYZVwfZDh/GbwPD/PwEFjIwEFBByJAPDfwaWbVv2MGw7eIiBgRFuLrIdDADq5BFxvezsVAAAAABJRU5ErkJggg==";
MinecraftButtonLibrary.Resources.minecraftButtonStateNormalMDPI = "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAGG5wT2wAAAAAAAAAAAAAAAAAAAAAAAAAAP8AAADYHRhkAAAAVG5wVGMAAgIJIAAAACgAAAAAAAAEAAAABAAAAAYAAAAEMAAAAAAAAAIAAAAOAAAABAAAAA7/vLGr/7yxqwAAAAH/vLGr/5WGgQAAAAH/cmVnAAAAAf8oJyqdu2NqAAAAT0lEQVQ4y2Pcs3H1fwYKABMDhYCFXI1bt+yhsgtuXr1Gksbthw4PcBgw/P8/0C5gZKSOCwbeAPLDgIFasbANmqa3HTwEDV2M4MYVDdRxAQBscxGJWBLxyQAAAABJRU5ErkJggg==";
MinecraftButtonLibrary.Resources.minecraftButtonStateNormalHDPI = "iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAAAGG5wT2wAAAAAAAAAAAAAAAAAAAAAAAAAAP8AAADYHRhkAAAAVG5wVGMAAgIJIAAAACgAAAAAAAAGAAAABgAAAAkAAAAGMAAAAAAAAAMAAAAVAAAABgAAABX/vLGr/7yxqwAAAAH/vLGr/5WGgQAAAAH/cmVnAAAAAf8oJyqPt1DfAAAAV0lEQVRIx2Pcs3H1fwYaAiYGGgOaW8BCC0O3btkzXIPo5tVrVDF0+6HDo6mIAPj/fzSICABGxmEURKMWDFAqYhhWGW0bUu2z7eAhpMyCMxcRk9OGURABAH/ZEZn4HdB3AAAAAElFTkSuQmCC";
MinecraftButtonLibrary.Resources.minecraftButtonStateNormalXHDPI = "iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAAGG5wT2wAAAAAAAAAAAAAAAAAAAAAAAAAAP8AAADYHRhkAAAAVG5wVGMAAgIJIAAAACgAAAAAAAAIAAAACAAAAAwAAAAIMAAAAAAAAAQAAAAcAAAACAAAABz/vLGr/7yxqwAAAAH/vLGr/5WGgQAAAAH/cmVnAAAAAf8oJypkuTlTAAAAZUlEQVRYw2Pcs3H1f4YBBEwMAwxGHcBCbwu3btkzGgWDPA3cvHqNphZuP3R4NApGeDnA8P//aBSM9DTAyDgaBaMOGHXASC8HGEbrgsGWBrahtdO3HTyEVnYTLNxJrQxGo2BwOQAAWckRqcYME3kAAAAASUVORK5CYII=";
MinecraftButtonLibrary.Resources.minecraftButtonStateNormalXXHDPI = "iVBORw0KGgoAAAANSUhEUgAAADAAAAAwCAYAAABXAvmHAAAAGG5wT2wAAAAAAAAAAAAAAAAAAAAAAAAAAP8AAADYHRhkAAAAVG5wVGMAAgIJIAAAACgAAAAAAAAMAAAADAAAABIAAAAMMAAAAAAAAAYAAAAqAAAADAAAACr/vLGr/7yxqwAAAAH/vLGr/5WGgQAAAAH/cmVnAAAAAf8oJypAoV45AAAAg0lEQVRo3u3ZwQmAMAyF4UTcfxFPgtZLL9YZFJwmTtCDINQ0/5sgHzxCQzXPk4njDOI8AABEB4xeBl2XTIUAAAi1he7z+tWgWzmoEAAAvIVaxowKAQDAFmoZVSoEAAAAAAAAAIj7FhIuMgAA+txCqfL3lPZSuYxen1JfnWRUCACAHgEPIUcRyZ0dVsEAAAAASUVORK5CYII=";
MinecraftButtonLibrary.Resources.minecraftButtonStatePressedLDPI = "iVBORw0KGgoAAAANSUhEUgAAAAgAAAAICAYAAADED76LAAAAGG5wT2wAAAAAAAAAAAAAAAAAAAAAAAAAAP8AAADYHRhkAAAAVG5wVGMAAgIJIAAAACgAAAAAAAACAAAAAgAAAAIAAAADMAAAAAAAAAEAAAAHAAAAAQAAAAb/KCcqAAAAAf9yZWcAAAABAAAAAQAAAAEAAAABAAAAAQAAAAGZYAV4AAAAb0lEQVQY012OQQqDMBRE34Scwp1QsHgHs7CbGnv9UjzNuIjRxuHD/wzzhq/nMBrKIIENAhA5TUQwS0pUiZIFeK8zEVSAQy5Vpxdq3k3HdYbLq2xTRwBht2T9QxJxSRP588I2d9kmPvqO7ftryb+9AxX7IG5YZYu3AAAAAElFTkSuQmCC";
MinecraftButtonLibrary.Resources.minecraftButtonStatePressedMDPI = "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAGG5wT2wAAAAAAAAAAAAAAAAAAAAAAAAAAP8AAADYHRhkAAAAVG5wVGMAAgIJIAAAACgAAAAAAAAEAAAABAAAAAQAAAAGMAAAAAAAAAIAAAAOAAAAAgAAAAz/KCcqAAAAAf9yZWcAAAABAAAAAQAAAAEAAAABAAAAAQAAAAEDO+tuAAAAkklEQVQ4y62SwQrCMAyGvwyfwpswcOwd7EEvbu71Zfg08ZIgi10ZtLm0CSn5/r+R4ToqAGwPRCy3gqV+mdMNgI7KOPnIKaVsgw/WUH++7s0IZCsxhP5Myfa184CgVf5cyJvTgiDarUYixV/wQrtfUC1rjiRim1pPMNlOz8vDSPTQQ++rJ+gvZwA+77WseSevJvgCGagihHTV1j0AAAAASUVORK5CYII=";
MinecraftButtonLibrary.Resources.minecraftButtonStatePressedHDPI = "iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAAAGG5wT2wAAAAAAAAAAAAAAAAAAAAAAAAAAP8AAADYHRhkAAAAVG5wVGMAAgIJIAAAACgAAAAAAAAGAAAABgAAAAYAAAAJMAAAAAAAAAMAAAAVAAAAAwAAABL/KCcqAAAAAf9yZWcAAAABAAAAAQAAAAEAAAABAAAAAQAAAAGqizz1AAAAl0lEQVRIx92VwQqAIAyGXfQU3YKg6B3yUJe0Xj+ip1k3+QOHGXhoO+l0Ch/flIZ+ZBMiPjREkIcFSOPE2ymMK1M4il9QIwtnbbIAqbCwZ91mXYgoLoUQ/NQrWavMIiMYQqJHadVUIJK6iAEXZTUaLihrNOY8WyRcBM+7AkQOfh+/L4CLPx+KtQoQdW0TJtdx5tnyIv9/RDcytSKUL7bTXAAAAABJRU5ErkJggg==";
MinecraftButtonLibrary.Resources.minecraftButtonStatePressedXHDPI = "iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAAGG5wT2wAAAAAAAAAAAAAAAAAAAAAAAAAAP8AAADYHRhkAAAAVG5wVGMAAgIJIAAAACgAAAAAAAAIAAAACAAAAAgAAAAMMAAAAAAAAAQAAAAcAAAABAAAABj/KCcqAAAAAf9yZWcAAAABAAAAAQAAAAEAAAABAAAAAQAAAAHs/TEDAAAAqUlEQVRYw+2WwQqAIAyGXfQU3YKg6B3yUJe0Xj+ip1ln/8AhBnrYbroxhe/frzSNM5sg4ktDBHkogDRueLsE68YUDr1Ai5CdtUkNEDkL9fuxKoLqNEDxMRaCv0aR1E8R1OcDRphrEp0gzTgUQQ0akMydQROU9RZggSKo7y1gzptzSRMEf0pFUF4DDv7p/txAE/zrgdhPEZTXwNB3wcZz3XlznphXBMUv8AJ9bSKkEsE9twAAAABJRU5ErkJggg==";
MinecraftButtonLibrary.Resources.minecraftButtonStatePressedXXHDPI = "iVBORw0KGgoAAAANSUhEUgAAADAAAAAwCAYAAABXAvmHAAAAGG5wT2wAAAAAAAAAAAAAAAAAAAAAAAAAAP8AAADYHRhkAAAAVG5wVGMAAgIJIAAAACgAAAAAAAALAAAACwAAAAsAAAARMAAAAAAAAAYAAAAqAAAABgAAACT/KCcqAAAAAf9yZWcAAAABAAAAAQAAAAEAAAABAAAAAQAAAAGV/cSjAAAAzElEQVRo3u2ZQQrCMBBFM9JTuBMEi3cwC93Y6vVFPM14gfzFQIpMfLNMJk0ffD5/WptPZy/Nii0XM9EvDoh2tbHWS3N9V5IXAAD8O8CkbGWptcsFymw8+Jz744qEAABgUBeyWFQJluvw1OVeJAQAAKNmoRLMMBZOQ31CFRICAID8LhQdpVy4UyzbRCcydQAJAQDAqBOZ+7bZJupOJr5+IyEAAMjuQov497Q+b8Kd/Ccvqu5FQgAAkN2Fjod9c+Pzem+bbTr1IyEAAEheX2f8IsSeFAnbAAAAAElFTkSuQmCC";

// font
MinecraftButtonLibrary.Resources.base64Font = "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";

//########################################################################################################################################################
// START CREATION OF RESOURCES
//########################################################################################################################################################

new java.lang.Thread(new java.lang.Runnable()
{
	run: function()
	{
		try
		{
			MinecraftButtonLibrary.createNinePatchDrawables();
			MinecraftButtonLibrary.createTypeface();

			MinecraftButtonLibrary.removeResources();
		} catch(e)
		{
			print("Error " + e);
		}
	}
}).start();

